/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.mascot.Header;
import com.compomics.mascotdatfile.util.mascot.Masses;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.Parameters;
import com.compomics.mascotdatfile.util.mascot.PeptideToQueryMap;
import com.compomics.mascotdatfile.util.mascot.ProteinMap;
import com.compomics.mascotdatfile.util.mascot.Quantitation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.index.Controller;
import com.compomics.mascotdatfile.util.mascot.index.DecoyQueryToPeptideMap_Index;
import com.compomics.mascotdatfile.util.mascot.index.QueryToPeptideMap_Index;
import com.compomics.mascotdatfile.util.mascot.index.SummaryIndex;
import com.compomics.mascotdatfile.util.mascot.iterator.QueryEnumerator;
import java.io.BufferedReader;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MascotDatfile_Index
implements MascotDatfileInf {
    private static Logger logger = Logger.getLogger(MascotDatfile_Index.class);
    private Controller iController = null;
    private Header iHeader = null;
    private Masses iMasses = null;
    private ModificationList iModificationList = null;
    private Parameters iParameters = null;
    private PeptideToQueryMap iPeptideToQueryMap = null;
    private ProteinMap iProteinMap = null;
    private ProteinMap iDecoyProteinMap = null;
    private QueryToPeptideMap_Index iQueryToPeptideMap = null;
    private DecoyQueryToPeptideMap_Index iDecoyQueryToPeptideMap = null;
    private HashMap iQuerynumberToSpectrumfilename = null;
    private Quantitation iQuantitation;
    private double[][] iThreshold = null;
    private double[][] iDecoyThreshold = null;
    private String iFileName = null;

    public MascotDatfile_Index(String aDatFile) {
        File inputFile = new File(aDatFile);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("raw Mascot datfile from " + aDatFile + " does not exist.");
        }
        this.iController = new Controller(inputFile);
        this.setFileName(new File(aDatFile).getName());
    }

    public MascotDatfile_Index(BufferedReader aReader) {
        this(aReader, "NA");
    }

    public MascotDatfile_Index(BufferedReader aReader, String aFileName) {
        this.iController = new Controller(aReader);
        this.setFileName(aFileName);
    }

    public Header getHeaderSection() {
        if (this.iHeader == null) {
            this.iHeader = new Header(this.iController.readSectionAsHashMap("header"));
        }
        return this.iHeader;
    }

    public Masses getMasses() {
        if (this.iMasses == null) {
            this.iMasses = new Masses(this.iController.readSectionAsHashMap("masses"));
        }
        return this.iMasses;
    }

    public Quantitation getQuantitation() {
        if (this.iQuantitation == null) {
            this.iQuantitation = new Quantitation(this.iController.readSection("quantitation"));
        }
        return this.iQuantitation;
    }

    public ModificationList getModificationList() {
        if (this.iModificationList == null) {
            Masses m = this.getMasses();
            if (m.getFixedModifications().size() > 0) {
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications());
            } else {
                Parameters p = this.getParametersSection();
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications(), p.getFixedModifications());
            }
        }
        return this.iModificationList;
    }

    public ModificationList getModificationList(Connection iConnection) {
        if (this.iModificationList == null) {
            Masses m = this.getMasses();
            if (m.getFixedModifications().size() > 0) {
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications(), iConnection);
            } else {
                Parameters p = this.getParametersSection();
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications(), p.getFixedModifications(), iConnection);
            }
        }
        return this.iModificationList;
    }

    public int getNumberOfQueries() {
        return this.getHeaderSection().getQueries();
    }

    public QueryToPeptideMap_Index getQueryToPeptideMap() {
        if (this.iQueryToPeptideMap == null) {
            this.iQueryToPeptideMap = new QueryToPeptideMap_Index(this.iController, this.getProteinMap(), this.getModificationList());
        }
        return this.iQueryToPeptideMap;
    }

    public QueryToPeptideMap_Index getQueryToPeptideMap(Connection iConn) {
        if (this.iQueryToPeptideMap == null) {
            this.iQueryToPeptideMap = new QueryToPeptideMap_Index(this.iController, this.getProteinMap(), this.getModificationList(iConn));
        }
        return this.iQueryToPeptideMap;
    }

    public QueryToPeptideMap_Index getDecoyQueryToPeptideMap() {
        return this.getDecoyQueryToPeptideMap(true);
    }

    public QueryToPeptideMap_Index getDecoyQueryToPeptideMap(boolean showErrorMessage) {
        if (this.iDecoyQueryToPeptideMap == null) {
            this.iDecoyQueryToPeptideMap = new DecoyQueryToPeptideMap_Index(this.iController, this.getDecoyProteinMap(), this.getModificationList());
        }
        return this.iDecoyQueryToPeptideMap;
    }

    public Vector getQueryList() {
        Vector<Query> iQueryList = null;
        if (iQueryList == null) {
            int lNumQueries = this.iController.getNumberOfQueries();
            iQueryList = new Vector<Query>(lNumQueries);
            for (int i = 1; i < lNumQueries + 1; ++i) {
                iQueryList.add(this.getQuery(i));
            }
        }
        return iQueryList;
    }

    public Iterator getQueryIterator() {
        return new Iterator(){
            private int lCounter = 0;

            public boolean hasNext() {
                return this.lCounter < MascotDatfile_Index.this.getNumberOfQueries();
            }

            public Query next() {
                ++this.lCounter;
                return MascotDatfile_Index.this.getQuery(this.lCounter);
            }

            public void remove() {
            }
        };
    }

    public Query getQuery(int aQueryNumber) {
        Query q = null;
        HashMap lQuerySection = this.iController.readSectionAsHashMap("query" + aQueryNumber);
        double lPrecursorMass = Double.parseDouble(this.iController.readSummary(aQueryNumber, SummaryIndex.QMASS));
        String lMzAndChargeString = this.iController.readSummary(aQueryNumber, SummaryIndex.QEXP);
        StringTokenizer st = new StringTokenizer(lMzAndChargeString, ",");
        double lPrecursorMZ = Double.parseDouble(st.nextToken());
        String lCharge = st.nextToken();
        if (st.hasMoreTokens()) {
            throw new MascotDatfileException("There are tokens left unused!");
        }
        double lPrecursorIntensity = -1.0;
        if (SummaryIndex.getInstance().getIntensity_index() != -1) {
            lPrecursorIntensity = Double.parseDouble(this.iController.readSummary(aQueryNumber, SummaryIndex.QINTENSITY));
        }
        q = new Query(lQuerySection, lPrecursorMZ, lCharge, lPrecursorMass, lPrecursorIntensity, aQueryNumber, this.getParametersSection());
        return q;
    }

    public QueryEnumerator getQueryEnumerator() {
        return new QueryEnumerator(this);
    }

    public Parameters getParametersSection() {
        if (this.iParameters == null) {
            this.iParameters = new Parameters(this.iController.readSectionAsHashMap("parameters"));
        }
        return this.iParameters;
    }

    public PeptideToQueryMap getPeptideToQueryMap() {
        if (this.iPeptideToQueryMap == null) {
            this.iPeptideToQueryMap = new PeptideToQueryMap(this.getQueryToPeptideMap(), this.getQueryList());
        }
        return this.iPeptideToQueryMap;
    }

    public ProteinMap getProteinMap() {
        HashMap m;
        if (this.iProteinMap == null && (m = this.iController.readSectionAsHashMap("proteins")) != null) {
            this.iProteinMap = new ProteinMap(m);
        }
        return this.iProteinMap;
    }

    public ProteinMap getDecoyProteinMap() {
        HashMap m;
        if (this.iDecoyProteinMap == null && (m = this.iController.readSectionAsHashMap("decoy_proteins")) != null) {
            this.iDecoyProteinMap = new ProteinMap(m);
        }
        return this.iDecoyProteinMap;
    }

    public HashMap getSpectrumFilenameToQuerynumberMap() {
        if (this.iQuerynumberToSpectrumfilename == null) {
            this.iQuerynumberToSpectrumfilename = new HashMap();
            for (int i = 0; i < this.getNumberOfQueries(); ++i) {
                Query lQuery = this.getQuery(i + 1);
                int lQueryNumber = lQuery.getQueryNumber();
                String lQueryTitle = lQuery.getTitle();
                this.iQuerynumberToSpectrumfilename.put(lQueryTitle, new Integer(lQueryNumber));
            }
        }
        return this.iQuerynumberToSpectrumfilename;
    }

    public String getFileName() {
        if (this.iFileName == null) {
            return "NA";
        }
        return this.iFileName;
    }

    public void setFileName(String aFileName) {
        this.iFileName = aFileName;
    }

    public void finish() {
        this.iController.close();
    }
}

