/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.index;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.mascot.index.ByteOffset;
import com.compomics.mascotdatfile.util.mascot.index.PeptideLineIndex;
import com.compomics.mascotdatfile.util.mascot.index.SummaryIndex;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FileIndexer {
    private static Logger logger = Logger.getLogger(FileIndexer.class);
    private HashMap<String, ByteOffset> iSectionMap = null;
    private SummaryIndex iSummaryIndex = SummaryIndex.getInstance();
    private SummaryIndex iDecoySummaryIndex = SummaryIndex.getDecoyInstance();
    private HashMap<Integer, Long> iLineList = null;
    private ArrayList<ByteOffset> iQueryList = null;
    private ArrayList<PeptideLineIndex> iPeptideLineList;
    private ArrayList<PeptideLineIndex> iDecoyPeptideLineList;

    public FileIndexer() {
        this.iSectionMap = new HashMap();
        this.iLineList = new HashMap();
        this.iQueryList = new ArrayList(1000);
        this.iPeptideLineList = new ArrayList(10000);
        this.iDecoyPeptideLineList = new ArrayList();
    }

    protected ByteOffset getSectionIndex(String aSectionName) {
        if (aSectionName.startsWith("query")) {
            Integer lQueryNumber = Integer.parseInt(aSectionName.substring(5));
            lQueryNumber = lQueryNumber - 1;
            return this.iQueryList.get(lQueryNumber);
        }
        return this.iSectionMap.get(aSectionName);
    }

    protected void addSectionIndex(String aSectionName, ByteOffset aByteIndex) {
        if (aSectionName.startsWith("query")) {
            Integer lQueryNumber = Integer.parseInt(aSectionName.substring(5));
            this.iQueryList.add(aByteIndex);
        } else {
            this.iSectionMap.put(aSectionName, aByteIndex);
        }
    }

    protected long getLineIndex(int aLineNumber) {
        if (this.iLineList.get(aLineNumber) != null) {
            return this.iLineList.get(aLineNumber);
        }
        throw new MascotDatfileException("Line number '" + aLineNumber + "' was not indexed and can therefore not be accessed.");
    }

    protected void addLineIndex(int aLine, long aByte) {
        this.iLineList.put(aLine, aByte);
    }

    protected long getPeptideLineIndex(int aQueryNumber, int aPeptideHitNumber) {
        int lLineNumber;
        if ((lLineNumber = this.iPeptideLineList.get(--aQueryNumber).getLine(aPeptideHitNumber)) != -1) {
            return this.getLineIndex(lLineNumber);
        }
        return -1L;
    }

    public long getDecoyPeptideLineIndex(int aQueryNumber, int aPeptideHitNumber) {
        int lLineNumber;
        if ((lLineNumber = this.iDecoyPeptideLineList.get(--aQueryNumber).getLine(aPeptideHitNumber)) != -1) {
            return this.getLineIndex(lLineNumber);
        }
        return -1L;
    }

    protected void addPeptideLineIndex(Integer[] aLines) {
        this.iPeptideLineList.add(new PeptideLineIndex(aLines));
    }

    protected void addDecoyPeptideLineIndex(Integer[] aLines) {
        this.iDecoyPeptideLineList.add(new PeptideLineIndex(aLines));
    }

    protected int getNumberOfPeptides(int aQueryNumber) {
        return this.iPeptideLineList.get(--aQueryNumber).getNumberOfPeptides();
    }

    protected int getNumberOfDecoyPeptides(int aQueryNumber) {
        return this.iDecoyPeptideLineList.get(--aQueryNumber).getNumberOfPeptides();
    }

    protected int getNumberOfQueries() {
        return this.iPeptideLineList.size();
    }

    public long getSummaryLineIndex(int aQueryNumber, int aSummaryIndex) {
        int lLineNumber = this.iSummaryIndex.getSummaryLine(aQueryNumber, aSummaryIndex);
        return this.getLineIndex(lLineNumber);
    }

    public long getDecoySummaryLineIndex(int aQueryNumber, int aSummaryIndex) {
        int lLineNumber = this.iDecoySummaryIndex.getSummaryLine(aQueryNumber, aSummaryIndex);
        return this.getLineIndex(lLineNumber);
    }
}

