/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.parser;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XTandemIdfileReader
extends ExperimentObject
implements IdfileReader {
    private XTandemFile xTandemFile = null;
    private ModificationMap modificationMap;
    private PeptideMap peptideMap;
    private HashMap<String, LinkedList<Peptide>> foundPeptidesMap;
    private int peptideMapKeyLength;

    public XTandemIdfileReader() {
    }

    public XTandemIdfileReader(File aFile) throws SAXException, ParserConfigurationException {
        this.xTandemFile = new XTandemFile(aFile.getPath(), true);
        this.peptideMap = this.xTandemFile.getPeptideMap();
        this.modificationMap = this.xTandemFile.getModificationMap();
    }

    @Override
    public String getExtension() {
        return "t.xml";
    }

    public String getFileName() {
        File tempFile = new File(this.xTandemFile.getFileName());
        return tempFile.getName();
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (sequenceMatchingPreferences != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            this.peptideMapKeyLength = sequenceFactory.getDefaultProteinTree().getInitialTagSize();
            this.foundPeptidesMap = new HashMap(1024);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(this.xTandemFile.getSpectraNumber());
        }
        HashMap<Integer, String> idToSpectrumTitleMap = this.xTandemFile.getXTandemParser().getIdToSpectrumMap();
        for (String id : this.peptideMap.getSpectrumAndPeptideMap().keySet()) {
            Integer spectrumNumber = new Integer(id.substring(1));
            String tempTitle = idToSpectrumTitleMap.get(spectrumNumber);
            String spectrumName = this.fixMgfTitle(tempTitle);
            if (spectrumName.contains("RTINSECONDS=")) {
                spectrumName = spectrumName.substring(0, spectrumName.indexOf("RTINSECONDS="));
            }
            spectrumName = spectrumName.trim();
            ArrayList<de.proteinms.xtandemparser.xtandem.Peptide> spectrumPeptides = this.peptideMap.getAllPeptides(spectrumNumber);
            if (spectrumPeptides.size() > 0) {
                String tempFile = this.xTandemFile.getInputParameters().getSpectrumPath();
                String filename = Util.getFileName(tempFile);
                Integer parsedCharge = new Integer(this.xTandemFile.getXTandemParser().getRawSpectrumMap().get("z" + spectrumNumber));
                Charge charge = new Charge(1, parsedCharge);
                String spectrumKey = Spectrum.getSpectrumKey(filename, spectrumName);
                SpectrumMatch currentMatch = new SpectrumMatch(spectrumKey);
                currentMatch.setSpectrumNumber(spectrumNumber);
                HashMap hitMap = new HashMap();
                for (de.proteinms.xtandemparser.xtandem.Peptide peptide : spectrumPeptides) {
                    for (Domain domain : peptide.getDomains()) {
                        if (!hitMap.containsKey(domain.getDomainExpect())) {
                            hitMap.put(domain.getDomainExpect(), new ArrayList());
                        }
                        ((ArrayList)hitMap.get(domain.getDomainExpect())).add(domain);
                    }
                }
                ArrayList eValues = new ArrayList(hitMap.keySet());
                Collections.sort(eValues);
                int rank = 1;
                for (Double eValue : eValues) {
                    int rankIncrease = 0;
                    for (Domain domain : (ArrayList)hitMap.get(eValue)) {
                        PeptideAssumption peptideAssumption = this.getPeptideAssumption(domain, charge.value, rank, sequenceMatchingPreferences);
                        Peptide peptide = peptideAssumption.getPeptide();
                        boolean found = false;
                        if (currentMatch.getAllAssumptions() != null) {
                            for (SpectrumIdentificationAssumption loadedAssumption : currentMatch.getAllAssumptions()) {
                                PeptideAssumption tempAssumption = (PeptideAssumption)loadedAssumption;
                                if (!tempAssumption.getPeptide().isSameSequenceAndModificationStatus(peptide, SequenceMatchingPreferences.defaultStringMatching) || !tempAssumption.getPeptide().sameModificationsAs(peptideAssumption.getPeptide())) continue;
                                found = true;
                            }
                        }
                        if (found) continue;
                        ++rankIncrease;
                        if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                            for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptideAssumption.getPeptide().getSequence())) {
                                Peptide newPeptide = new Peptide(expandedSequence.toString(), peptide.getModificationMatches());
                                ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
                                for (ModificationMatch modificationMatch : modificationMatches) {
                                    newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                                }
                                PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                                currentMatch.addHit(Advocate.xtandem.getIndex(), newAssumption, false);
                            }
                            continue;
                        }
                        currentMatch.addHit(Advocate.xtandem.getIndex(), peptideAssumption, false);
                    }
                    rank += rankIncrease;
                }
                result.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressCounter();
        }
        return result;
    }

    private PeptideAssumption getPeptideAssumption(Domain domain, int charge, int rank, SequenceMatchingPreferences sequenceMatchingPreferences) {
        String sequence = domain.getDomainSequence();
        ArrayList<ModificationMatch> foundModifications = new ArrayList<ModificationMatch>();
        ArrayList<Modification> foundVariableModifications = this.modificationMap.getVariableModifications(domain.getDomainKey());
        for (Modification currentModification : foundVariableModifications) {
            int location = new Integer(currentModification.getLocation()) - domain.getDomainStart() + 1;
            foundModifications.add(new ModificationMatch(currentModification.getName(), true, location));
        }
        Peptide peptide = new Peptide(sequence, foundModifications);
        if (sequenceMatchingPreferences != null) {
            String subSequence = sequence.substring(0, this.peptideMapKeyLength);
            LinkedList<Peptide> peptidesForTag = this.foundPeptidesMap.get(subSequence = AminoAcid.getMatchingSequence(subSequence, sequenceMatchingPreferences));
            if (peptidesForTag == null) {
                peptidesForTag = new LinkedList();
                this.foundPeptidesMap.put(subSequence, peptidesForTag);
            }
            peptidesForTag.add(peptide);
        }
        return new PeptideAssumption(peptide, rank, Advocate.xtandem.getIndex(), new Charge(1, charge), domain.getDomainExpect(), this.getFileName());
    }

    private String fixMgfTitle(String spectrumTitle) {
        try {
            spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("An exception was thrown when trying to decode an mgf tile!");
            e.printStackTrace();
        }
        return spectrumTitle;
    }

    @Override
    public void close() throws IOException {
        this.xTandemFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.xTandemFile.getPerformParameters().getProcVersion());
        result.put("X!Tandem", versions);
        return result;
    }

    @Override
    public HashMap<String, LinkedList<Peptide>> getPeptidesMap() {
        return this.foundPeptidesMap;
    }

    @Override
    public HashMap<String, LinkedList<SpectrumMatch>> getTagsMap() {
        return new HashMap<String, LinkedList<SpectrumMatch>>();
    }

    @Override
    public void clearTagsMap() {
    }

    @Override
    public void clearPeptidesMap() {
        if (this.foundPeptidesMap != null) {
            this.foundPeptidesMap.clear();
        }
    }
}

