/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.parser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XTandemParser
implements Serializable {
    private static Pattern resModificationMassPattern = Pattern.compile("label=\"residue, modification mass (\\d+)\"");
    private static Pattern refPotModificationMassPattern = Pattern.compile("label=\"refine, potential modification mass (\\d+)\"");
    private static Pattern refPotModificationMotifPattern = Pattern.compile("label=\"refine, potential modification motif (\\d+)\"");
    private int iNumberOfSpectra = 0;
    private HashMap<String, String> iInputParamMap = null;
    private HashMap<String, String> iPerformParamMap = null;
    private HashMap<String, String> iRawModMap = null;
    private HashMap<String, String> iRawSpectrumMap = null;
    private HashMap<String, String> iRawProteinMap = null;
    private HashMap<String, String> iRawPeptideMap = null;
    private HashMap<String, String> iSupportDataMap = null;
    private ArrayList<String> iProteinKeyList = null;
    private HashMap<String, Integer> iTitle2SpectrumIDMap;
    private HashMap<Integer, String> idToSpectrumMap;

    public XTandemParser(File aFile) throws IOException, SAXException, ParserConfigurationException {
        this(aFile, false);
    }

    public XTandemParser(File aFile, boolean skipDetails) throws IOException, SAXException, ParserConfigurationException {
        this.parseXTandemFile(aFile, skipDetails);
    }

    private void parseXTandemFile(File aInputFile, boolean skipDetails) throws IOException, SAXException, ParserConfigurationException {
        int i;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setAttribute("http://xml.org/sax/features/validation", false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(aInputFile);
        Element docEle = dom.getDocumentElement();
        NodeList nodes = docEle.getChildNodes();
        this.iInputParamMap = new HashMap();
        this.iPerformParamMap = new HashMap();
        this.iRawModMap = new HashMap();
        this.iRawSpectrumMap = new HashMap();
        this.iRawPeptideMap = new HashMap();
        this.iRawProteinMap = new HashMap();
        this.iSupportDataMap = new HashMap();
        this.iTitle2SpectrumIDMap = new HashMap();
        this.idToSpectrumMap = new HashMap();
        this.iProteinKeyList = new ArrayList();
        boolean aIonFlag = false;
        boolean bIonFlag = false;
        boolean cIonFlag = false;
        boolean xIonFlag = false;
        boolean yIonFlag = false;
        boolean zIonFlag = false;
        int spectraCounter = 0;
        for (i = 0; i < nodes.getLength(); ++i) {
            int m;
            NodeList parameterNodes;
            if (nodes.item(i).getAttributes() == null || nodes.item(i).getAttributes().getNamedItem("type") == null) continue;
            if (nodes.item(i).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("parameters") && (nodes.item(i).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("input parameters") || nodes.item(i).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("unused input parameters"))) {
                parameterNodes = nodes.item(i).getChildNodes();
                for (m = 0; m < parameterNodes.getLength(); ++m) {
                    Matcher matcher;
                    if (parameterNodes.item(m).getAttributes() == null) continue;
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, path\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECTRUMPATH", parameterNodes.item(m).getTextContent());
                        break;
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, default parameters\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("DEFAULTPARAMPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, taxonomy information\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("TAXONOMYINFOPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, histogram column width\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("HISTOCOLWIDTH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, histograms\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("HISTOEXIST", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, logpath\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("LOGPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, maximum valid expectation value\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("MAXVALIDEXPECT", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, message\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTMESSAGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, one sequence copy\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("ONESEQCOPY", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, parameters\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTPARAMS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, path\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, path hashing\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTPATHHASH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, performance\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTPERFORMANCE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, proteins\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTPROTEINS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, results\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTRESULTS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, sequence path\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTSEQPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, sequences\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTSEQUENCES", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, sort results by\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTSORTRESULTS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, spectra\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTSPECTRA", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"output, xsl path\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("OUTPUTSXSLPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, C-terminal residue modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("C_TERMRESMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, N-terminal residue modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("N_TERMRESMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, cleavage C-terminal mass change\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("C_TERMCLEAVMASSCHANGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, cleavage N-terminal mass change\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("N_TERMCLEAVMASSCHANGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, cleavage site\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("CLEAVAGESITE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, homolog management\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("HOMOLOGMANAGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, modified residue mass file\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("MODRESMASSFILE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"protein, taxon\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("TAXON", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, maximum valid expectation value\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINEMAXVALIDEXPECT", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINEMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, point mutations\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POINTMUTATIONS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, potential C-terminus modifications\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTC_TERMMODS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, potential N-terminus modifications\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTN_TERMMODS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, potential modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase().startsWith("label=\"refine, potential modification mass ") && (matcher = refPotModificationMassPattern.matcher(parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase())).find() && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTMODMASS_" + matcher.group(1), parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, potential modification motif\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTMODMOTIF", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase().startsWith("label=\"refine, potential modification motif ") && (matcher = refPotModificationMotifPattern.matcher(parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase())).find() && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTMODMOTIF_" + matcher.group(1), parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, sequence path\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINESEQPATH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, spectrum synthesis\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINESPECSYTNH", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, tic percent\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINETIC", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, unanticipated cleavage\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("REFINEUNANTICLEAV", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refine, use potential modifications for full refinement\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("POTMODSFULLREFINE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"residue, modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("RESIDUEMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase().startsWith("label=\"residue, modification mass ") && (matcher = resModificationMassPattern.matcher(parameterNodes.item(m).getAttributes().getNamedItem("label").toString().toLowerCase())).find() && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("RESIDUEMODMASS_" + matcher.group(1), parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"residue, potential modification mass\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("RESIDUEPOTMODMASS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"residue, potential modification motif\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("RESIDUEPOTMODMOTIV", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, a ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_AIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            aIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, b ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_BIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            bIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, c ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_CIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            cIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, cyclic permutation\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORINGCYCLPERM", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, include reverse\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORINGINCREV", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, maximum missed cleavage sites\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORINGMISSCLEAV", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, minimum ion count\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORINGMINIONCOUNT", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, pluggable scoring\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORINGPLUGSCORING", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, x ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_XIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            xIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, y ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_YIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            yIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, z ions\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_ZIONS", parameterNodes.item(m).getTextContent());
                        if (parameterNodes.item(m).getTextContent().equals("yes")) {
                            zIonFlag = true;
                        }
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"scoring, algorithm\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SCORING_ALGORITHM", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, dynamic range\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECDYNRANGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, fragment mass type\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECFRAGMASSTYPE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, fragment monoisotopic mass error\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMONOISOMASSERROR", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, fragment monoisotopic mass error units\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMONOISOMASSERRORUNITS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, maximum parent charge\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMAXPRECURSORCHANGE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, minimum fragment mz\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMINFRAGMZ", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, minimum parent m+h\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMINPRECURSORMZ", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, minimum peaks\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECMINPEAKS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, parent monoisotopic mass error minus\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECPARENTMASSERRORMINUS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, parent monoisotopic mass error plus\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECPARENTMASSERRORPLUS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, parent monoisotopic mass error units\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECPARENTMASSERRORUNITS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, parent monoisotopic mass isotope error\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECPARENTMASSISOERROR", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, sequence batch size\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECBATCHSIZE", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, threads\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECTHREADS", parameterNodes.item(m).getTextContent());
                    }
                    if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, total peaks\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                        this.iInputParamMap.put("SPECTOTALPEAK", parameterNodes.item(m).getTextContent());
                    }
                    if (!parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"spectrum, use noise suppression\"") || parameterNodes.item(m).getTextContent().equals("")) continue;
                    this.iInputParamMap.put("SPECUSENOISECOMP", parameterNodes.item(m).getTextContent());
                }
            }
            if (!nodes.item(i).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("parameters") || !nodes.item(i).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("performance parameters")) continue;
            parameterNodes = nodes.item(i).getChildNodes();
            for (m = 0; m < parameterNodes.getLength(); ++m) {
                if (parameterNodes.item(m).getAttributes() == null) continue;
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source #1\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRC1", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source #2\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRC2", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source #3\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRC3", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source description #1\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRCDESC1", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source description #2\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRCDESC2", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"list path, sequence source description #3\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("SEQSRCDESC3", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, estimated false positives\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("ESTFP", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, spectrum noise suppression ratio\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("NOISESUPP", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, total peptides used\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("TOTALPEPUSED", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, total proteins used\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("TOTALPROTUSED", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, total spectra assigned\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("TOTALSPECASS", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, total spectra used\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("TOTALSPECUSED", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"modelling, total unique assigned\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("TOTALUNIQUEASS", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"process, start time\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("PROCSTART", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"process, version\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("PROCVER", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"quality values\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("QUALVAL", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # input models\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("INPUTMOD", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # input spectra\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("INPUTSPEC", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # partial cleavage\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("PARTCLEAV", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # point mutations\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("POINTMUT", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # potential C-terminii\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("POTC_TERM", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # potential N-terminii\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("POTN_TERM", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"refining, # unanticipated cleavage\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("UNANTICLEAV", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"timing, initial modelling total (sec)\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("INITMODELTOTALTIME", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"timing, initial modelling/spectrum (sec)\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("INITMODELSPECTIME", parameterNodes.item(m).getTextContent());
                }
                if (parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"timing, load sequence models (sec)\"") && !parameterNodes.item(m).getTextContent().equals("")) {
                    this.iPerformParamMap.put("LOADSEQMODELTIME", parameterNodes.item(m).getTextContent());
                }
                if (!parameterNodes.item(m).getAttributes().getNamedItem("label").toString().equalsIgnoreCase("label=\"timing, refinement/spectrum (sec)\"") || parameterNodes.item(m).getTextContent().equals("")) continue;
                this.iPerformParamMap.put("REFINETIME", parameterNodes.item(m).getTextContent());
            }
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getAttributes() != null && nodes.item(i).getAttributes().getNamedItem("type") != null && nodes.item(i).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("model")) {
                ++spectraCounter;
                if (nodes.item(i).getAttributes().getNamedItem("id") != null) {
                    this.iRawSpectrumMap.put("id" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("id").getNodeValue());
                }
                if (nodes.item(i).getAttributes().getNamedItem("z") != null) {
                    this.iRawSpectrumMap.put("z" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("z").getNodeValue());
                }
                if (!skipDetails) {
                    if (nodes.item(i).getAttributes().getNamedItem("expect") != null) {
                        this.iRawSpectrumMap.put("expect" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("expect").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("mh") != null) {
                        this.iRawSpectrumMap.put("mh" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("mh").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("rt") != null) {
                        this.iRawSpectrumMap.put("rt" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("rt").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("label") != null) {
                        this.iRawSpectrumMap.put("label" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("label").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("sumI") != null) {
                        this.iRawSpectrumMap.put("sumI" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("sumI").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("maxI") != null) {
                        this.iRawSpectrumMap.put("maxI" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("maxI").getNodeValue());
                    }
                    if (nodes.item(i).getAttributes().getNamedItem("fI") != null) {
                        this.iRawSpectrumMap.put("fI" + spectraCounter, nodes.item(i).getAttributes().getNamedItem("fI").getNodeValue());
                    }
                }
            }
            this.iNumberOfSpectra = spectraCounter;
            NodeList idNodes = nodes.item(i).getChildNodes();
            int p_counter = 0;
            block4: for (int j = 0; j < idNodes.getLength(); ++j) {
                int e;
                NodeList yDataNodes;
                int d;
                NodeList xDataNodes;
                NodeList supportDataNodes;
                if (idNodes.item(j).getNodeName().equalsIgnoreCase("protein")) {
                    ++p_counter;
                    String protID = idNodes.item(j).getAttributes().getNamedItem("id").getNodeValue();
                    String proteinKey = idNodes.item(j).getAttributes().getNamedItem("label").getNodeValue();
                    if (!skipDetails) {
                        this.iProteinKeyList.add(proteinKey);
                        this.iRawProteinMap.put("uid" + proteinKey, idNodes.item(j).getAttributes().getNamedItem("uid").getNodeValue());
                        this.iRawProteinMap.put("expect" + proteinKey, idNodes.item(j).getAttributes().getNamedItem("expect").getNodeValue());
                        this.iRawProteinMap.put("label" + proteinKey, idNodes.item(j).getAttributes().getNamedItem("label").getNodeValue());
                        this.iRawProteinMap.put("sumI" + proteinKey, idNodes.item(j).getAttributes().getNamedItem("sumI").getNodeValue());
                    }
                    NodeList proteinNodes = idNodes.item(j).getChildNodes();
                    for (int k = 0; k < proteinNodes.getLength(); ++k) {
                        if (!skipDetails) {
                            if (proteinNodes.item(k).getNodeName().equalsIgnoreCase("file")) {
                                this.iRawPeptideMap.put("URL_s" + spectraCounter + "_p" + p_counter, proteinNodes.item(k).getAttributes().getNamedItem("URL").getNodeValue());
                            }
                            if (proteinNodes.item(k).getNodeName().equalsIgnoreCase("note") && proteinNodes.item(k).getAttributes().getNamedItem("label") != null && proteinNodes.item(k).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("description")) {
                                String test = proteinNodes.item(k).getTextContent();
                                this.iRawProteinMap.put("description" + proteinKey, test);
                            }
                        }
                        if (!proteinNodes.item(k).getNodeName().equalsIgnoreCase("peptide")) continue;
                        this.iRawPeptideMap.put("s" + spectraCounter + "_p" + p_counter, protID);
                        if (!skipDetails) {
                            this.iRawPeptideMap.put("start_s" + spectraCounter + "_p" + p_counter, proteinNodes.item(k).getAttributes().getNamedItem("start").getNodeValue());
                            this.iRawPeptideMap.put("end_s" + spectraCounter + "_p" + p_counter, proteinNodes.item(k).getAttributes().getNamedItem("end").getNodeValue());
                            this.iRawPeptideMap.put("seq_s" + spectraCounter + "_p" + p_counter, proteinNodes.item(k).getTextContent());
                        }
                        NodeList peptideNodes = proteinNodes.item(k).getChildNodes();
                        int dCount = 1;
                        for (int m = 0; m < peptideNodes.getLength(); ++m) {
                            if (!peptideNodes.item(m).getNodeName().equalsIgnoreCase("domain")) continue;
                            String domainKey = "s" + spectraCounter + "_p" + p_counter + "_d" + dCount;
                            while (this.iRawPeptideMap.containsKey("proteinkey_" + domainKey)) {
                                domainKey = "s" + spectraCounter + "_p" + p_counter + "_d" + ++dCount;
                            }
                            this.iRawPeptideMap.put("domainid_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("id").getNodeValue());
                            this.iRawPeptideMap.put("domainstart_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("start").getNodeValue());
                            if (!skipDetails) {
                                this.iRawPeptideMap.put("proteinkey_" + domainKey, proteinKey);
                                this.iRawPeptideMap.put("domainend_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("end").getNodeValue());
                                this.iRawPeptideMap.put("mh_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("mh").getNodeValue());
                                this.iRawPeptideMap.put("delta_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("delta").getNodeValue());
                                this.iRawPeptideMap.put("hyperscore_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("hyperscore").getNodeValue());
                                this.iRawPeptideMap.put("nextscore_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("nextscore").getNodeValue());
                                if (xIonFlag) {
                                    this.iRawPeptideMap.put("x_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_score").getNodeValue());
                                    this.iRawPeptideMap.put("x_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_ions").getNodeValue());
                                }
                                if (yIonFlag) {
                                    this.iRawPeptideMap.put("y_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_score").getNodeValue());
                                    this.iRawPeptideMap.put("y_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_ions").getNodeValue());
                                }
                                if (zIonFlag) {
                                    this.iRawPeptideMap.put("z_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_score").getNodeValue());
                                    this.iRawPeptideMap.put("z_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("y_ions").getNodeValue());
                                }
                                if (aIonFlag) {
                                    this.iRawPeptideMap.put("a_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_score").getNodeValue());
                                    this.iRawPeptideMap.put("a_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_ions").getNodeValue());
                                }
                                if (bIonFlag) {
                                    this.iRawPeptideMap.put("b_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_score").getNodeValue());
                                    this.iRawPeptideMap.put("b_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_ions").getNodeValue());
                                }
                                if (cIonFlag) {
                                    this.iRawPeptideMap.put("c_score_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_score").getNodeValue());
                                    this.iRawPeptideMap.put("c_ions_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("b_ions").getNodeValue());
                                }
                                this.iRawPeptideMap.put("pre_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("pre").getNodeValue());
                                this.iRawPeptideMap.put("post_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("post").getNodeValue());
                                this.iRawPeptideMap.put("missed_cleavages_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("missed_cleavages").getNodeValue());
                            }
                            this.iRawPeptideMap.put("expect_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("expect").getNodeValue());
                            this.iRawPeptideMap.put("domainseq_" + domainKey, peptideNodes.item(m).getAttributes().getNamedItem("seq").getNodeValue());
                            int modCounter = 0;
                            for (int n = 0; n < peptideNodes.item(m).getChildNodes().getLength(); ++n) {
                                if (!peptideNodes.item(m).getChildNodes().item(n).getNodeName().equalsIgnoreCase("aa")) continue;
                                NamedNodeMap modificationMap = peptideNodes.item(m).getChildNodes().item(n).getAttributes();
                                String modificationName = modificationMap.getNamedItem("type").getNodeValue();
                                this.iRawModMap.put("at_" + domainKey + "_m" + ++modCounter, modificationMap.getNamedItem("at").getNodeValue());
                                double modificationMass = Double.parseDouble(modificationMap.getNamedItem("modified").getNodeValue());
                                this.iRawModMap.put("modified_" + domainKey + "_m" + modCounter, modificationMap.getNamedItem("modified").getNodeValue());
                                modificationName = modificationMass + "@" + modificationName;
                                this.iRawModMap.put("name_" + domainKey + "_m" + modCounter, modificationName);
                                if (modificationMap.getNamedItem("pm") == null) continue;
                                this.iRawModMap.put("pm_" + domainKey + "_m" + modCounter, modificationMap.getNamedItem("pm").getNodeValue());
                            }
                        }
                    }
                }
                if (!idNodes.item(j).getNodeName().equalsIgnoreCase("group")) continue;
                if (!skipDetails && idNodes.item(j).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("supporting data")) {
                    supportDataNodes = idNodes.item(j).getChildNodes();
                    for (int a = 0; a < supportDataNodes.getLength(); ++a) {
                        if (!supportDataNodes.item(a).getNodeName().equalsIgnoreCase("GAML:trace")) continue;
                        if (supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("hyperscore expectation function")) {
                            this.iSupportDataMap.put("HYPERLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            NodeList hyperNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < hyperNodes.getLength(); ++b) {
                                if (hyperNodes.item(b).getNodeName().equalsIgnoreCase("GAML:attribute")) {
                                    if (hyperNodes.item(b).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("a0")) {
                                        this.iSupportDataMap.put("HYPER_A0_s" + spectraCounter, hyperNodes.item(b).getTextContent());
                                    }
                                    if (hyperNodes.item(b).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("a1")) {
                                        this.iSupportDataMap.put("HYPER_A1_s" + spectraCounter, hyperNodes.item(b).getTextContent());
                                    }
                                }
                                if (hyperNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = hyperNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_HYPER_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!hyperNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = hyperNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_HYPER_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("convolution survival function")) {
                            this.iSupportDataMap.put("CONVOLLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList convolNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < convolNodes.getLength(); ++b) {
                                if (convolNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = convolNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_CONVOL_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!convolNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = convolNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_CONVOL_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (aIonFlag && supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("b ion histogram")) {
                            this.iSupportDataMap.put("A_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList aIonNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < aIonNodes.getLength(); ++b) {
                                if (aIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = aIonNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_AIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!aIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = aIonNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_AIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (bIonFlag && supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("b ion histogram")) {
                            this.iSupportDataMap.put("B_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList bIonNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < bIonNodes.getLength(); ++b) {
                                if (bIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = bIonNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_BIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!bIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = bIonNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_BIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (cIonFlag && supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("b ion histogram")) {
                            this.iSupportDataMap.put("C_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList cIonNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < cIonNodes.getLength(); ++b) {
                                if (cIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = cIonNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_CIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!cIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = cIonNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_CIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (xIonFlag && supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equals("y ion histogram")) {
                            this.iSupportDataMap.put("X_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList xIonNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < xIonNodes.getLength(); ++b) {
                                if (xIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = xIonNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_XIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!xIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = xIonNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_XIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (yIonFlag && supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equals("y ion histogram")) {
                            this.iSupportDataMap.put("Y_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                            supportDataNodes.item(a).getChildNodes();
                            NodeList yIonNodes = supportDataNodes.item(a).getChildNodes();
                            for (int b = 0; b < yIonNodes.getLength(); ++b) {
                                if (yIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                    xDataNodes = yIonNodes.item(b).getChildNodes();
                                    for (d = 0; d < xDataNodes.getLength(); ++d) {
                                        if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                        this.iSupportDataMap.put("XVAL_YIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                    }
                                }
                                if (!yIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                                yDataNodes = yIonNodes.item(b).getChildNodes();
                                for (e = 0; e < yDataNodes.getLength(); ++e) {
                                    if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("YVAL_YIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                                }
                            }
                        }
                        if (!zIonFlag || !supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equals("y ion histogram")) continue;
                        this.iSupportDataMap.put("Z_IONLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                        supportDataNodes.item(a).getChildNodes();
                        NodeList zIonNodes = supportDataNodes.item(a).getChildNodes();
                        for (int b = 0; b < zIonNodes.getLength(); ++b) {
                            if (zIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                                xDataNodes = zIonNodes.item(b).getChildNodes();
                                for (d = 0; d < xDataNodes.getLength(); ++d) {
                                    if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                    this.iSupportDataMap.put("XVAL_ZIONS_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                                }
                            }
                            if (!zIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                            yDataNodes = zIonNodes.item(b).getChildNodes();
                            for (e = 0; e < yDataNodes.getLength(); ++e) {
                                if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                this.iSupportDataMap.put("YVAL_ZIONS_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                            }
                        }
                    }
                }
                if (!idNodes.item(j).getAttributes().getNamedItem("label").getNodeValue().equalsIgnoreCase("fragment ion mass spectrum")) continue;
                supportDataNodes = idNodes.item(j).getChildNodes();
                for (int a = 0; a < supportDataNodes.getLength(); ++a) {
                    if (supportDataNodes.item(a).getNodeName().equalsIgnoreCase("note")) {
                        String title = supportDataNodes.item(a).getTextContent().trim();
                        this.idToSpectrumMap.put(spectraCounter, title);
                        if (skipDetails) continue block4;
                        this.iSupportDataMap.put("FRAGIONSPECDESC_s" + spectraCounter, title);
                        this.iTitle2SpectrumIDMap.put(title, spectraCounter);
                    }
                    if (skipDetails || !supportDataNodes.item(a).getNodeName().equalsIgnoreCase("GAML:trace") || !supportDataNodes.item(a).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("tandem mass spectrum")) continue;
                    this.iSupportDataMap.put("SPECTRUMLABEL_s" + spectraCounter, supportDataNodes.item(a).getAttributes().getNamedItem("label").getNodeValue());
                    supportDataNodes.item(a).getChildNodes();
                    NodeList fragIonNodes = supportDataNodes.item(a).getChildNodes();
                    for (int b = 0; b < fragIonNodes.getLength(); ++b) {
                        if (fragIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:attribute")) {
                            if (fragIonNodes.item(b).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("M+H")) {
                                this.iSupportDataMap.put("FRAGIONMZ_s" + spectraCounter, fragIonNodes.item(b).getTextContent());
                            }
                            if (fragIonNodes.item(b).getAttributes().getNamedItem("type").getNodeValue().equalsIgnoreCase("charge")) {
                                this.iSupportDataMap.put("FRAGIONCHARGE_s" + spectraCounter, fragIonNodes.item(b).getTextContent());
                            }
                        }
                        if (fragIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Xdata")) {
                            xDataNodes = fragIonNodes.item(b).getChildNodes();
                            for (d = 0; d < xDataNodes.getLength(); ++d) {
                                if (!xDataNodes.item(d).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                                this.iSupportDataMap.put("XVAL_FRAGIONMZ_s" + spectraCounter, xDataNodes.item(d).getTextContent());
                            }
                        }
                        if (!fragIonNodes.item(b).getNodeName().equalsIgnoreCase("GAML:Ydata")) continue;
                        yDataNodes = fragIonNodes.item(b).getChildNodes();
                        for (e = 0; e < yDataNodes.getLength(); ++e) {
                            if (!yDataNodes.item(e).getNodeName().equalsIgnoreCase("GAML:values")) continue;
                            this.iSupportDataMap.put("YVAL_FRAGIONMZ_s" + spectraCounter, yDataNodes.item(e).getTextContent());
                        }
                    }
                }
            }
        }
    }

    public int getNumberOfSpectra() {
        return this.iNumberOfSpectra;
    }

    public HashMap<String, String> getRawSpectrumMap() {
        return this.iRawSpectrumMap;
    }

    public HashMap<String, String> getRawPeptideMap() {
        return this.iRawPeptideMap;
    }

    public HashMap<String, String> getRawProteinMap() {
        return this.iRawProteinMap;
    }

    public ArrayList<String> getProteinIDList() {
        return this.iProteinKeyList;
    }

    public HashMap<String, String> getRawModMap() {
        return this.iRawModMap;
    }

    public HashMap<String, String> getPerformParamMap() {
        return this.iPerformParamMap;
    }

    public HashMap<String, String> getInputParamMap() {
        return this.iInputParamMap;
    }

    public HashMap<String, String> getSupportDataMap() {
        return this.iSupportDataMap;
    }

    public HashMap<String, Integer> getTitle2SpectrumIDMap() {
        return this.iTitle2SpectrumIDMap;
    }

    public HashMap<Integer, String> getIdToSpectrumMap() {
        return this.idToSpectrumMap;
    }
}

