/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.CDSComparator;
import org.biojava3.core.sequence.CDSSequence;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.GeneSequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.RNASequence;
import org.biojava3.core.sequence.StartCodonSequence;
import org.biojava3.core.sequence.StopCodonSequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.transcription.TranscriptionEngine;

public class TranscriptSequence
extends DNASequence {
    private static final Logger log = Logger.getLogger(TranscriptSequence.class.getName());
    private final ArrayList<CDSSequence> cdsSequenceList = new ArrayList();
    private final LinkedHashMap<String, CDSSequence> cdsSequenceHashMap = new LinkedHashMap();
    private StartCodonSequence startCodonSequence = null;
    private StopCodonSequence stopCodonSequence = null;
    private GeneSequence parentGeneSequence = null;

    public TranscriptSequence(GeneSequence parentDNASequence, int begin, int end) {
        this.setParentSequence(parentDNASequence);
        this.parentGeneSequence = parentDNASequence;
        this.setBioBegin(begin);
        this.setBioEnd(end);
    }

    @Override
    public int getLength() {
        return Math.abs(this.getBioEnd() - this.getBioBegin()) + 1;
    }

    public Strand getStrand() {
        return this.parentGeneSequence.getStrand();
    }

    public CDSSequence removeCDS(String accession) {
        for (CDSSequence cdsSequence : this.cdsSequenceList) {
            if (!cdsSequence.getAccession().getID().equals(accession)) continue;
            this.cdsSequenceList.remove(cdsSequence);
            this.cdsSequenceHashMap.remove(accession);
            return cdsSequence;
        }
        return null;
    }

    public LinkedHashMap<String, CDSSequence> getCDSSequences() {
        return this.cdsSequenceHashMap;
    }

    public CDSSequence addCDS(AccessionID accession, int begin, int end, int phase) throws Exception {
        if (this.cdsSequenceHashMap.containsKey(accession.getID())) {
            throw new Exception("Duplicate accesion id " + accession.getID());
        }
        CDSSequence cdsSequence = new CDSSequence(this, begin, end, phase);
        cdsSequence.setAccession(accession);
        this.cdsSequenceList.add(cdsSequence);
        Collections.sort(this.cdsSequenceList, new CDSComparator());
        this.cdsSequenceHashMap.put(accession.getID(), cdsSequence);
        return cdsSequence;
    }

    public ArrayList<ProteinSequence> getProteinCDSSequences() {
        ArrayList<ProteinSequence> proteinSequenceList = new ArrayList<ProteinSequence>();
        for (int i = 0; i < this.cdsSequenceList.size(); ++i) {
            String nextCodingSequence;
            CDSSequence nextCDSSequence;
            CDSSequence cdsSequence = this.cdsSequenceList.get(i);
            String codingSequence = cdsSequence.getCodingSequence();
            if (this.getStrand() == Strand.NEGATIVE) {
                if (cdsSequence.phase == 1) {
                    codingSequence = codingSequence.substring(1, codingSequence.length());
                } else if (cdsSequence.phase == 2) {
                    codingSequence = codingSequence.substring(2, codingSequence.length());
                }
                if (i < this.cdsSequenceList.size() - 1) {
                    nextCDSSequence = this.cdsSequenceList.get(i + 1);
                    if (nextCDSSequence.phase == 1) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = codingSequence + nextCodingSequence.substring(0, 1);
                    } else if (nextCDSSequence.phase == 2) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = codingSequence + nextCodingSequence.substring(0, 2);
                    }
                }
            } else {
                if (cdsSequence.phase == 1) {
                    codingSequence = codingSequence.substring(1, codingSequence.length());
                } else if (cdsSequence.phase == 2) {
                    codingSequence = codingSequence.substring(2, codingSequence.length());
                }
                if (i < this.cdsSequenceList.size() - 1) {
                    nextCDSSequence = this.cdsSequenceList.get(i + 1);
                    if (nextCDSSequence.phase == 1) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = codingSequence + nextCodingSequence.substring(0, 1);
                    } else if (nextCDSSequence.phase == 2) {
                        nextCodingSequence = nextCDSSequence.getCodingSequence();
                        codingSequence = codingSequence + nextCodingSequence.substring(0, 2);
                    }
                }
            }
            DNASequence dnaCodingSequence = new DNASequence(codingSequence.toString().toUpperCase());
            RNASequence rnaCodingSequence = dnaCodingSequence.getRNASequence(TranscriptionEngine.getDefault());
            ProteinSequence proteinSequence = rnaCodingSequence.getProteinSequence(TranscriptionEngine.getDefault());
            proteinSequence.setAccession(new AccessionID(cdsSequence.getAccession().getID()));
            proteinSequence.setParentDNASequence(cdsSequence, 1, cdsSequence.getLength());
            proteinSequenceList.add(proteinSequence);
        }
        return proteinSequenceList;
    }

    public DNASequence getDNACodingSequence() {
        StringBuilder sb = new StringBuilder();
        for (CDSSequence cdsSequence : this.cdsSequenceList) {
            sb.append(cdsSequence.getCodingSequence());
        }
        DNASequence dnaSequence = new DNASequence(sb.toString().toUpperCase());
        dnaSequence.setAccession(new AccessionID(this.getAccession().getID()));
        return dnaSequence;
    }

    public ProteinSequence getProteinSequence() {
        return this.getProteinSequence(TranscriptionEngine.getDefault());
    }

    public ProteinSequence getProteinSequence(TranscriptionEngine engine) {
        DNASequence dnaCodingSequence = this.getDNACodingSequence();
        RNASequence rnaCodingSequence = dnaCodingSequence.getRNASequence(engine);
        ProteinSequence proteinSequence = rnaCodingSequence.getProteinSequence(engine);
        proteinSequence.setAccession(new AccessionID(this.getAccession().getID()));
        return proteinSequence;
    }

    public StartCodonSequence getStartCodonSequence() {
        return this.startCodonSequence;
    }

    public void addStartCodonSequence(AccessionID accession, int begin, int end) {
        this.startCodonSequence = new StartCodonSequence(this, begin, end);
        this.startCodonSequence.setAccession(accession);
    }

    public StopCodonSequence getStopCodonSequence() {
        return this.stopCodonSequence;
    }

    public void addStopCodonSequence(AccessionID accession, int begin, int end) {
        this.stopCodonSequence = new StopCodonSequence(this, begin, end);
        this.stopCodonSequence.setAccession(accession);
    }
}

