/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.software.autoupdater.DownloadLatestZipFromRepo;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.xml.stream.XMLStreamException;

public class SearchGuiSetupDialog
extends JDialog {
    private UtilitiesUserPreferences utilitiesUserPreferences;
    private String lastSelectedFolder = "";
    private boolean dialogCanceled = true;
    private ProgressDialogX progressDialog;
    private JFrame parentFrame = null;
    private JDialog parentDialog = null;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton searchGuiButton;
    private JLabel searchGuiDownloadLinkLabel;
    private JPanel searchGuiDownloadPanel;
    private JLabel searchGuiInfoLabel;
    private JTextField searchGuiInstallationJTextField;
    private JPanel searchGuiInstallationPanel;
    private JLabel searchGuiJarFileHelpLabel;

    public SearchGuiSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.parentFrame = parent;
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    public SearchGuiSetupDialog(JDialog parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.parentDialog = parent;
        this.setLocationRelativeTo(parent);
        this.setUpGUI();
    }

    private void setUpGUI() {
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences.getSearchGuiPath() == null) {
            boolean downloaded = this.downloadSearchGUI();
            if (downloaded) {
                this.dialogCanceled = false;
            } else {
                if (this.utilitiesUserPreferences != null) {
                    this.searchGuiInstallationJTextField.setText(this.utilitiesUserPreferences.getSearchGuiPath());
                    this.lastSelectedFolder = this.utilitiesUserPreferences.getSearchGuiPath();
                }
                this.setVisible(true);
            }
        } else {
            if (this.utilitiesUserPreferences != null) {
                this.searchGuiInstallationJTextField.setText(this.utilitiesUserPreferences.getSearchGuiPath());
                this.lastSelectedFolder = this.utilitiesUserPreferences.getSearchGuiPath();
            }
            this.setVisible(true);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.searchGuiInstallationPanel = new JPanel();
        this.searchGuiInstallationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchGuiJarFileHelpLabel = new JLabel();
        this.searchGuiDownloadPanel = new JPanel();
        this.searchGuiInfoLabel = new JLabel();
        this.searchGuiDownloadLinkLabel = new JLabel();
        this.searchGuiButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(0);
        this.setTitle("SearchGUI Settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchGuiSetupDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.searchGuiInstallationPanel.setBorder(BorderFactory.createTitledBorder("SearchGUI Installation"));
        this.searchGuiInstallationPanel.setOpaque(false);
        this.searchGuiInstallationJTextField.setEditable(false);
        this.searchGuiInstallationJTextField.setToolTipText("The folder containing the SearchGUI jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the SearchGUI jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGuiSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.searchGuiJarFileHelpLabel.setFont(this.searchGuiJarFileHelpLabel.getFont().deriveFont(this.searchGuiJarFileHelpLabel.getFont().getStyle() | 2));
        this.searchGuiJarFileHelpLabel.setText("Please locate the folder containing the SearchGUI jar file.");
        GroupLayout searchGuiInstallationPanelLayout = new GroupLayout(this.searchGuiInstallationPanel);
        this.searchGuiInstallationPanel.setLayout(searchGuiInstallationPanelLayout);
        searchGuiInstallationPanelLayout.setHorizontalGroup(searchGuiInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, searchGuiInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchGuiInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchGuiInstallationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.searchGuiJarFileHelpLabel)).addComponent(this.searchGuiInstallationJTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        searchGuiInstallationPanelLayout.setVerticalGroup(searchGuiInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchGuiInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchGuiInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchGuiInstallationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchGuiJarFileHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.searchGuiDownloadPanel.setBorder(BorderFactory.createTitledBorder("Download SearchGUI"));
        this.searchGuiDownloadPanel.setOpaque(false);
        this.searchGuiInfoLabel.setFont(this.searchGuiInfoLabel.getFont().deriveFont(this.searchGuiInfoLabel.getFont().getStyle() | 1));
        this.searchGuiInfoLabel.setText("SearchGUI -  a graphical user interface for proteomics identification search engines");
        this.searchGuiDownloadLinkLabel.setText("<html>Download here: <a href> http://searchgui.googlecode.com</a></html>");
        this.searchGuiDownloadLinkLabel.setToolTipText("Go to http://searchgui.googlecode.com");
        this.searchGuiDownloadLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiDownloadLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiDownloadLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiDownloadLinkLabelMouseExited(evt);
            }
        });
        this.searchGuiButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/searchgui-medium-shadow.png")));
        this.searchGuiButton.setToolTipText("Go to http://searchgui.googlecode.com");
        this.searchGuiButton.setBorderPainted(false);
        this.searchGuiButton.setContentAreaFilled(false);
        this.searchGuiButton.setFocusPainted(false);
        this.searchGuiButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiButtonMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGuiSetupDialog.this.searchGuiButtonMouseExited(evt);
            }
        });
        GroupLayout searchGuiDownloadPanelLayout = new GroupLayout(this.searchGuiDownloadPanel);
        this.searchGuiDownloadPanel.setLayout(searchGuiDownloadPanelLayout);
        searchGuiDownloadPanelLayout.setHorizontalGroup(searchGuiDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchGuiDownloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchGuiDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchGuiDownloadPanelLayout.createSequentialGroup().addComponent(this.searchGuiInfoLabel).addGap(0, 32, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, searchGuiDownloadPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.searchGuiDownloadLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.searchGuiButton).addContainerGap()));
        searchGuiDownloadPanelLayout.setVerticalGroup(searchGuiDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchGuiDownloadPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.searchGuiInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchGuiDownloadLinkLabel, -2, -1, -2)).addComponent(this.searchGuiButton, -2, 66, -2));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGuiSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGuiSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchGuiDownloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.searchGuiInstallationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchGuiInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchGuiDownloadPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = Util.getUserSelectedFile(this, ".jar", "SearchGUI jar file (.jar)", "Select SearchGUI Jar File", this.lastSelectedFolder, true);
        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else if (selectedFile.getName().indexOf("SearchGUI") == -1) {
                JOptionPane.showMessageDialog(this, "The selected file is not a SearchGUI jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.searchGuiInstallationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserPreferences.setSearchGuiPath(this.searchGuiInstallationJTextField.getText());
        try {
            UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
            this.dialogCanceled = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void searchGuiDownloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchGuiDownloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchGuiDownloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openSearchGuiWebPage();
    }

    private void searchGuiButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchGuiButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchGuiButtonMouseClicked(MouseEvent evt) {
        this.openSearchGuiWebPage();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void openSearchGuiWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://searchgui.googlecode.com");
        this.setCursor(new Cursor(0));
    }

    public boolean isDialogCanceled() {
        return this.dialogCanceled;
    }

    public boolean downloadSearchGUI() {
        int option = JOptionPane.showConfirmDialog(this, "Cannot find SearchGUI. Do you want to download it now?", "Download SearchGUI?", 2);
        if (option == 0) {
            File downloadFolder;
            String installPath = "user.home";
            if (this.utilitiesUserPreferences.getPeptideShakerPath() != null && new File(this.utilitiesUserPreferences.getPeptideShakerPath()).getParentFile() != null && new File(this.utilitiesUserPreferences.getPeptideShakerPath()).getParentFile().getParentFile() != null) {
                installPath = new File(this.utilitiesUserPreferences.getPeptideShakerPath()).getParentFile().getParent();
            }
            if ((downloadFolder = Util.getUserSelectedFolder(this, "Select SearchGUI Folder", installPath, "SearchGUI Folder", "Select", false)) != null) {
                this.progressDialog = this.parentFrame != null ? new ProgressDialogX((Frame)this.parentFrame, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true) : (this.parentDialog != null ? new ProgressDialogX(this.parentDialog, (JFrame)this.parentDialog.getParent(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true) : new ProgressDialogX((Frame)new JFrame(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true));
                this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                this.progressDialog.setTitle("Downloading SearchGUI. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SearchGuiSetupDialog.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                Thread thread = new Thread("DownloadThread"){

                    @Override
                    public void run() {
                        try {
                            URL jarRepository = new URL("http", "genesis.ugent.be", "/maven2/");
                            DownloadLatestZipFromRepo.downloadLatestZipFromRepo(downloadFolder, "SearchGUI", "eu.isas.searchgui", "SearchGUI", "searchgui.ico", null, jarRepository, false, true, new GUIFileDAO(), SearchGuiSetupDialog.this.progressDialog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        catch (XMLStreamException e) {
                            e.printStackTrace();
                        }
                    }
                };
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.progressDialog.isRunCanceled()) {
                    this.progressDialog.setRunFinished();
                    return false;
                }
                if (!this.progressDialog.isRunFinished()) {
                    this.progressDialog.setRunFinished();
                }
                return true;
            }
        }
        return false;
    }
}

