/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.tagcomponents.MassGap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class IonFactory {
    private static IonFactory instance = null;
    private static ArrayList<NeutralLoss> defaultNeutralLosses = new ArrayList();

    private IonFactory() {
    }

    public static IonFactory getInstance() {
        if (instance == null) {
            instance = new IonFactory();
        }
        return instance;
    }

    public void addDefaultNeutralLoss(NeutralLoss newNeutralLoss) {
        boolean found = false;
        for (NeutralLoss neutralLoss : defaultNeutralLosses) {
            if (!newNeutralLoss.isSameAs(neutralLoss)) continue;
            found = true;
            break;
        }
        if (!found) {
            defaultNeutralLosses.add(newNeutralLoss);
        }
    }

    public ArrayList<NeutralLoss> getDefaultNeutralLosses() {
        return defaultNeutralLosses;
    }

    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Peptide peptide) {
        int subType;
        ArrayList<PrecursorIon> ions;
        HashMap ionsMap;
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        String sequence = peptide.getSequence().toUpperCase();
        HashMap<Integer, ArrayList<PTM>> modifications = new HashMap<Integer, ArrayList<PTM>>();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> processedPtms = null;
        ArrayList<NeutralLoss> possibleNeutralLosses = new ArrayList<NeutralLoss>(defaultNeutralLosses);
        for (ModificationMatch ptmMatch : peptide.getModificationMatches()) {
            int location = ptmMatch.getModificationSite();
            String ptmName = ptmMatch.getTheoreticPtm();
            PTM ptm = ptmFactory.getPTM(ptmName);
            if (ptm == null) {
                throw new IllegalArgumentException("PTM " + ptmName + " not loaded in the PTM factory.");
            }
            ArrayList<PTM> modificationsAtSite = (ArrayList<PTM>)modifications.get(location);
            if (modificationsAtSite == null) {
                modificationsAtSite = new ArrayList<PTM>();
                modifications.put(location, modificationsAtSite);
            }
            modificationsAtSite.add(ptm);
            if (processedPtms != null && processedPtms.contains(ptmName)) continue;
            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                int subType2;
                ArrayList<ReporterIon> ions2;
                HashMap ionsMap2 = (HashMap)result.get(Ion.IonType.REPORTER_ION.index);
                if (ionsMap2 == null) {
                    ionsMap2 = new HashMap();
                    result.put(Ion.IonType.REPORTER_ION.index, ionsMap2);
                }
                if ((ions2 = (ArrayList<ReporterIon>)ionsMap2.get(subType2 = ptmReporterIon.getSubType())) != null) continue;
                ions2 = new ArrayList<ReporterIon>();
                ionsMap2.put(subType2, ions2);
                ions2.add(ptmReporterIon);
            }
            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                boolean found = false;
                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                possibleNeutralLosses.add(ptmNeutralLoss);
            }
            if (processedPtms == null) {
                processedPtms = new ArrayList<String>();
            }
            processedPtms.add(ptmName);
        }
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = IonFactory.getAccountedNeutralLosses(possibleNeutralLosses);
        double forwardMass = 0.0;
        double rewindMass = Atom.O.getMonoisotopicMass();
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            ImmoniumIon immoniumIon;
            int subType3;
            ArrayList<ImmoniumIon> ions2;
            char aaName = sequence.charAt(aa);
            HashMap<Object, Object> ionsMap3 = (HashMap)result.get(Ion.IonType.IMMONIUM_ION.index);
            if (ionsMap3 == null) {
                ionsMap3 = new HashMap();
                result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap3);
            }
            if ((ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3 = (immoniumIon = new ImmoniumIon(aaName)).getSubType())) == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
                ions2.add(immoniumIon);
            }
            int faa = aa + 1;
            AminoAcid currentAA = AminoAcid.getAminoAcid(aaName);
            forwardMass += currentAA.monoisotopicMass;
            if (modifications.get(faa) != null) {
                for (PTM pTM : (ArrayList)modifications.get(faa)) {
                    forwardMass += pTM.getMass();
                }
            }
            if ((ionsMap3 = result.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index)) == null) {
                ionsMap3 = new HashMap();
                result.put(Ion.IonType.PEPTIDE_FRAGMENT_ION.index, ionsMap3);
            }
            if ((ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3 = 0)) == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, forwardMass - Atom.C.getMonoisotopicMass() - Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList)));
            }
            subType3 = 1;
            ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3);
            if (ions2 == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, forwardMass - IonFactory.getLossesMass(arrayList), arrayList)));
            }
            subType3 = 2;
            ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3);
            if (ions2 == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, forwardMass + Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList)));
            }
            int raa = sequence.length() - aa - 1;
            currentAA = AminoAcid.getAminoAcid(sequence.charAt(raa));
            rewindMass += currentAA.monoisotopicMass;
            if (modifications.get(raa + 1) != null) {
                for (PTM pTM : (ArrayList)modifications.get(raa + 1)) {
                    rewindMass += pTM.getMass();
                }
            }
            if ((ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3 = 3)) == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList<NeutralLoss> arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, rewindMass + Atom.C.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList)));
            }
            subType3 = 4;
            ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3);
            if (ions2 == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList<NeutralLoss> arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, rewindMass + 2.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList)));
            }
            subType3 = 5;
            ions2 = (ArrayList<ImmoniumIon>)ionsMap3.get(subType3);
            if (ions2 == null) {
                ions2 = new ArrayList<ImmoniumIon>();
                ionsMap3.put(subType3, ions2);
            }
            for (ArrayList<NeutralLoss> arrayList : neutralLossesCombinations) {
                ions2.add((ImmoniumIon)((Object)new PeptideFragmentIon(subType3, faa, rewindMass - Atom.N.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList)));
            }
        }
        AminoAcid currentAA = AminoAcid.getAminoAcid(sequence.charAt(sequence.length() - 1));
        forwardMass += currentAA.monoisotopicMass;
        if (modifications.get(sequence.length()) != null) {
            for (PTM ptm : (ArrayList)modifications.get(sequence.length())) {
                forwardMass += ptm.getMass();
            }
        }
        if ((ionsMap = (HashMap)result.get(Ion.IonType.PRECURSOR_ION.index)) == null) {
            ionsMap = new HashMap();
            result.put(Ion.IonType.PRECURSOR_ION.index, ionsMap);
        }
        if ((ions = (ArrayList<PrecursorIon>)ionsMap.get(subType = 0)) == null) {
            ions = new ArrayList<PrecursorIon>();
            ionsMap.put(subType, ions);
        }
        for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
            ions.add(new PrecursorIon(forwardMass + Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> getFragmentIons(Tag tag) {
        HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> result = new HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>();
        ArrayList<NeutralLoss> possibleNeutralLosses = new ArrayList<NeutralLoss>(defaultNeutralLosses);
        ArrayList<String> processedPtms = null;
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = IonFactory.getAccountedNeutralLosses(possibleNeutralLosses);
        int ionNumberOffset = 1;
        ArrayList<Double> massOffsets = new ArrayList<Double>();
        massOffsets.add(0.0);
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof AminoAcidPattern) {
                double mass;
                Object aminoAcidMasses;
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                ArrayList patternMasses = new ArrayList();
                for (int i = 0; i < aminoAcidPattern.length(); ++i) {
                    HashMap ionsMap;
                    aminoAcidMasses = new ArrayList();
                    for (Character c : aminoAcidPattern.getTargetedAA(i)) {
                        ImmoniumIon immoniumIon;
                        int subType3;
                        ArrayList<ImmoniumIon> ions;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(c.charValue());
                        mass = aminoAcid.monoisotopicMass;
                        for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i + 1)) {
                            String ptmName = modificationMatch.getTheoreticPtm();
                            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                            if (processedPtms == null || !processedPtms.contains(ptmName)) {
                                for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                    int subType2;
                                    ArrayList<Ion> ions2;
                                    HashMap<Integer, ArrayList<Ion>> ionsMap2 = result.get(Ion.IonType.REPORTER_ION.index);
                                    if (ionsMap2 == null) {
                                        ionsMap2 = new HashMap();
                                        result.put(Ion.IonType.REPORTER_ION.index, ionsMap2);
                                    }
                                    if ((ions2 = ionsMap2.get(subType2 = ptmReporterIon.getSubType())) != null) continue;
                                    ions2 = new ArrayList();
                                    ionsMap2.put(subType2, ions2);
                                    ions2.add(ptmReporterIon);
                                }
                                for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                    boolean found = false;
                                    for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                        if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    possibleNeutralLosses.add(ptmNeutralLoss);
                                }
                                if (processedPtms == null) {
                                    processedPtms = new ArrayList<String>();
                                }
                                processedPtms.add(ptmName);
                            }
                            mass += ptm.getMass();
                        }
                        if (!((ArrayList)aminoAcidMasses).contains(mass)) {
                            ((ArrayList)aminoAcidMasses).add(mass);
                        }
                        if ((ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                        }
                        if ((ions = (ArrayList<ImmoniumIon>)ionsMap.get(subType3 = (immoniumIon = new ImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) != null) continue;
                        ions = new ArrayList<ImmoniumIon>();
                        ionsMap.put(subType3, ions);
                        ions.add(immoniumIon);
                    }
                    HashMap<Integer, ArrayList<Ion>> ionsMap3 = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (ionsMap3 == null) {
                        ionsMap3 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap3);
                    }
                    Iterator iterator = massOffsets.iterator();
                    while (iterator.hasNext()) {
                        double d = (Double)iterator.next();
                        ArrayList<Double> newPatternMassess = new ArrayList<Double>();
                        if (patternMasses.isEmpty()) {
                            ionsMap = ((ArrayList)aminoAcidMasses).iterator();
                            while (ionsMap.hasNext()) {
                                double mass2 = (Double)ionsMap.next();
                                int aa3 = ionNumberOffset + i;
                                int subaa = i + 1;
                                double forwardMass = d + mass2;
                                int subType = 0;
                                ArrayList<Ion> ions = ionsMap3.get(subType);
                                if (ions == null) {
                                    ions = new ArrayList();
                                    ionsMap3.put(subType, ions);
                                }
                                for (ArrayList<NeutralLoss> arrayList : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(subType, aa3, subaa, forwardMass - Atom.C.getMonoisotopicMass() - Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList, d));
                                }
                                subType = 1;
                                ions = ionsMap3.get(subType);
                                if (ions == null) {
                                    ions = new ArrayList();
                                    ionsMap3.put(subType, ions);
                                }
                                for (ArrayList arrayList : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(subType, aa3, subaa, forwardMass - IonFactory.getLossesMass(arrayList), arrayList, d));
                                }
                                subType = 1;
                                ions = ionsMap3.get(subType);
                                if (ions == null) {
                                    ions = new ArrayList();
                                    ionsMap3.put(subType, ions);
                                }
                                for (ArrayList arrayList : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(subType, aa3, subaa, forwardMass + Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList, d));
                                }
                                if (newPatternMassess.contains(mass2)) continue;
                                newPatternMassess.add(mass2);
                            }
                        } else {
                            ionsMap = patternMasses.iterator();
                            while (ionsMap.hasNext()) {
                                double patternMass = (Double)ionsMap.next();
                                Iterator aa3 = ((ArrayList)aminoAcidMasses).iterator();
                                while (aa3.hasNext()) {
                                    double mass3 = (Double)aa3.next();
                                    int aa4 = ionNumberOffset + i;
                                    int subaa = i + 1;
                                    double patternFragmentMass = patternMass + mass3;
                                    double d2 = d + patternFragmentMass;
                                    int subType = 0;
                                    ArrayList<Ion> ions = ionsMap3.get(subType);
                                    if (ions == null) {
                                        ions = new ArrayList();
                                        ionsMap3.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa4, subaa, d2 - Atom.C.getMonoisotopicMass() - Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d));
                                    }
                                    subType = 1;
                                    ions = ionsMap3.get(subType);
                                    if (ions == null) {
                                        ions = new ArrayList();
                                        ionsMap3.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa4, subaa, d2 - IonFactory.getLossesMass(losses), losses, d));
                                    }
                                    subType = 2;
                                    ions = ionsMap3.get(subType);
                                    if (ions == null) {
                                        ions = new ArrayList();
                                        ionsMap3.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa4, subaa, d2 + Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d));
                                    }
                                    if (newPatternMassess.contains(patternFragmentMass)) continue;
                                    newPatternMassess.add(patternFragmentMass);
                                }
                            }
                        }
                        patternMasses = newPatternMassess;
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcidMasses = massOffsets.iterator();
                while (aminoAcidMasses.hasNext()) {
                    double offsetMass = (Double)aminoAcidMasses.next();
                    Iterator iterator = patternMasses.iterator();
                    while (iterator.hasNext()) {
                        mass = (Double)iterator.next();
                        double newMass = offsetMass + mass;
                        if (newOffsetMasses.contains(newMass)) continue;
                        newOffsetMasses.add(newMass);
                    }
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                Object aminoAcid;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                for (int i = 0; i < aminoAcidSequence.length(); ++i) {
                    ImmoniumIon immoniumIon;
                    int subType;
                    void var15_44;
                    ArrayList ions;
                    aminoAcid = aminoAcidSequence.getAminoAcidAt(i);
                    HashMap<Integer, ArrayList<Ion>> hashMap = result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (hashMap == null) {
                        HashMap hashMap2 = new HashMap();
                        result.put(Ion.IonType.IMMONIUM_ION.index, hashMap2);
                    }
                    if ((ions = (ArrayList)var15_44.get(subType = (immoniumIon = new ImmoniumIon(((AminoAcid)aminoAcid).getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions = new ArrayList();
                        var15_44.put(subType, ions);
                        ions.add(immoniumIon);
                    }
                    double mass = ((AminoAcid)aminoAcid).monoisotopicMass;
                    for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(i + 1)) {
                        String ptmName = modificationMatch.getTheoreticPtm();
                        PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                        if (processedPtms == null || !processedPtms.contains(ptmName)) {
                            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                void var15_48;
                                HashMap<Integer, ArrayList<Ion>> hashMap3 = result.get(Ion.IonType.REPORTER_ION.index);
                                if (hashMap3 == null) {
                                    HashMap hashMap4 = new HashMap();
                                    result.put(Ion.IonType.REPORTER_ION.index, hashMap4);
                                }
                                if ((ions = (ArrayList)var15_48.get(subType = ptmReporterIon.getSubType())) != null) continue;
                                ions = new ArrayList();
                                var15_48.put(subType, ions);
                                ions.add(ptmReporterIon);
                            }
                            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                boolean found = false;
                                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                possibleNeutralLosses.add(ptmNeutralLoss);
                            }
                            if (processedPtms == null) {
                                processedPtms = new ArrayList();
                            }
                            processedPtms.add(ptmName);
                        }
                        mass += ptm.getMass();
                    }
                    sequenceMass += mass;
                    HashMap<Integer, ArrayList<Ion>> hashMap5 = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (hashMap5 == null) {
                        HashMap hashMap6 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, hashMap6);
                    }
                    Iterator<ModificationMatch> subType3 = massOffsets.iterator();
                    while (subType3.hasNext()) {
                        void var15_51;
                        double massOffset = (Double)((Object)subType3.next());
                        int aa = ionNumberOffset + i;
                        int subaa = i + 1;
                        double forwardMass = massOffset + sequenceMass;
                        subType = 0;
                        ions = (ArrayList)var15_51.get(subType);
                        if (ions == null) {
                            ions = new ArrayList();
                            var15_51.put(subType, ions);
                        }
                        for (ArrayList arrayList : neutralLossesCombinations) {
                            ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass - Atom.C.getMonoisotopicMass() - Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList, massOffset));
                        }
                        subType = 1;
                        ions = (ArrayList)var15_51.get(subType);
                        if (ions == null) {
                            ions = new ArrayList();
                            var15_51.put(subType, ions);
                        }
                        for (ArrayList arrayList : neutralLossesCombinations) {
                            ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass - IonFactory.getLossesMass(arrayList), arrayList, massOffset));
                        }
                        subType = 2;
                        ions = (ArrayList)var15_51.get(subType);
                        if (ions == null) {
                            ions = new ArrayList();
                            var15_51.put(subType, ions);
                        }
                        for (ArrayList arrayList : neutralLossesCombinations) {
                            ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass + Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(arrayList), arrayList, massOffset));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                aminoAcid = massOffsets.iterator();
                while (aminoAcid.hasNext()) {
                    double d = (Double)aminoAcid.next();
                    double newMass = d + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap<Integer, ArrayList<Ion>> ionsMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (ionsMap == null) {
                    ionsMap = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, ionsMap);
                }
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    double d = (Double)iterator.next();
                    double forwardMass = d + gapMass;
                    int subType = 0;
                    ArrayList<Ion> ions = ionsMap.get(subType);
                    if (ions == null) {
                        ions = new ArrayList();
                        ionsMap.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass - Atom.C.getMonoisotopicMass() - Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d));
                    }
                    subType = 1;
                    ions = ionsMap.get(subType);
                    if (ions == null) {
                        ions = new ArrayList();
                        ionsMap.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass - IonFactory.getLossesMass(losses), losses, d));
                    }
                    subType = 2;
                    ions = ionsMap.get(subType);
                    if (ions == null) {
                        ions = new ArrayList();
                        ionsMap.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, forwardMass + Atom.N.getMonoisotopicMass() + 3.0 * Atom.H.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d));
                    }
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                Iterator iterator2 = massOffsets.iterator();
                while (iterator2.hasNext()) {
                    double offsetMass2 = (Double)iterator2.next();
                    arrayList.add(offsetMass2 + gapMass);
                }
                massOffsets = arrayList;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        ArrayList<TagComponent> reversedTag = new ArrayList<TagComponent>(tag.getContent());
        Collections.reverse(reversedTag);
        ionNumberOffset = 0;
        massOffsets.clear();
        massOffsets.add(0.0);
        for (TagComponent tagComponent : reversedTag) {
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                ArrayList patternMasses = new ArrayList();
                for (int i = aminoAcidPattern.length() - 1; i >= 0; --i) {
                    HashMap ionsMap;
                    ArrayList<Double> aminoAcidMasses = new ArrayList<Double>();
                    for (Character c : aminoAcidPattern.getTargetedAA(i)) {
                        ImmoniumIon immoniumIon;
                        int subType;
                        ArrayList<ImmoniumIon> ions;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(c.charValue());
                        double mass = aminoAcid.monoisotopicMass;
                        for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i + 1)) {
                            String ptmName = modificationMatch.getTheoreticPtm();
                            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                            if (processedPtms == null || !processedPtms.contains(ptmName)) {
                                for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                    int subType4;
                                    ArrayList<Ion> ions3;
                                    HashMap<Integer, ArrayList<Ion>> ionsMap4 = result.get(Ion.IonType.REPORTER_ION.index);
                                    if (ionsMap4 == null) {
                                        ionsMap4 = new HashMap();
                                        result.put(Ion.IonType.REPORTER_ION.index, ionsMap4);
                                    }
                                    if ((ions3 = ionsMap4.get(subType4 = ptmReporterIon.getSubType())) != null) continue;
                                    ions3 = new ArrayList();
                                    ionsMap4.put(subType4, ions3);
                                    ions3.add(ptmReporterIon);
                                }
                                for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                    boolean found = false;
                                    for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                        if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    possibleNeutralLosses.add(ptmNeutralLoss);
                                }
                                if (processedPtms == null) {
                                    processedPtms = new ArrayList();
                                }
                                processedPtms.add(ptmName);
                            }
                            mass += ptm.getMass();
                        }
                        if (!aminoAcidMasses.contains(mass)) {
                            aminoAcidMasses.add(mass);
                        }
                        if ((ionsMap = result.get(Ion.IonType.IMMONIUM_ION.index)) == null) {
                            ionsMap = new HashMap();
                            result.put(Ion.IonType.IMMONIUM_ION.index, ionsMap);
                        }
                        if ((ions = (ArrayList<ImmoniumIon>)ionsMap.get(subType = (immoniumIon = new ImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) != null) continue;
                        ions = new ArrayList<ImmoniumIon>();
                        ionsMap.put(subType, ions);
                        ions.add(immoniumIon);
                    }
                    HashMap<Integer, ArrayList<Ion>> hashMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (hashMap == null) {
                        HashMap hashMap7 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, hashMap7);
                    }
                    Iterator iterator = massOffsets.iterator();
                    while (iterator.hasNext()) {
                        void var15_58;
                        double massOffset = (Double)iterator.next();
                        ArrayList<Double> newPatternMassess = new ArrayList<Double>();
                        if (patternMasses.isEmpty()) {
                            ionsMap = aminoAcidMasses.iterator();
                            while (ionsMap.hasNext()) {
                                int n;
                                ArrayList<TagFragmentIon> ions;
                                double mass = (Double)ionsMap.next();
                                int aa6 = ionNumberOffset + aminoAcidPattern.length() - i;
                                int subaa = aminoAcidPattern.length() - i;
                                double rewindMass = massOffset + mass;
                                double gap = 0.0;
                                if (massOffset != Atom.O.getMonoisotopicMass()) {
                                    gap = massOffset;
                                }
                                if ((ions = (ArrayList<TagFragmentIon>)var15_58.get(n = 3)) == null) {
                                    ions = new ArrayList<TagFragmentIon>();
                                    var15_58.put(n, ions);
                                }
                                for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(n, aa6, subaa, rewindMass + Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                }
                                n = 4;
                                ions = (ArrayList<TagFragmentIon>)var15_58.get(n);
                                if (ions == null) {
                                    ions = new ArrayList<TagFragmentIon>();
                                    var15_58.put(n, ions);
                                }
                                for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(n, aa6, subaa, rewindMass + 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                }
                                n = 5;
                                ions = (ArrayList<TagFragmentIon>)var15_58.get(n);
                                if (ions == null) {
                                    ions = new ArrayList<TagFragmentIon>();
                                    var15_58.put(n, ions);
                                }
                                for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                    ions.add(new TagFragmentIon(n, aa6, subaa, rewindMass - Atom.N.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                }
                                if (newPatternMassess.contains(mass)) continue;
                                newPatternMassess.add(mass);
                            }
                        } else {
                            ionsMap = patternMasses.iterator();
                            while (ionsMap.hasNext()) {
                                double patternMass = (Double)ionsMap.next();
                                Iterator aa6 = aminoAcidMasses.iterator();
                                while (aa6.hasNext()) {
                                    int subType;
                                    ArrayList<TagFragmentIon> ions;
                                    double mass = (Double)aa6.next();
                                    int aa7 = ionNumberOffset + aminoAcidPattern.length() - i;
                                    int subaa = aminoAcidPattern.length() - i;
                                    double patternFragmentMass = patternMass + mass;
                                    double rewindMass = massOffset + patternFragmentMass;
                                    double gap = 0.0;
                                    if (massOffset != Atom.O.getMonoisotopicMass()) {
                                        gap = massOffset;
                                    }
                                    if ((ions = (ArrayList<TagFragmentIon>)var15_58.get(subType = 3)) == null) {
                                        ions = new ArrayList<TagFragmentIon>();
                                        var15_58.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa7, subaa, rewindMass + Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                    }
                                    subType = 4;
                                    ions = (ArrayList<TagFragmentIon>)var15_58.get(subType);
                                    if (ions == null) {
                                        ions = new ArrayList<TagFragmentIon>();
                                        var15_58.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa7, subaa, rewindMass + 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                    }
                                    subType = 5;
                                    ions = (ArrayList<TagFragmentIon>)var15_58.get(subType);
                                    if (ions == null) {
                                        ions = new ArrayList<TagFragmentIon>();
                                        var15_58.put(subType, ions);
                                    }
                                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                                        ions.add(new TagFragmentIon(subType, aa7, subaa, rewindMass - Atom.N.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                                    }
                                    if (newPatternMassess.contains(patternFragmentMass)) continue;
                                    newPatternMassess.add(patternFragmentMass);
                                }
                            }
                        }
                        patternMasses = newPatternMassess;
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator aminoAcidMasses = massOffsets.iterator();
                while (aminoAcidMasses.hasNext()) {
                    double d = (Double)aminoAcidMasses.next();
                    Iterator massOffset = patternMasses.iterator();
                    while (massOffset.hasNext()) {
                        double mass = (Double)massOffset.next();
                        double newMass = d + mass;
                        if (newOffsetMasses.contains(newMass)) continue;
                        newOffsetMasses.add(newMass);
                    }
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                double sequenceMass = 0.0;
                for (int i = aminoAcidSequence.length() - 1; i >= 0; --i) {
                    ImmoniumIon immoniumIon;
                    int subType;
                    void var16_75;
                    ArrayList<ImmoniumIon> ions;
                    AminoAcid aminoAcid = aminoAcidSequence.getAminoAcidAt(i);
                    HashMap<Integer, ArrayList<Ion>> hashMap = result.get(Ion.IonType.IMMONIUM_ION.index);
                    if (hashMap == null) {
                        HashMap hashMap8 = new HashMap();
                        result.put(Ion.IonType.IMMONIUM_ION.index, hashMap8);
                    }
                    if ((ions = (ArrayList<ImmoniumIon>)var16_75.get(subType = (immoniumIon = new ImmoniumIon(aminoAcid.getSingleLetterCodeAsChar())).getSubType())) == null) {
                        ions = new ArrayList<ImmoniumIon>();
                        var16_75.put(subType, ions);
                        ions.add(immoniumIon);
                    }
                    double mass = aminoAcid.monoisotopicMass;
                    for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(i + 1)) {
                        String ptmName = modificationMatch.getTheoreticPtm();
                        PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                        if (processedPtms == null || !processedPtms.contains(ptmName)) {
                            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                                void var16_79;
                                HashMap<Integer, ArrayList<Ion>> hashMap9 = result.get(Ion.IonType.REPORTER_ION.index);
                                if (hashMap9 == null) {
                                    HashMap hashMap10 = new HashMap();
                                    result.put(Ion.IonType.REPORTER_ION.index, hashMap10);
                                }
                                if ((ions = (ArrayList<ImmoniumIon>)var16_79.get(subType = ptmReporterIon.getSubType())) != null) continue;
                                ions = new ArrayList<ImmoniumIon>();
                                var16_79.put(subType, ions);
                                ions.add((ImmoniumIon)((Object)ptmReporterIon));
                            }
                            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                                boolean found = false;
                                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                possibleNeutralLosses.add(ptmNeutralLoss);
                            }
                            if (processedPtms == null) {
                                processedPtms = new ArrayList();
                            }
                            processedPtms.add(ptmName);
                        }
                        mass += ptm.getMass();
                    }
                    sequenceMass += mass;
                    HashMap<Integer, ArrayList<Ion>> hashMap11 = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                    if (hashMap11 == null) {
                        HashMap hashMap12 = new HashMap();
                        result.put(Ion.IonType.TAG_FRAGMENT_ION.index, hashMap12);
                    }
                    Iterator<ModificationMatch> iterator = massOffsets.iterator();
                    while (iterator.hasNext()) {
                        void var16_82;
                        double massOffset = (Double)((Object)iterator.next());
                        int aa = ionNumberOffset + aminoAcidSequence.length() - i;
                        int subaa = aminoAcidSequence.length() - i;
                        double rewindMass = massOffset + sequenceMass;
                        double d = 0.0;
                        if (massOffset != Atom.O.getMonoisotopicMass()) {
                            d = massOffset;
                        }
                        if ((ions = (ArrayList<ImmoniumIon>)var16_82.get(subType = 3)) == null) {
                            ions = new ArrayList<ImmoniumIon>();
                            var16_82.put(subType, ions);
                        }
                        for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                            ions.add((ImmoniumIon)((Object)new TagFragmentIon(subType, aa, subaa, rewindMass + Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d)));
                        }
                        subType = 4;
                        ions = (ArrayList<ImmoniumIon>)var16_82.get(subType);
                        if (ions == null) {
                            ions = new ArrayList<ImmoniumIon>();
                            var16_82.put(subType, ions);
                        }
                        for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                            ions.add((ImmoniumIon)((Object)new TagFragmentIon(subType, aa, subaa, rewindMass + 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d)));
                        }
                        subType = 5;
                        ions = (ArrayList<ImmoniumIon>)var16_82.get(subType);
                        if (ions == null) {
                            ions = new ArrayList<ImmoniumIon>();
                            var16_82.put(subType, ions);
                        }
                        for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                            ions.add((ImmoniumIon)((Object)new TagFragmentIon(subType, aa, subaa, rewindMass - Atom.N.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, d)));
                        }
                    }
                }
                ArrayList<Double> newOffsetMasses = new ArrayList<Double>();
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    double d = (Double)iterator.next();
                    double newMass = d + sequenceMass;
                    if (newOffsetMasses.contains(newMass)) continue;
                    newOffsetMasses.add(newMass);
                }
                massOffsets = newOffsetMasses;
                ionNumberOffset += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                double gapMass = tagComponent.getMass();
                int aa = ionNumberOffset;
                int subaa = 0;
                HashMap<Integer, ArrayList<Ion>> hashMap = result.get(Ion.IonType.TAG_FRAGMENT_ION.index);
                if (hashMap == null) {
                    HashMap hashMap13 = new HashMap();
                    result.put(Ion.IonType.TAG_FRAGMENT_ION.index, hashMap13);
                }
                Iterator iterator = massOffsets.iterator();
                while (iterator.hasNext()) {
                    void var15_64;
                    double massOffset = (Double)iterator.next();
                    double gap = gapMass;
                    if (massOffset != Atom.O.getMonoisotopicMass()) {
                        gap += massOffset;
                    }
                    double rewindMass = massOffset + gapMass;
                    int subType = 3;
                    ArrayList<TagFragmentIon> ions = (ArrayList<TagFragmentIon>)var15_64.get(subType);
                    if (ions == null) {
                        ions = new ArrayList<TagFragmentIon>();
                        var15_64.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, rewindMass + Atom.C.getMonoisotopicMass() + 2.0 * Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                    }
                    subType = 4;
                    ions = (ArrayList<TagFragmentIon>)var15_64.get(subType);
                    if (ions == null) {
                        ions = new ArrayList<TagFragmentIon>();
                        var15_64.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, rewindMass + 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                    }
                    subType = 5;
                    ions = (ArrayList<TagFragmentIon>)var15_64.get(subType);
                    if (ions == null) {
                        ions = new ArrayList<TagFragmentIon>();
                        var15_64.put(subType, ions);
                    }
                    for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                        ions.add(new TagFragmentIon(subType, aa, subaa, rewindMass - Atom.N.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() - IonFactory.getLossesMass(losses), losses, gap));
                    }
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                Iterator iterator3 = massOffsets.iterator();
                while (iterator3.hasNext()) {
                    double offsetMass3 = (Double)iterator3.next();
                    arrayList.add(offsetMass3 + gapMass);
                }
                massOffsets = arrayList;
                ++ionNumberOffset;
                continue;
            }
            throw new UnsupportedOperationException("Fragment ion not implemented for tag component " + tagComponent.getClass() + ".");
        }
        return result;
    }

    public static ArrayList<ArrayList<NeutralLoss>> getAccountedNeutralLosses(ArrayList<NeutralLoss> possibleNeutralLosses) {
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = new ArrayList<ArrayList<NeutralLoss>>();
        ArrayList<NeutralLoss> tempList = new ArrayList<NeutralLoss>();
        neutralLossesCombinations.add(tempList);
        for (NeutralLoss neutralLoss1 : possibleNeutralLosses) {
            boolean found = false;
            for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                if (accountedCombination.size() != 1 || !accountedCombination.get(0).isSameAs(neutralLoss1)) continue;
                found = true;
            }
            if (!found) {
                tempList = new ArrayList();
                tempList.add(neutralLoss1);
                neutralLossesCombinations.add(tempList);
            }
            for (NeutralLoss neutralLoss2 : possibleNeutralLosses) {
                if (neutralLoss1.isSameAs(neutralLoss2)) continue;
                found = false;
                for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                    if (accountedCombination.size() != 2) continue;
                    if (accountedCombination.get(0).isSameAs(neutralLoss1) && accountedCombination.get(1).isSameAs(neutralLoss2)) {
                        found = true;
                        break;
                    }
                    if (!accountedCombination.get(0).isSameAs(neutralLoss2) || !accountedCombination.get(1).isSameAs(neutralLoss1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                tempList = new ArrayList();
                tempList.add(neutralLoss1);
                tempList.add(neutralLoss2);
                neutralLossesCombinations.add(tempList);
            }
        }
        return neutralLossesCombinations;
    }

    public static double getLossesMass(ArrayList<NeutralLoss> neutralLosses) {
        double result = 0.0;
        for (NeutralLoss neutralLoss : neutralLosses) {
            result += neutralLoss.mass;
        }
        return result;
    }
}

