/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.IdentificationAlgorithmParameter;

public class MsAmandaParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -8458620189315975268L;
    private boolean generateDecoy = false;
    private String instrumentID = "b, y";
    private Integer maxRank = 10;
    private boolean monoisotopic = true;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.msAmanda;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof MsAmandaParameters) {
            MsAmandaParameters msAmandaParameters = (MsAmandaParameters)identificationAlgorithmParameter;
            if (this.generateDecoy != msAmandaParameters.generateDecoy()) {
                return false;
            }
            if (this.monoisotopic != msAmandaParameters.isMonoIsotopic()) {
                return false;
            }
            if (!this.instrumentID.equalsIgnoreCase(msAmandaParameters.getInstrumentID())) {
                return false;
            }
            return this.maxRank == msAmandaParameters.getMaxRank();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("SEARCH_DECOY=");
        output.append(this.generateDecoy);
        output.append(newLine);
        output.append("INSTRUMENT_ID=");
        output.append(this.instrumentID);
        output.append(newLine);
        output.append("MONOISOTOPIC=");
        output.append(this.monoisotopic);
        output.append(newLine);
        output.append("MAX_RANK=");
        output.append(this.maxRank);
        output.append(newLine);
        return output.toString();
    }

    public boolean generateDecoy() {
        return this.generateDecoy;
    }

    public void setGenerateDecoyDatabase(boolean generateDecoy) {
        this.generateDecoy = generateDecoy;
    }

    public boolean isMonoIsotopic() {
        return this.monoisotopic;
    }

    public void setMonoIsotopic(boolean monoisotopic) {
        this.monoisotopic = monoisotopic;
    }

    public String getInstrumentID() {
        return this.instrumentID;
    }

    public void setInstrumentID(String instrumentID) {
        this.instrumentID = instrumentID;
    }

    public Integer getMaxRank() {
        return this.maxRank;
    }

    public void setMaxRank(Integer maxRank) {
        this.maxRank = maxRank;
    }
}

