/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class MgfFileIterator {
    private BufferedReader br;
    private MSnSpectrum nextSpectrum = null;
    private String mgfFileName;
    private int rank;

    public MgfFileIterator(File mgfFile) throws FileNotFoundException, IOException {
        this.mgfFileName = mgfFile.getName();
        this.br = new BufferedReader(new FileReader(mgfFile));
        this.nextSpectrum = MgfReader.getSpectrum(this.br, this.mgfFileName);
        this.rank = 1;
        if (this.nextSpectrum.getScanNumber() == null) {
            this.nextSpectrum.setScanNumber(this.rank + "");
        } else {
            while (this.nextSpectrum.getScanNumber().equals(++this.rank + "")) {
            }
        }
    }

    public boolean hasNext() {
        return this.nextSpectrum != null;
    }

    public MSnSpectrum next() throws IOException {
        MSnSpectrum currentSpectrum = this.nextSpectrum;
        this.nextSpectrum = MgfReader.getSpectrum(this.br, this.mgfFileName);
        if (this.nextSpectrum == null) {
            this.br.close();
        } else if (this.nextSpectrum.getScanNumber() == null) {
            this.nextSpectrum.setScanNumber(++this.rank + "");
        } else {
            while (this.nextSpectrum.getScanNumber().equals(++this.rank + "")) {
            }
        }
        return currentSpectrum;
    }
}

