/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPDownloader {
    private FTPClient ftp = new FTPClient();

    public FTPDownloader(String host) throws Exception {
        this(host, "anonymous", "anonymous", false);
    }

    public FTPDownloader(String host, boolean debug) throws Exception {
        this(host, "anonymous", "anonymous", debug);
    }

    public FTPDownloader(String host, String user, String pwd, boolean debug) throws Exception {
        if (debug) {
            this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
        this.ftp.connect(host);
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.ftp.disconnect();
            throw new Exception("Could not connect to FTP Server.");
        }
        this.ftp.login(user, pwd);
        this.ftp.setFileType(2);
        this.ftp.enterLocalPassiveMode();
    }

    public void downloadFile(String remoteFilePath, File localFilePath) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(localFilePath);
        this.ftp.retrieveFile(remoteFilePath, (OutputStream)fos);
    }

    public void disconnect() throws IOException {
        if (this.ftp.isConnected()) {
            this.ftp.logout();
            this.ftp.disconnect();
        }
    }
}

