/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.writers;

import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExcelWriter
extends ExportWriter {
    private HSSFWorkbook workbook;
    private WorkbookStyle workbookStyle = null;
    private final File destinationFile;
    private int sheetNumber;
    private HSSFSheet currentSheet;
    private int hierarchicalDepth = 0;
    private final HashMap<Integer, Integer> collapsedRow = new HashMap();
    private int rowNumber = 0;
    private int cellNumber = 0;
    private HSSFRow currentRow = null;
    private StringBuilder currentCellContent = new StringBuilder();
    private CellStyle currentCellStyle = null;

    public ExcelWriter(File destinationFile) {
        this.destinationFile = destinationFile;
        this.workbook = new HSSFWorkbook();
        this.exportFormat = ExportFormat.excel;
    }

    public WorkbookStyle getWorkbookStyle() {
        return this.workbookStyle;
    }

    public void setWorkbookStyle(WorkbookStyle workbookStyle) {
        this.workbookStyle = workbookStyle;
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public void write(String text, WorkbookStyle textStyle) throws IOException {
        if (this.currentRow == null) {
            if (this.currentSheet == null) {
                throw new IllegalArgumentException("No section started to write in.");
            }
            this.currentRow = this.currentSheet.createRow(this.rowNumber);
            ++this.rowNumber;
            if (textStyle != null) {
                this.currentRow.setHeightInPoints(textStyle.getStandardHeight());
            } else if (this.workbookStyle != null) {
                this.currentRow.setHeightInPoints(this.workbookStyle.getStandardHeight());
            } else {
                this.currentRow.setHeightInPoints(12.75f);
            }
        }
        if (textStyle != null) {
            this.currentCellStyle = textStyle.getStandardStyle(this.hierarchicalDepth);
        } else if (this.workbookStyle != null) {
            this.currentCellStyle = this.workbookStyle.getStandardStyle(this.hierarchicalDepth);
        }
        this.currentCellContent.append(text);
    }

    @Override
    public void writeMainTitle(String text, WorkbookStyle textStyle) throws IOException {
        if (text != null) {
            HSSFSheet sheet = this.workbook.createSheet(" ");
            sheet.setRowSumsBelow(false);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(text);
            if (textStyle != null) {
                row.setHeightInPoints(textStyle.getMainTitleRowHeight());
                CellStyle cellStyle = textStyle.getStandardStyle(this.hierarchicalDepth);
                cell.setCellStyle(cellStyle);
            } else if (this.workbookStyle != null) {
                row.setHeightInPoints(this.workbookStyle.getMainTitleRowHeight());
                CellStyle cellStyle = this.workbookStyle.getStandardStyle(this.hierarchicalDepth);
                cell.setCellStyle(cellStyle);
            } else {
                row.setHeightInPoints(12.75f);
            }
            ++this.sheetNumber;
        }
    }

    @Override
    public void startNewSection(String sectionTitle, WorkbookStyle textStyle) throws IOException {
        if (this.currentCellContent.length() > 0) {
            this.addSeparator();
        }
        this.rowNumber = 0;
        this.cellNumber = 0;
        String sheetName = sectionTitle;
        if (sheetName == null) {
            sheetName = this.sheetNumber++ + "";
        }
        this.currentRow = null;
        this.currentSheet = this.workbook.createSheet(sheetName);
    }

    @Override
    public void writeHeaderText(String text, WorkbookStyle textStyle) throws IOException {
        if (this.currentRow == null) {
            if (this.currentSheet == null) {
                throw new IllegalArgumentException("No section started to write in.");
            }
            this.currentRow = this.currentSheet.createRow(this.rowNumber);
            ++this.rowNumber;
            if (textStyle != null) {
                this.currentRow.setHeightInPoints(textStyle.getHeaderHeight());
            } else if (this.workbookStyle != null) {
                this.currentRow.setHeightInPoints(this.workbookStyle.getHeaderHeight());
            } else {
                this.currentRow.setHeightInPoints(12.75f);
            }
        }
        if (textStyle != null) {
            this.currentCellStyle = textStyle.getHeaderStyle(this.hierarchicalDepth);
        } else if (this.workbookStyle != null) {
            this.currentCellStyle = this.workbookStyle.getHeaderStyle(this.hierarchicalDepth);
        }
        this.currentCellContent.append(text);
    }

    @Override
    public void addSeparator(WorkbookStyle textStyle) throws IOException {
        HSSFCell cell;
        block9: {
            if (this.currentRow == null) {
                if (this.currentSheet == null) {
                    throw new IllegalArgumentException("No section started to write in.");
                }
                this.currentRow = this.currentSheet.createRow(this.rowNumber);
                ++this.rowNumber;
                if (textStyle != null) {
                    this.currentRow.setHeightInPoints(textStyle.getStandardHeight());
                } else if (this.workbookStyle != null) {
                    this.currentRow.setHeightInPoints(this.workbookStyle.getStandardHeight());
                } else {
                    this.currentRow.setHeightInPoints(12.75f);
                }
            }
            cell = this.currentRow.createCell(this.cellNumber);
            ++this.cellNumber;
            String content = this.currentCellContent.toString();
            try {
                Double value = new Double(content);
                cell.setCellValue(value.doubleValue());
                cell.setCellType(0);
            }
            catch (Exception e) {
                if (content.equals("")) break block9;
                cell.setCellValue(content);
            }
        }
        this.currentCellContent = new StringBuilder();
        if (this.currentCellStyle != null) {
            cell.setCellStyle(this.currentCellStyle);
        }
        this.currentCellStyle = null;
    }

    @Override
    public void newLine() throws IOException {
        if (this.currentRow == null) {
            if (this.currentSheet == null) {
                throw new IllegalArgumentException("No section to write in.");
            }
            this.currentRow = this.currentSheet.createRow(this.rowNumber);
            ++this.rowNumber;
        } else {
            if (this.currentCellContent.length() > 0) {
                this.addSeparator();
            }
            this.currentRow = null;
        }
        this.cellNumber = 0;
    }

    @Override
    public void close() throws IOException, FileNotFoundException {
        FileOutputStream fileOut = new FileOutputStream(this.destinationFile);
        try {
            this.workbook.write((OutputStream)fileOut);
        }
        finally {
            fileOut.close();
        }
    }

    @Override
    public void increaseDepth() {
        this.collapsedRow.put(++this.hierarchicalDepth, this.rowNumber);
    }

    @Override
    public void decreseDepth() {
        Integer originalRow = this.collapsedRow.get(this.hierarchicalDepth);
        if (originalRow == null) {
            throw new IllegalArgumentException("No original row found for hierarchical depth " + originalRow + ".");
        }
        this.currentSheet.groupRow(originalRow.intValue(), this.rowNumber);
        this.currentSheet.setRowGroupCollapsed(originalRow.intValue(), true);
        --this.hierarchicalDepth;
    }
}

