/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.storage.BitSequenceReader;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public class FourBitSequenceReader<C extends Compound>
extends BitSequenceReader<C> {
    public FourBitSequenceReader(Sequence<C> sequence) {
        super(new FourBitArrayWorker<C>(sequence), sequence.getAccession());
    }

    public FourBitSequenceReader(String sequence, CompoundSet<C> compoundSet) {
        this(sequence, compoundSet, new AccessionID("Unknown"));
    }

    public FourBitSequenceReader(String sequence, CompoundSet<C> compoundSet, AccessionID accession) {
        super(new FourBitArrayWorker<C>(sequence, compoundSet), accession);
    }

    public FourBitSequenceReader(FourBitArrayWorker<C> worker) {
        super(worker, new AccessionID("unknown"));
    }

    public FourBitSequenceReader(FourBitArrayWorker<C> worker, AccessionID accession) {
        super(worker, accession);
    }

    public static class FourBitArrayWorker<C extends Compound>
    extends BitSequenceReader.BitArrayWorker<C> {
        private static final byte MASK = (byte)((int)Math.pow(2.0, 0.0) | (int)Math.pow(2.0, 1.0) | (int)Math.pow(2.0, 2.0) | (int)Math.pow(2.0, 3.0));

        public FourBitArrayWorker(CompoundSet<C> compoundSet, int length) {
            super(compoundSet, length);
        }

        public FourBitArrayWorker(CompoundSet<C> compoundSet, int[] sequence) {
            super(compoundSet, sequence);
        }

        public FourBitArrayWorker(Sequence<C> sequence) {
            super(sequence);
        }

        public FourBitArrayWorker(String sequence, CompoundSet<C> compoundSet) {
            super(sequence, compoundSet);
        }

        @Override
        protected byte bitMask() {
            return MASK;
        }

        @Override
        protected int compoundsPerDatatype() {
            return 8;
        }

        @Override
        protected Map<C, Integer> generateCompoundsToIndex() {
            CompoundSet cs = this.getCompoundSet();
            HashMap map = new HashMap();
            int index = 0;
            for (Compound currentCompound : this.sortedCompounds(cs)) {
                Compound upperCasedCompound = this.getOptionalUpperCasedCompound(currentCompound, cs);
                if (map.containsKey(upperCasedCompound)) {
                    map.put(currentCompound, map.get(upperCasedCompound));
                    continue;
                }
                map.put(currentCompound, index++);
            }
            return map;
        }

        private C getOptionalUpperCasedCompound(C currentCompound, CompoundSet<C> cs) {
            C upperCasedCompound = null;
            String upperCasedString = cs.getStringForCompound(currentCompound).toUpperCase();
            upperCasedCompound = cs.getCompoundForString(upperCasedString) == null ? (C)currentCompound : (C)cs.getCompoundForString(upperCasedString);
            return upperCasedCompound;
        }

        private List<C> sortedCompounds(final CompoundSet<C> cs) {
            ArrayList<C> compounds = new ArrayList<C>(cs.getAllCompounds());
            Collections.sort(compounds, new Comparator<C>(){

                @Override
                public int compare(C o1, C o2) {
                    String s1 = cs.getStringForCompound(o1);
                    String s2 = cs.getStringForCompound(o2);
                    return s1.compareTo(s2);
                }
            });
            return compounds;
        }

        @Override
        protected List<C> generateIndexToCompounds() {
            CompoundSet cs = this.getCompoundSet();
            Map lookup = this.getCompoundsToIndexLookup();
            HashMap<Integer, Compound> tempMap = new HashMap<Integer, Compound>();
            for (Compound compound : lookup.keySet()) {
                Compound upperCasedCompound = this.getOptionalUpperCasedCompound(compound, cs);
                Integer pos = lookup.get(upperCasedCompound);
                tempMap.put(pos, upperCasedCompound);
            }
            ArrayList compounds = new ArrayList();
            ArrayList keys = new ArrayList(tempMap.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                compounds.add(tempMap.get(key));
            }
            return compounds;
        }
    }
}

