## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ------------------------------------------------------------------------
suppressMessages(library(TReNA))

## ------------------------------------------------------------------------
load(system.file(package="TReNA", "extdata/ampAD.154genes.mef2cTFs.278samples.RData"))

## ----echo=FALSE, fig.width = 6-------------------------------------------
hist(mtx.sub, main = "Expression Matrix Data")

## ------------------------------------------------------------------------
suppressMessages(library(limma))
mtx.voom <- voom(mtx.sub)$E

## ----echo=FALSE, fig.width = 6-------------------------------------------
hist(mtx.voom, main = "VOOM-Transformed Expression Matrix Data")

## ------------------------------------------------------------------------
trena <- TReNA(mtx.assay = mtx.voom, solver = "randomForest")

## ------------------------------------------------------------------------

null.filter <- NullFilter(mtx.assay = mtx.voom)
tfs <- getCandidates(null.filter)
str(tfs)


## ------------------------------------------------------------------------

variance.filter <- VarianceFilter(mtx.assay = mtx.voom)
tf.list <- getCandidates(variance.filter, extraArgs = list("target.gene" = "MEF2C", "var.size" = 0.5))
str(tf.list)


## ------------------------------------------------------------------------
footprint.filter <- FootprintFilter(mtx.assay = mtx.voom)
db.address <- system.file(package = "TReNA", "extdata")
genome.db.uri <- paste("sqlite:/",db.address,"genome.sub.db", sep = "/")
project.db.uri <- paste("sqlite:/",db.address,"project.sub.db", sep = "/")
target.gene <- "MEF2C"
tfs <- getCandidates(footprint.filter, extraArgs = list("target.gene" = target.gene,
                                                        "genome.db.uri"=genome.db.uri, 
                                                        "project.db.uri" = project.db.uri,
                                                        "size.upstream" = 1000,
                                                        "size.downstream" = 1000))
str(tfs)

## ------------------------------------------------------------------------
genome.db.uri    <- "postgres://bddsrds.globusgenomics.org/hg38"  # has gtf and motifsgenes tables
footprint.db.uri <- "postgres://bddsrds.globusgenomics.org/brain_hint"  # has hits and regions tables
fpf <- FootprintFinder(genome.db.uri, footprint.db.uri, quiet=FALSE)
tbl.fp <- getFootprintsInRegion(fpf, "chr5", 88822685, 89011824)
str(tbl.fp)

## ------------------------------------------------------------------------

trena <- TReNA(mtx.assay = mtx.voom, solver = "lasso")
target.gene <- "MEF2C"
gene.filter <- VarianceFilter(mtx.assay = mtx.voom)
tf.list <- getCandidates(gene.filter, extraArgs = list("target.gene" = target.gene, "var.size" = 0.5))

tbl.out <- solve(trena, target.gene, tf.list$tfs)
head(tbl.out)


## ------------------------------------------------------------------------
trena <- TReNA(mtx.assay = mtx.voom, solver = "ensemble")
target.gene <- "MEF2C"
gene.filter <- VarianceFilter(mtx.assay = mtx.voom)
tf.list <- getCandidates(gene.filter, extraArgs = list("target.gene" = target.gene, "var.size" = 0.5))
tbl.out <- solve(trena, target.gene, tf.list$tfs)
tbl.out

## ------------------------------------------------------------------------

tbl.out.2 <- solve(trena, target.gene, tf.list$tfs, 
                   extraArgs = list(
                     "solver.list" = c("lasso", "ridge", "sqrtlasso", "randomForest",
                                       "lassopv", "spearman", "pearson"),
                     "sqrtlasso" = list("num.cores" = 4)
                   ))
tbl.out.2

