### R code from vignette source 'RICorrection.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=80)


###################################################
### code chunk number 2: LibraryPreload
###################################################
library(TargetSearch)
library(TargetSearchData)


###################################################
### code chunk number 3: cdffiles
###################################################
cdfPath <- file.path(find.package("TargetSearchData"), "gc-ms-data")
dir(cdfPath, pattern="cdf$")


###################################################
### code chunk number 4: samples
###################################################
samples.all <- ImportSamplesFromDir(cdfPath)
RIpath(samples.all) <- "."


###################################################
### code chunk number 5: rim
###################################################
rimLimits <- ImportFameSettings(file.path(cdfPath,"rimLimits.txt"))
rimLimits


###################################################
### code chunk number 6: ricorrect
###################################################
RImatrix <- RIcorrect(samples.all, rimLimits, massRange=c(85,320),
            Window=15, pp.method="ppc", IntThreshold=50)
RImatrix


###################################################
### code chunk number 7: isRIMarker
###################################################
isRIMarker <- c(T, F, F, F, F, T, F, F, F, F, T, F, F, F, F)


###################################################
### code chunk number 8: updateRImatrix2
###################################################
RImatrix2 <- RImatrix
RImatrix2[, 2:5]   <- RImatrix[,1]
RImatrix2[, 7:10]  <- RImatrix[,6]
RImatrix2[, 12:15] <- RImatrix[,11]


###################################################
### code chunk number 9: updateRImatrix
###################################################
RImatrix2 <- RImatrix
z <- cumsum(as.numeric(isRIMarker))
for(i in unique(z))
    RImatrix2[, z==i] <- RImatrix[, z==i][,1]
RImatrix2


###################################################
### code chunk number 10: fixRI
###################################################
fixRI(samples.all, rimLimits, RImatrix2, which(!isRIMarker))


###################################################
### code chunk number 11: finally
###################################################
samples <- samples.all[!isRIMarker]
RImatrix <- RImatrix2[, !isRIMarker]


