/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.systemsbiology.gaggle.boss.GuiBoss;

public class GaggleBossTableModel
extends AbstractTableModel {
    private GuiBoss parentApp;
    private ArrayList applicationNames = new ArrayList();
    private ArrayList listeningState = new ArrayList();
    private ArrayList selectionCounts = new ArrayList();
    private String[] appNames;
    private String[] columnNames = new String[]{"Geese", "Listening?"};

    public GaggleBossTableModel(GuiBoss parentApp) {
        this.parentApp = parentApp;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public int getRowCount() {
        return this.applicationNames.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public void setValueAt(Object value, int row, int column) {
        try {
            if (column == 0) {
                String proposedName = (String)value;
                String uniquifiedName = this.parentApp.actuallyRenameGoose((String)this.applicationNames.get(row), proposedName);
                if (uniquifiedName != null) {
                    this.applicationNames.set(row, uniquifiedName);
                }
            } else if (column == 1) {
                this.listeningState.set(row, value);
            }
        }
        catch (Exception ex0) {
            System.out.println("GaggleBossTableModel.setValueAt exception: " + ex0.getMessage());
            String msg = "Failed to contact goose to rename!";
            JOptionPane.showMessageDialog(this.parentApp.frame, msg);
        }
    }

    public Object getValueAt(int row, int column) {
        Object result = null;
        if (column == 0 && row < this.applicationNames.size()) {
            result = (String)this.applicationNames.get(row);
        } else if (column == 1 && row < this.listeningState.size()) {
            result = (Boolean)this.listeningState.get(row);
        }
        return result;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    protected int getGooseRow(String gooseName) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            String name = (String)this.getValueAt(row, 0);
            if (!name.equals(gooseName)) continue;
            return row;
        }
        throw new IllegalArgumentException("could not find row for goose named '" + gooseName + "'");
    }

    public boolean isListening(String gooseName) {
        int row = this.getGooseRow(gooseName);
        return (Boolean)this.getValueAt(row, 1);
    }

    public void setListeningState(String gooseName, boolean newValue) {
        int row = this.getGooseRow(gooseName);
        this.setValueAt(new Boolean(newValue), row, 1);
        this.fireTableStructureChanged();
    }

    public void addClient(String newClientName) {
        this.applicationNames.add(newClientName);
        this.listeningState.add(new Boolean(true));
        JButton button = new JButton(" ");
        this.selectionCounts.add(new Integer(0));
        this.fireTableStructureChanged();
    }

    public void removeGoose(String gooseName) {
        int row = this.getGooseRow(gooseName);
        this.applicationNames.remove(row);
        this.listeningState.remove(row);
        this.selectionCounts.remove(row);
        this.fireTableStructureChanged();
    }

    public void setAppNameAtRow(Object value, int row) {
        this.applicationNames.set(row, value);
    }

    public void setSelectionCount(String gooseName, int selectionCount) {
        int row = this.getGooseRow(gooseName);
    }

    public String[] getAppNames() {
        return this.applicationNames.toArray(new String[0]);
    }
}

