/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.util;

import cytoscape.data.servers.BioDataServer;
import java.util.Arrays;
import java.util.HashMap;
import org.systemsbiology.gaggle.util.NameHelper;

public class NameHelperFactory {
    protected static HashMap helpers = new HashMap();

    public static NameHelper getNameHelper(String species) {
        BioDataServer bioDataServer = null;
        String canonicalSpeciesName = NameHelperFactory.canonicalizeSpeciesName(species);
        boolean recognizedSpecies = true;
        if (helpers.containsKey(canonicalSpeciesName)) {
            System.out.println("found cached NameHelper for " + canonicalSpeciesName);
            return (NameHelper)helpers.get(canonicalSpeciesName);
        }
        System.out.println("   no cached NameHelper for " + canonicalSpeciesName);
        String serverUri = "";
        if (canonicalSpeciesName.equals("Halobacterium sp.")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/halo/manifest";
        } else if (canonicalSpeciesName.equals("Helicobacter pylori")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/hpy/manifest";
        } else if (canonicalSpeciesName.equals("Homo sapiens")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/human/manifest-synonyms-only";
        } else if (canonicalSpeciesName.equals("Mus musculus")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/mouse/manifest-synonyms-only";
        } else if (canonicalSpeciesName.equals("Drosophila melanogaster")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/fly/manifest-cg";
        } else if (canonicalSpeciesName.equals("Saccharomyces cerevisiae")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/yeast/manifest";
        } else if (canonicalSpeciesName.equals("Pyrococcus furiosus")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/pyrococcusFuriosus/manifest";
            System.out.println("NHF detected pyrococcus");
        } else if (canonicalSpeciesName.equals("Sulfolobus solfataricus")) {
            serverUri = "http://db.systemsbiology.net/cytoscape/annotation/sulfolobusSolfataricus/manifest";
        } else {
            recognizedSpecies = false;
        }
        System.out.println("\n---------- recognized species? " + recognizedSpecies + "\n");
        if (recognizedSpecies) {
            try {
                bioDataServer = new BioDataServer(serverUri);
            }
            catch (Exception e) {
                System.err.println("Exception creating biodataserver for species '" + species + "'");
                e.printStackTrace();
            }
        }
        NameHelper newHelper = new NameHelper(canonicalSpeciesName, bioDataServer);
        helpers.put(canonicalSpeciesName, newHelper);
        return newHelper;
    }

    protected static String canonicalizeSpeciesName(String name) {
        String lowerCaseName = name.toLowerCase();
        String result = name;
        Object[] haloNames = new String[]{"halo", "halobacterium", "halobacterium sp.", "halobacterium nrc-1", "halobacterium sp. nrc-1", "halobacterium salinarum"};
        Arrays.sort(haloNames);
        if (Arrays.binarySearch(haloNames, lowerCaseName) >= 0) {
            result = "Halobacterium sp.";
        }
        Object[] humanNames = new String[]{"human", "homo sapiens", "homo"};
        Arrays.sort(humanNames);
        if (Arrays.binarySearch(humanNames, lowerCaseName) >= 0) {
            result = "Homo sapiens";
        }
        Object[] hpyNames = new String[]{"helicobacter pylori", "h. pylori", "hpy"};
        Arrays.sort(hpyNames);
        if (Arrays.binarySearch(hpyNames, lowerCaseName) >= 0) {
            result = "Helicobacter pylori";
        }
        Object[] flyNames = new String[]{"drosophila melanogaster", "drosophila", "fly"};
        Arrays.sort(flyNames);
        if (Arrays.binarySearch(flyNames, lowerCaseName) >= 0) {
            result = "Drosophila melanogaster";
        }
        return result;
    }
}

