## ----global_options, echo = FALSE, include = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width  = 999)
knitr::opts_chunk$set(echo = TRUE, warning = FALSE, message = FALSE,
                      cache = FALSE, tidy = FALSE, size = "small")

## ----setup, echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE)

## ----message = FALSE,warning = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
miRNANames = miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames, verbose = TRUE)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
Accessions = miRNATest$Accession

#### 1. Convert to the Accessions to miRNA names in miRBase version 13
result1 = miRNA_AccessionToName(Accessions,targetVersion = "v13")
result1[c(341:345),]

####2. Convert to the Accessions to miRNA names in miRBase version 21.
result2 = miRNA_AccessionToName(Accessions,targetVersion = "v21")
result2[c(341:345),]

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
miRNANames = miRNATest$miRNA_Name
result1 = miRNA_NameToAccession(miRNANames,version = "v18")
result1[c(341:345),]

## ----message = TRUE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
miRNANames = miRNATest$miRNA_Name
result1 = miRNAVersionConvert(miRNANames,targetVersion = "v13",exact = TRUE)
result1[c(341:345),]

result2 = miRNAVersionConvert(miRNANames,targetVersion = "v20",exact = TRUE)

result2[c(341:345),]

## ----message = TRUE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
miRNANames = miRNATest$miRNA_Name

#### Step 1. Check the possible version for miRNAs
data(miRNATest)
miRNANames = miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames, verbose = FALSE)

#### Step 2. miRNA Names to miRBase Accessions with the specific version information
result1 = miRNA_NameToAccession(miRNANames,version = version)

#### Step 3. miRBase Accessions to miRNA Names of the target version
result2 = miRNA_AccessionToName(result1[,2],targetVersion = "v21")
result2[c(341:345),]

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
miRNANames=miRNATest$miRNA_Name
result1=miRNA_MatureToPrecursor(miRNANames)
head(result1)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
miRNANames=c("pma-mir-100a","sko-mir-92a","hsa-mir-6131","mtr-MIR2655i",
"mmu-mir-153","mtr-MIR2592am","mml-mir-1239","xtr-mir-128-2","oan-mir-100",
"mmu-mir-378b","hsa-miR-508-5p","mmu-miR-434-3p")
result2=miRNA_PrecursorToMature(miRNANames)
head(result2)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
## The input is miRNA Accessions
Accessions=miRNATest$Accession
Family_Info1=checkMiRNAFamliy(Accessions)
head(Family_Info1)

##The input is miRNA names
miRNANames=miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames,verbose = FALSE)
result=miRNA_NameToAccession(miRNANames,version=version)
Accessions=result$Accession
Family_Info2=checkMiRNAFamliy(Accessions)
head(Family_Info2)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
data(miRNATest)
Accessions = miRNATest$Accession
result1 = getMiRNASequence(Accessions,targetVersion = "v13")
head(result1)

result2 = getMiRNASequence(Accessions,targetVersion = "v21")
head(result2)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
getAllVersionInfo()

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
allSpecies=getAllSpecies()
head(allSpecies)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
miRNAs=getAllMiRNAs(version="v21", type="all", species="hsa")
head(miRNAs)

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#### 1. The input is a miRNA Name
name = "hsa-miR-26b-5p"
result1 = miRNA_NameToAccession(name)
Accession = result1$Accession
result2 = getMiRNAHistory(Accession)
result2

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#### 2. The input is miRNA Accession Id
Accession = "MIMAT0000765"
result3 = getMiRNAHistory(Accession)
result3

## ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(miRBaseConverter)
miRNA_Tab=getMiRNATable(version="v21",species="hsa")
head(miRNA_Tab)

## ----eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(miRBaseConverter)
#  Accessions=miRNATest$Accession[1:10]
#  goTo_miRBase(Accessions)

## ----eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(miRBaseConverter)
#  Accessions=miRNATest$Accession
#  Family_Info=checkMiRNAFamliy(Accessions)
#  FamilyAccessions=Family_Info$FamilyAccession[1:15]
#  goTo_miRNAFamily(FamilyAccessions)

