/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable,
Cloneable,
OWLReasonerConfiguration {
    private static final long serialVersionUID = 7741510316249774519L;
    public WarningMonitor warningMonitor = null;
    public ReasonerProgressMonitor reasonerProgressMonitor = null;
    public TableauMonitorType tableauMonitorType = TableauMonitorType.NONE;
    public DirectBlockingType directBlockingType = DirectBlockingType.OPTIMAL;
    public BlockingStrategyType blockingStrategyType = BlockingStrategyType.OPTIMAL;
    public BlockingSignatureCacheType blockingSignatureCacheType = BlockingSignatureCacheType.CACHED;
    public ExistentialStrategyType existentialStrategyType = ExistentialStrategyType.OPTIMAL;
    public boolean checkClauses = true;
    public boolean ignoreUnsupportedDatatypes = false;
    public TableauMonitor monitor = null;
    public Map<String, Object> parameters = new HashMap<String, Object>();
    public long individualTaskTimeout = -1L;
    public IndividualNodeSetPolicy individualNodeSetPolicy = IndividualNodeSetPolicy.BY_NAME;
    public FreshEntityPolicy freshEntityPolicy = FreshEntityPolicy.ALLOW;
    public boolean useDisjunctionLearning = true;
    public boolean bufferChanges = true;
    public boolean throwInconsistentOntologyException = true;
    public PrepareReasonerInferences prepareReasonerInferences = null;
    public boolean forceQuasiOrderClassification = false;

    protected void setIndividualReuseStrategyReuseAlways(Set<? extends AtomicConcept> set) {
        this.parameters.put("IndividualReuseStrategy.reuseAlways", set);
    }

    public void loadIndividualReuseStrategyReuseAlways(File file) throws IOException {
        Set<AtomicConcept> set = this.loadConceptsFromFile(file);
        this.setIndividualReuseStrategyReuseAlways(set);
    }

    protected void setIndividualReuseStrategyReuseNever(Set<? extends AtomicConcept> set) {
        this.parameters.put("IndividualReuseStrategy.reuseNever", set);
    }

    public void loadIndividualReuseStrategyReuseNever(File file) throws IOException {
        Set<AtomicConcept> set = this.loadConceptsFromFile(file);
        this.setIndividualReuseStrategyReuseNever(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<AtomicConcept> loadConceptsFromFile(File file) throws IOException {
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                hashSet.add(AtomicConcept.create(string));
                string = bufferedReader.readLine();
            }
            HashSet<AtomicConcept> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public Configuration clone() {
        try {
            Configuration configuration = (Configuration)super.clone();
            configuration.parameters = new HashMap<String, Object>(this.parameters);
            return configuration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public long getTimeOut() {
        return this.individualTaskTimeout;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    @Override
    public ReasonerProgressMonitor getProgressMonitor() {
        return this.reasonerProgressMonitor;
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.freshEntityPolicy;
    }

    public static class PrepareReasonerInferences {
        public boolean classClassificationRequired = true;
        public boolean objectPropertyClassificationRequired = true;
        public boolean dataPropertyClassificationRequired = true;
        public boolean objectPropertyDomainsRequired = true;
        public boolean objectPropertyRangesRequired = true;
        public boolean realisationRequired = true;
        public boolean objectPropertyRealisationRequired = true;
        public boolean dataPropertyRealisationRequired = true;
        public boolean sameAs = true;
    }

    public static interface WarningMonitor {
        public void warning(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExistentialStrategyType {
        CREATION_ORDER,
        INDIVIDUAL_REUSE,
        EL,
        OPTIMAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockingSignatureCacheType {
        CACHED,
        NOT_CACHED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockingStrategyType {
        ANYWHERE,
        ANCESTOR,
        COMPLEX_CORE,
        SIMPLE_CORE,
        OPTIMAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectBlockingType {
        SINGLE,
        PAIR_WISE,
        OPTIMAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableauMonitorType {
        NONE,
        TIMING,
        TIMING_WITH_PAUSE,
        DEBUGGER_NO_HISTORY,
        DEBUGGER_HISTORY_ON;

    }
}

