/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.datetime;

import java.util.Collection;
import org.semanticweb.HermiT.datatypes.datetime.BoundType;
import org.semanticweb.HermiT.datatypes.datetime.DateTime;
import org.semanticweb.HermiT.datatypes.datetime.IntervalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeInterval {
    protected final IntervalType m_intervalType;
    protected final long m_lowerBound;
    protected final BoundType m_lowerBoundType;
    protected final long m_upperBound;
    protected final BoundType m_upperBoundType;

    public DateTimeInterval(IntervalType intervalType, long l, BoundType boundType, long l2, BoundType boundType2) {
        assert (!DateTimeInterval.isIntervalEmpty(intervalType, l, boundType, l2, boundType2));
        this.m_intervalType = intervalType;
        this.m_lowerBound = l;
        this.m_lowerBoundType = boundType;
        this.m_upperBound = l2;
        this.m_upperBoundType = boundType2;
    }

    public DateTimeInterval intersectWith(DateTimeInterval dateTimeInterval) {
        BoundType boundType;
        long l;
        BoundType boundType2;
        long l2;
        if (this.m_intervalType != dateTimeInterval.m_intervalType) {
            return null;
        }
        if (this.m_lowerBound < dateTimeInterval.m_lowerBound) {
            l2 = dateTimeInterval.m_lowerBound;
            boundType2 = dateTimeInterval.m_lowerBoundType;
        } else if (this.m_lowerBound > dateTimeInterval.m_lowerBound) {
            l2 = this.m_lowerBound;
            boundType2 = this.m_lowerBoundType;
        } else {
            l2 = this.m_lowerBound;
            boundType2 = BoundType.getMoreRestrictive(this.m_lowerBoundType, dateTimeInterval.m_lowerBoundType);
        }
        if (this.m_upperBound < dateTimeInterval.m_upperBound) {
            l = this.m_upperBound;
            boundType = this.m_upperBoundType;
        } else if (this.m_upperBound > dateTimeInterval.m_upperBound) {
            l = dateTimeInterval.m_upperBound;
            boundType = dateTimeInterval.m_upperBoundType;
        } else {
            l = this.m_upperBound;
            boundType = BoundType.getMoreRestrictive(this.m_upperBoundType, dateTimeInterval.m_upperBoundType);
        }
        if (DateTimeInterval.isIntervalEmpty(this.m_intervalType, l2, boundType2, l, boundType)) {
            return null;
        }
        if (this.isEqual(this.m_intervalType, l2, boundType2, l, boundType)) {
            return this;
        }
        if (dateTimeInterval.isEqual(this.m_intervalType, l2, boundType2, l, boundType)) {
            return dateTimeInterval;
        }
        return new DateTimeInterval(this.m_intervalType, l2, boundType2, l, boundType);
    }

    protected boolean isEqual(IntervalType intervalType, long l, BoundType boundType, long l2, BoundType boundType2) {
        return this.m_intervalType == intervalType && this.m_lowerBound == l && this.m_lowerBoundType == boundType && this.m_upperBound == l2 && this.m_upperBoundType == boundType2;
    }

    public int subtractSizeFrom(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.m_lowerBound < this.m_upperBound) {
            return 0;
        }
        assert (this.m_lowerBoundType == BoundType.INCLUSIVE);
        assert (this.m_upperBoundType == BoundType.INCLUSIVE);
        if (this.m_intervalType == IntervalType.WITHOUT_TIMEZONE) {
            int n2 = 1;
            if (DateTime.isLastDayInstant(this.m_lowerBound)) {
                ++n2;
            }
            return Math.max(0, n - n2);
        }
        int n3 = 1681;
        if (DateTime.secondsAreZero(this.m_lowerBound)) {
            if (this.m_lowerBound >= 0L) {
                int n4 = DateTime.getMinutesInDay(this.m_lowerBound);
                assert (n4 < 1440);
                if (0 <= n4 && n4 <= 840) {
                    ++n3;
                }
                if (600 <= n4) {
                    ++n3;
                }
            } else {
                int n5 = DateTime.getMinutesInDay(this.m_lowerBound);
                assert (-1440 < n5);
                if (-840 <= n5 && n5 <= 0) {
                    ++n3;
                }
                if (n5 <= -600) {
                    ++n3;
                }
            }
        }
        return Math.max(0, n - n3);
    }

    public boolean containsDateTime(DateTime dateTime) {
        if (dateTime.hasTimeZoneOffset() ? this.m_intervalType == IntervalType.WITHOUT_TIMEZONE : this.m_intervalType == IntervalType.WITH_TIMEZONE) {
            return false;
        }
        long l = dateTime.getTimeOnTimeline();
        if (this.m_lowerBound > l || this.m_lowerBound == l && this.m_lowerBoundType == BoundType.EXCLUSIVE) {
            return false;
        }
        return this.m_upperBound >= l && (this.m_upperBound != l || this.m_upperBoundType != BoundType.EXCLUSIVE);
    }

    public void enumerateDateTimes(Collection<Object> collection) {
        if (this.m_lowerBound == this.m_upperBound) {
            assert (this.m_lowerBoundType == BoundType.INCLUSIVE);
            assert (this.m_upperBoundType == BoundType.INCLUSIVE);
            if (this.m_intervalType == IntervalType.WITHOUT_TIMEZONE) {
                collection.add(new DateTime(this.m_lowerBound, false, Integer.MAX_VALUE));
                if (DateTime.isLastDayInstant(this.m_lowerBound)) {
                    collection.add(new DateTime(this.m_lowerBound, true, Integer.MAX_VALUE));
                }
            } else {
                int n;
                for (n = -840; n <= 840; ++n) {
                    collection.add(new DateTime(this.m_lowerBound, false, n));
                }
                if (DateTime.secondsAreZero(this.m_lowerBound)) {
                    if (this.m_lowerBound >= 0L) {
                        n = DateTime.getMinutesInDay(this.m_lowerBound);
                        assert (n < 1440);
                        if (0 <= n && n <= 840) {
                            collection.add(new DateTime(this.m_lowerBound, true, -n));
                        }
                        if (600 <= n) {
                            collection.add(new DateTime(this.m_lowerBound, true, 1440 - n));
                        }
                    } else {
                        n = DateTime.getMinutesInDay(this.m_lowerBound);
                        assert (-1440 < n);
                        if (-840 <= n && n <= 0) {
                            collection.add(new DateTime(this.m_lowerBound, true, -1440 - n));
                        }
                        if (n <= -600) {
                            collection.add(new DateTime(this.m_lowerBound, true, -n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalStateException("The data range is infinite.");
        }
    }

    protected static boolean isIntervalEmpty(IntervalType intervalType, long l, BoundType boundType, long l2, BoundType boundType2) {
        return l > l2 || l == l2 && (boundType == BoundType.EXCLUSIVE || boundType2 == BoundType.EXCLUSIVE);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_intervalType.toString());
        if (this.m_lowerBoundType == BoundType.INCLUSIVE) {
            stringBuffer.append('[');
        } else {
            stringBuffer.append('<');
        }
        stringBuffer.append(this.m_lowerBound);
        stringBuffer.append(" .. ");
        stringBuffer.append(this.m_upperBound);
        if (this.m_upperBoundType == BoundType.INCLUSIVE) {
            stringBuffer.append(']');
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }
}

