/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.doublenum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeHandler;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.datatypes.UnsupportedFacetException;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.doublenum.DoubleInterval;
import org.semanticweb.HermiT.datatypes.doublenum.EmptyDoubleSubset;
import org.semanticweb.HermiT.datatypes.doublenum.EntireDoubleSubset;
import org.semanticweb.HermiT.datatypes.doublenum.NoNaNDoubleSubset;
import org.semanticweb.HermiT.model.DatatypeRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDatatypeHandler
implements DatatypeHandler {
    protected static final String XSD_NS = Prefixes.s_semanticWebPrefixes.get("xsd");
    protected static final String XSD_DOUBLE = XSD_NS + "double";
    protected static final ValueSpaceSubset DOUBLE_ENTIRE = new EntireDoubleSubset();
    protected static final ValueSpaceSubset EMPTY_SUBSET = new EmptyDoubleSubset();
    protected static final Set<String> s_managedDatatypeURIs = Collections.singleton(XSD_DOUBLE);
    protected static final Set<String> s_supportedFacetURIs = new HashSet<String>();

    @Override
    public Set<String> getManagedDatatypeURIs() {
        return s_managedDatatypeURIs;
    }

    @Override
    public Object parseLiteral(String string, String string2) throws MalformedLiteralException {
        assert (XSD_DOUBLE.equals(string2));
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                return Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                return Double.NEGATIVE_INFINITY;
            }
            throw new MalformedLiteralException(string, string2);
        }
    }

    @Override
    public void validateDatatypeRestriction(DatatypeRestriction datatypeRestriction) throws UnsupportedFacetException {
        assert (XSD_DOUBLE.equals(datatypeRestriction.getDatatypeURI()));
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            if (!s_supportedFacetURIs.contains(string)) {
                throw new UnsupportedFacetException("A facet with URI '" + string + "' is not supported on xsd:double. The xsd:double datatype supports only xsd:minInclusive, xsd:maxInclusive, xsd:minExclusive, and xsd:maxExclusive, but the ontology contains a datatype restriction " + this.toString());
            }
            Object object = datatypeRestriction.getFacetValue(i).getDataValue();
            if (object instanceof Double) continue;
            throw new UnsupportedFacetException("The '" + string + "' facet takes only doubles as values when used on an xsd:double datatype, but the ontology contains a datatype restriction " + this.toString());
        }
    }

    @Override
    public ValueSpaceSubset createValueSpaceSubset(DatatypeRestriction datatypeRestriction) {
        assert (XSD_DOUBLE.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0) {
            return DOUBLE_ENTIRE;
        }
        DoubleInterval doubleInterval = this.getIntervalFor(datatypeRestriction);
        if (doubleInterval == null) {
            return EMPTY_SUBSET;
        }
        return new NoNaNDoubleSubset(doubleInterval);
    }

    @Override
    public ValueSpaceSubset conjoinWithDR(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_DOUBLE.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY_SUBSET) {
            return valueSpaceSubset;
        }
        DoubleInterval doubleInterval = this.getIntervalFor(datatypeRestriction);
        if (doubleInterval == null) {
            return EMPTY_SUBSET;
        }
        if (valueSpaceSubset == DOUBLE_ENTIRE) {
            return new NoNaNDoubleSubset(doubleInterval);
        }
        NoNaNDoubleSubset noNaNDoubleSubset = (NoNaNDoubleSubset)valueSpaceSubset;
        List<DoubleInterval> list = noNaNDoubleSubset.m_intervals;
        ArrayList<DoubleInterval> arrayList = new ArrayList<DoubleInterval>();
        for (int i = 0; i < list.size(); ++i) {
            DoubleInterval doubleInterval2 = list.get(i);
            DoubleInterval doubleInterval3 = doubleInterval2.intersectWith(doubleInterval);
            if (doubleInterval3 == null) continue;
            arrayList.add(doubleInterval3);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new NoNaNDoubleSubset(arrayList);
    }

    @Override
    public ValueSpaceSubset conjoinWithDRNegation(ValueSpaceSubset valueSpaceSubset, DatatypeRestriction datatypeRestriction) {
        assert (XSD_DOUBLE.equals(datatypeRestriction.getDatatypeURI()));
        if (datatypeRestriction.getNumberOfFacetRestrictions() == 0 || valueSpaceSubset == EMPTY_SUBSET) {
            return EMPTY_SUBSET;
        }
        DoubleInterval doubleInterval = this.getIntervalFor(datatypeRestriction);
        if (doubleInterval == null) {
            return valueSpaceSubset;
        }
        if (valueSpaceSubset == DOUBLE_ENTIRE) {
            ArrayList<DoubleInterval> arrayList = new ArrayList<DoubleInterval>();
            if (!DoubleInterval.areIdentical(doubleInterval.m_lowerBoundInclusive, Double.NEGATIVE_INFINITY)) {
                arrayList.add(new DoubleInterval(Double.NEGATIVE_INFINITY, DoubleInterval.previousDouble(doubleInterval.m_lowerBoundInclusive)));
            }
            if (!DoubleInterval.areIdentical(doubleInterval.m_upperBoundInclusive, Double.POSITIVE_INFINITY)) {
                arrayList.add(new DoubleInterval(DoubleInterval.nextDouble(doubleInterval.m_upperBoundInclusive), Double.POSITIVE_INFINITY));
            }
            if (arrayList.isEmpty()) {
                return EMPTY_SUBSET;
            }
            return new NoNaNDoubleSubset(arrayList);
        }
        NoNaNDoubleSubset noNaNDoubleSubset = (NoNaNDoubleSubset)valueSpaceSubset;
        DoubleInterval doubleInterval2 = null;
        if (!DoubleInterval.areIdentical(doubleInterval.m_lowerBoundInclusive, Double.NEGATIVE_INFINITY)) {
            doubleInterval2 = new DoubleInterval(Double.NEGATIVE_INFINITY, DoubleInterval.previousDouble(doubleInterval.m_lowerBoundInclusive));
        }
        DoubleInterval doubleInterval3 = null;
        if (!DoubleInterval.areIdentical(doubleInterval.m_upperBoundInclusive, Double.POSITIVE_INFINITY)) {
            doubleInterval3 = new DoubleInterval(DoubleInterval.nextDouble(doubleInterval.m_upperBoundInclusive), Double.POSITIVE_INFINITY);
        }
        List<DoubleInterval> list = noNaNDoubleSubset.m_intervals;
        ArrayList<DoubleInterval> arrayList = new ArrayList<DoubleInterval>();
        for (int i = 0; i < list.size(); ++i) {
            DoubleInterval doubleInterval4;
            DoubleInterval doubleInterval5 = list.get(i);
            if (doubleInterval2 != null && (doubleInterval4 = doubleInterval5.intersectWith(doubleInterval2)) != null) {
                arrayList.add(doubleInterval4);
            }
            if (doubleInterval3 == null || (doubleInterval4 = doubleInterval5.intersectWith(doubleInterval3)) == null) continue;
            arrayList.add(doubleInterval4);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_SUBSET;
        }
        return new NoNaNDoubleSubset(arrayList);
    }

    protected DoubleInterval getIntervalFor(DatatypeRestriction datatypeRestriction) {
        assert (datatypeRestriction.getNumberOfFacetRestrictions() != 0);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = datatypeRestriction.getNumberOfFacetRestrictions() - 1; i >= 0; --i) {
            String string = datatypeRestriction.getFacetURI(i);
            double d3 = (Double)datatypeRestriction.getFacetValue(i).getDataValue();
            if ((XSD_NS + "minInclusive").equals(string)) {
                if (DoubleInterval.areIdentical(d3, 0.0)) {
                    d3 = -0.0;
                }
                if (!DoubleInterval.isSmallerEqual(d, d3)) continue;
                d = d3;
                continue;
            }
            if ((XSD_NS + "minExclusive").equals(string)) {
                if (DoubleInterval.areIdentical(d3, -0.0)) {
                    d3 = 0.0;
                }
                if (!DoubleInterval.isSmallerEqual(d, d3 = DoubleInterval.nextDouble(d3))) continue;
                d = d3;
                continue;
            }
            if ((XSD_NS + "maxInclusive").equals(string)) {
                if (DoubleInterval.areIdentical(d3, -0.0)) {
                    d3 = 0.0;
                }
                if (!DoubleInterval.isSmallerEqual(d3, d2)) continue;
                d2 = d3;
                continue;
            }
            if ((XSD_NS + "maxExclusive").equals(string)) {
                if (DoubleInterval.areIdentical(d3, 0.0)) {
                    d3 = -0.0;
                }
                if (!DoubleInterval.isSmallerEqual(d3 = DoubleInterval.previousDouble(d3), d2)) continue;
                d2 = d3;
                continue;
            }
            throw new IllegalStateException("Internal error: facet '" + string + "' is not supported by xsd:double.");
        }
        if (DoubleInterval.isIntervalEmpty(d, d2)) {
            return null;
        }
        return new DoubleInterval(d, d2);
    }

    @Override
    public boolean isSubsetOf(String string, String string2) {
        assert (XSD_DOUBLE.equals(string));
        assert (XSD_DOUBLE.equals(string2));
        return true;
    }

    @Override
    public boolean isDisjointWith(String string, String string2) {
        assert (XSD_DOUBLE.equals(string));
        assert (XSD_DOUBLE.equals(string2));
        return false;
    }

    static {
        s_supportedFacetURIs.add(XSD_NS + "minInclusive");
        s_supportedFacetURIs.add(XSD_NS + "minExclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxInclusive");
        s_supportedFacetURIs.add(XSD_NS + "maxExclusive");
    }
}

