/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.tableau.GroundDisjunction;

public class UnprocessedDisjunctionsCommand
extends AbstractCommand {
    public UnprocessedDisjunctionsCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "uDisjunctions";
    }

    public String[] getDescription() {
        return new String[]{"", "shows unprocessed ground disjunctions"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: uDisjunctions");
        printWriter.println("    Prints a list of unprocessed ground disjunctions.");
    }

    public void execute(String[] stringArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println("Unprocessed ground disjunctions");
        printWriter.println("===========================================");
        for (GroundDisjunction groundDisjunction = this.m_debugger.getTableau().getFirstUnprocessedGroundDisjunction(); groundDisjunction != null; groundDisjunction = groundDisjunction.getPreviousGroundDisjunction()) {
            for (int i = 0; i < groundDisjunction.getNumberOfDisjuncts(); ++i) {
                DLPredicate dLPredicate;
                if (i != 0) {
                    printWriter.print(" v ");
                }
                if (Equality.INSTANCE.equals(dLPredicate = groundDisjunction.getDLPredicate(i))) {
                    printWriter.print(groundDisjunction.getArgument(i, 0).getNodeID());
                    printWriter.print(" == ");
                    printWriter.print(groundDisjunction.getArgument(i, 1).getNodeID());
                    continue;
                }
                printWriter.print(dLPredicate.toString(this.m_debugger.getPrefixes()));
                printWriter.print('(');
                for (int j = 0; j < dLPredicate.getArity(); ++j) {
                    if (j != 0) {
                        charArrayWriter.append(',');
                    }
                    printWriter.print(groundDisjunction.getArgument(i, j).getNodeID());
                }
                printWriter.print(')');
            }
            printWriter.println();
        }
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "Unprocessed ground disjunctions");
        this.selectConsoleWindow();
    }
}

