/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.debugger.commands.DebuggerCommand;

public class WaitForCommand
extends AbstractCommand
implements DebuggerCommand {
    public WaitForCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "waitFor";
    }

    public String[] getDescription() {
        return new String[]{"([+|-]gexists|exists|clash|merge|dtcheck|blvalstart|blvalfinish)+", "sets (+ default) or removes (-) breakpoint options"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: waitFor ([+|-]gexists|exists|clash|merge)+");
        printWriter.println("    Sets (+ default) or removes (-) breakpoint options for the debugger.");
        printWriter.println("    Possible options are:");
        printWriter.println("        gexists     - stop at the next description graph expansion");
        printWriter.println("        exists      - stop at the next existential expansion");
        printWriter.println("        clash       - stop at the next clash");
        printWriter.println("        merge       - stop at the next merging of nodes");
        printWriter.println("        dtcheck     - stop before datatype satisfaction checking");
        printWriter.println("        blvalstart  - stop before blocking validation");
        printWriter.println("        blvalfinish - stop after blocking validation");
        printWriter.println("    Example: waitFor -clash +gexists");
    }

    public void execute(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Debugger.WaitOption waitOption = null;
            boolean bl = true;
            if (string.startsWith("-")) {
                bl = false;
                string = string.substring(1);
            } else if (string.startsWith("+")) {
                string = string.substring(1);
            }
            if ("gexists".equals(string)) {
                waitOption = Debugger.WaitOption.GRAPH_EXPANSION;
            } else if ("exists".equals(string)) {
                waitOption = Debugger.WaitOption.EXISTENTIAL_EXPANSION;
            } else if ("clash".equals(string)) {
                waitOption = Debugger.WaitOption.CLASH;
            } else if ("merge".equals(string)) {
                waitOption = Debugger.WaitOption.MERGE;
            } else if ("dtcheck".equals(string)) {
                waitOption = Debugger.WaitOption.DATATYPE_CHECKING;
            } else if ("blvalstart".equals(string)) {
                waitOption = Debugger.WaitOption.BLOCKING_VALIDATION_STARTED;
            } else if ("blvalfinish".equals(string)) {
                waitOption = Debugger.WaitOption.BLOCKING_VALIDATION_FINISHED;
            } else {
                this.m_debugger.getOutput().println("Invalid wait option '" + string + "'.");
                return;
            }
            if (waitOption == null) continue;
            this.modifyWaitOptions(waitOption, bl);
            this.m_debugger.getOutput().println("Will " + (bl ? "" : "not ") + "wait for " + (Object)((Object)waitOption) + ".");
        }
    }

    protected void modifyWaitOptions(Debugger.WaitOption waitOption, boolean bl) {
        if (bl) {
            this.m_debugger.addWaitOption(waitOption);
        } else {
            this.m_debugger.removeWaitOption(waitOption);
        }
    }
}

