/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.ToDFA;
import rationals.transformations.TransformationsToolBox;
import rationals.transformations.UnaryTransformation;

public class Reducer
implements UnaryTransformation {
    private boolean same(State e1, State e2, Automaton a, Map m) {
        if (!m.get(e1).equals(m.get(e2))) {
            return false;
        }
        Set tas = a.delta(e1);
        Set tbs = a.delta(e2);
        Iterator it = tas.iterator();
        while (it.hasNext()) {
            Transition tr = (Transition)it.next();
            State ep1 = tr.end();
            Set tbsl = a.delta(e2, tr.label());
            if (tbsl.isEmpty()) {
                return false;
            }
            Iterator trb = tbsl.iterator();
            while (trb.hasNext()) {
                Transition tb = (Transition)trb.next();
                tbs.remove(tb);
                State ep2 = tb.end();
                if (m.get(ep1).equals(m.get(ep2))) continue;
                return false;
            }
        }
        return tbs.isEmpty();
    }

    public Automaton transform(Automaton a) {
        Set set;
        HashMap<State, Set> old;
        Automaton b = new ToDFA().transform(a);
        HashMap<State, Set> current = new HashMap<State, Set>();
        Set s1 = b.getStateFactory().stateSet();
        Set s2 = b.getStateFactory().stateSet();
        Iterator<Object> i = b.states().iterator();
        while (i.hasNext()) {
            State e = (State)i.next();
            if (e.isTerminal()) {
                s1.add(e);
                current.put(e, s1);
                continue;
            }
            s2.add(e);
            current.put(e, s2);
        }
        do {
            old = current;
            current = new HashMap();
            i = old.keySet().iterator();
            while (i.hasNext()) {
                State e1 = (State)i.next();
                Set s = b.getStateFactory().stateSet();
                Iterator j = current.keySet().iterator();
                while (j.hasNext()) {
                    State e2 = (State)j.next();
                    if (!this.same(e1, e2, b, old)) continue;
                    s = (Set)current.get(e2);
                    break;
                }
                s.add(e1);
                current.put(e1, s);
            }
        } while (!new HashSet(current.values()).equals(new HashSet(old.values())));
        Automaton c = new Automaton();
        HashSet setSet = new HashSet(current.values());
        Iterator sets = setSet.iterator();
        HashMap<Set, State> newStates = new HashMap<Set, State>();
        while (sets.hasNext()) {
            set = (Set)sets.next();
            boolean term = TransformationsToolBox.containsATerminalState(set);
            boolean init = TransformationsToolBox.containsAnInitialState(set);
            newStates.put(set, c.addState(init, term));
        }
        sets = setSet.iterator();
        while (sets.hasNext()) {
            set = (Set)sets.next();
            State r = (State)set.iterator().next();
            State rp = (State)newStates.get(set);
            Iterator k = b.alphabet().iterator();
            while (k.hasNext()) {
                Object l = k.next();
                Set ds = b.delta(r, l);
                if (ds.isEmpty()) continue;
                State f = ((Transition)ds.iterator().next()).end();
                State fp = (State)newStates.get(current.get(f));
                try {
                    c.addTransition(new Transition(rp, l, fp));
                }
                catch (NoSuchStateException x) {}
            }
        }
        return c;
    }
}

