/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owlapi.krssrenderer;

import de.uulm.ecs.ai.owlapi.krssrenderer.KRSS2Vocabulary;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRSS2OWLObjectRenderer
implements OWLObjectVisitor {
    private final OWLOntology ontology;
    private final Writer writer;

    public KRSS2OWLObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = writer;
    }

    private void writeOpenBracket() {
        try {
            this.writer.write("(");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeCloseBracket() {
        try {
            this.writer.write(")");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(int i) {
        try {
            this.writer.write(" " + i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(IRI iri) {
        try {
            this.writer.write(iri.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeAttribute(KRSS2Vocabulary v) {
        try {
            this.writeSpace();
            this.writer.write(":");
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(KRSS2Vocabulary v) {
        try {
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeSpace() {
        try {
            this.writer.write(" ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeln() {
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void write(OWLClassExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    public final void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept(this);
    }

    public final void write(OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    public final void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept(this);
    }

    private final void flatten(Set<OWLClassExpression> classExpressions) {
        if (classExpressions.isEmpty()) {
            return;
        }
        OWLClassExpression desc = classExpressions.iterator().next();
        if (classExpressions.size() == 1) {
            this.write(desc);
            return;
        }
        classExpressions.remove(desc);
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        this.write(desc);
        this.flatten(classExpressions);
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLOntology ontology) {
        for (OWLClass eachClass : ontology.getClassesInSignature()) {
            boolean primitive;
            boolean bl = primitive = !eachClass.isDefined(ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                Set<OWLClassExpression> superClasses = eachClass.getSuperClasses(ontology);
                if (superClasses.size() == 1) {
                    this.write(superClasses.iterator().next());
                } else {
                    this.flatten(superClasses);
                }
                this.writeCloseBracket();
                this.writeln();
                for (OWLClassExpression classExpression : eachClass.getEquivalentClasses(ontology)) {
                    this.writeOpenBracket();
                    this.write(eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.writeSpace();
                    classExpression.accept(this);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            Set<OWLClassExpression> equivalentClasses = eachClass.getEquivalentClasses(ontology);
            if (equivalentClasses.isEmpty()) {
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            if (equivalentClasses.size() == 1) {
                this.write(equivalentClasses.iterator().next());
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            Iterator<OWLClassExpression> iter = equivalentClasses.iterator();
            this.write(iter.next());
            this.writeCloseBracket();
            this.writeln();
            while (iter.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write(eachClass);
                this.writeSpace();
                iter.next().accept(this);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLClassAxiom axiom : ontology.getGeneralClassAxioms()) {
            axiom.accept(this);
        }
        for (OWLObjectProperty property : ontology.getObjectPropertiesInSignature()) {
            Set superProperties;
            Set<OWLClassExpression> ranges;
            Set<OWLClassExpression> domains;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
            this.write(property);
            if (property.isTransitive(ontology)) {
                this.writeAttribute(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (property.isSymmetric(ontology)) {
                this.writeAttribute(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(domains = property.getDomains(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.DOMAIN);
                this.flatten(domains);
            }
            if (!(ranges = property.getDomains(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(ranges);
            }
            if (!(superProperties = property.getSuperProperties(ontology)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.PARENTS_ATTR);
                this.writeOpenBracket();
                for (OWLObjectPropertyExpression express : superProperties) {
                    this.write(express);
                }
                this.writeCloseBracket();
            }
            this.writeCloseBracket();
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    @Override
    public final void visit(OWLSubClassOfAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.IMPLIES);
        this.write(axiom.getSubClass());
        this.write(axiom.getSuperClass());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public final void visit(OWLDisjointClassesAxiom axiom) {
        this.writeOpenBracket();
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            this.write(desc);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
    }

    @Override
    public final void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLIndividual)axiom.getObject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.writeln();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    @Override
    public final void visit(OWLClassAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeln();
    }

    @Override
    public void visit(OWLLiteral node) {
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(SWRLClassAtom node) {
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
    }

    @Override
    public void visit(SWRLVariable node) {
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
    }

    @Override
    public final void visit(OWLClass desc) {
        this.write(desc.getIRI());
    }

    @Override
    public final void visit(OWLObjectIntersectionOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        for (OWLClassExpression des : desc.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectUnionOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.OR);
        for (OWLClassExpression des : desc.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectComplementOf desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.NOT);
        this.write(desc.getOperand());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectSomeValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLClassExpression)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectAllValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLClassExpression)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
    }

    @Override
    public final void visit(OWLObjectMinCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectExactCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLObjectMaxCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
    }

    @Override
    public final void visit(OWLDataSomeValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataAllValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write((OWLPropertyExpression)desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataHasValue desc) {
    }

    @Override
    public final void visit(OWLDataMinCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataExactCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataMaxCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write((OWLPropertyExpression)desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDatatype node) {
    }

    @Override
    public void visit(OWLDataComplementOf node) {
    }

    @Override
    public void visit(OWLDataOneOf node) {
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
    }

    @Override
    public void visit(OWLFacetRestriction node) {
    }

    @Override
    public final void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public final void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public final void visit(OWLDataProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public final void visit(OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    @Override
    public void visit(OWLDataUnionOf node) {
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
    }

    @Override
    public void visit(IRI iri) {
    }

    @Override
    public void visit(OWLAnnotation node) {
    }
}

