/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prefixes
implements Serializable {
    private static final long serialVersionUID = -158185482289831766L;
    protected static final String PN_CHARS_BASE = "[A-Za-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]";
    protected static final String PN_CHARS = "[A-Za-z0-9_\\u002D\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]";
    protected static final Pattern s_localNameChecker = Pattern.compile("([A-Za-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|_|[0-9])(([A-Za-z0-9_\\u002D\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]|[.])*([A-Za-z0-9_\\u002D\\u00B7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]))?");
    public static final Map<String, String> s_semanticWebPrefixes = new HashMap<String, String>();
    public static final Prefixes STANDARD_PREFIXES;
    protected final Map<String, String> m_prefixIRIsByPrefixName = new TreeMap<String, String>();
    protected final Map<String, String> m_prefixNamesByPrefixIRI = new TreeMap<String, String>();
    protected Pattern m_prefixIRIMatchingPattern;

    public Prefixes() {
        this.buildPrefixIRIMatchingPattern();
    }

    protected void buildPrefixIRIMatchingPattern() {
        ArrayList<String> arrayList = new ArrayList<String>(this.m_prefixNamesByPrefixIRI.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string2.length() - string.length();
            }
        });
        StringBuilder stringBuilder = new StringBuilder("^(");
        boolean bl = false;
        for (String string : arrayList) {
            if (bl) {
                stringBuilder.append("|(");
            } else {
                stringBuilder.append("(");
                bl = true;
            }
            stringBuilder.append(Pattern.quote(string));
            stringBuilder.append(")");
        }
        stringBuilder.append(")");
        this.m_prefixIRIMatchingPattern = bl ? Pattern.compile(stringBuilder.toString()) : null;
    }

    public String abbreviateIRI(String string) {
        String string2;
        Matcher matcher;
        if (this.m_prefixIRIMatchingPattern != null && (matcher = this.m_prefixIRIMatchingPattern.matcher(string)).find() && Prefixes.isValidLocalName(string2 = string.substring(matcher.end()))) {
            String string3 = this.m_prefixNamesByPrefixIRI.get(matcher.group(1));
            if (string3 == null || string3.length() == 0) {
                return ":" + string2;
            }
            return string3 + ":" + string2;
        }
        return "<" + string + ">";
    }

    public String expandAbbreviatedIRI(String string) {
        if (string.length() > 0 && string.charAt(0) == '<') {
            if (string.charAt(string.length() - 1) != '>') {
                throw new IllegalArgumentException("The string '" + string + "' is not a valid abbreviation: IRIs must be enclosed in '<' and '>'.");
            }
            return string.substring(1, string.length() - 1);
        }
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = this.m_prefixIRIsByPrefixName.get(string2);
            if (string3 == null) {
                if (string2 == "http") {
                    throw new IllegalArgumentException("The IRI '" + string + "' must be enclosed in '<' and '>' to be used as an abbreviation.");
                }
                throw new IllegalArgumentException("The string '" + string2 + "' is not a registered prefix name.");
            }
            return string3 + string.substring(n + 1);
        }
        throw new IllegalArgumentException("The abbreviation '" + string + "' is not valid (it does not start with a colon).");
    }

    public boolean canBeExpanded(String string) {
        if (string.length() > 0 && string.charAt(0) == '<') {
            return false;
        }
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = this.m_prefixIRIsByPrefixName.get(string2);
            return string3 != null;
        }
        return false;
    }

    public boolean declarePrefix(String string, String string2) {
        boolean bl = this.declarePrefixRaw(string, string2);
        this.buildPrefixIRIMatchingPattern();
        return bl;
    }

    protected boolean declarePrefixRaw(String string, String string2) {
        String string3 = this.m_prefixNamesByPrefixIRI.get(string2);
        if (string3 != null && !string.equals(string3)) {
            throw new IllegalArgumentException("The prefix IRI '" + string2 + "'has already been associated with the prefix name '" + string3 + "'.");
        }
        this.m_prefixNamesByPrefixIRI.put(string2, string);
        return this.m_prefixIRIsByPrefixName.put(string, string2) == null;
    }

    public boolean declareDefaultPrefix(String string) {
        return this.declarePrefix("", string);
    }

    public Map<String, String> getPrefixIRIsByPrefixName() {
        return Collections.unmodifiableMap(this.m_prefixIRIsByPrefixName);
    }

    public String getPrefixIRI(String string) {
        return this.m_prefixIRIsByPrefixName.get(string);
    }

    public String getPrefixName(String string) {
        return this.m_prefixNamesByPrefixIRI.get(string);
    }

    public boolean declareInternalPrefixes(Collection<String> collection, Collection<String> collection2) {
        boolean bl = false;
        if (this.declarePrefixRaw("def", "internal:def#")) {
            bl = true;
        }
        if (this.declarePrefixRaw("defdata", "internal:defdata#")) {
            bl = true;
        }
        if (this.declarePrefixRaw("nnq", "internal:nnq#")) {
            bl = true;
        }
        if (this.declarePrefixRaw("all", "internal:all#")) {
            bl = true;
        }
        if (this.declarePrefixRaw("swrl", "internal:swrl#")) {
            bl = true;
        }
        if (this.declarePrefixRaw("prop", "internal:prop#")) {
            bl = true;
        }
        int n = 1;
        for (String object : collection) {
            if (this.declarePrefixRaw("nom" + (n == 1 ? "" : String.valueOf(n)), "internal:nom#" + object)) {
                bl = true;
            }
            ++n;
        }
        int n2 = 1;
        for (String string : collection2) {
            if (this.declarePrefixRaw("anon" + (n2 == 1 ? "" : String.valueOf(n2)), "internal:anon#" + string)) {
                bl = true;
            }
            ++n2;
        }
        if (this.declarePrefixRaw("nam", "internal:nam#")) {
            bl = true;
        }
        this.buildPrefixIRIMatchingPattern();
        return bl;
    }

    public boolean declareSemanticWebPrefixes() {
        boolean bl = false;
        for (Map.Entry<String, String> entry : s_semanticWebPrefixes.entrySet()) {
            if (!this.declarePrefixRaw(entry.getKey(), entry.getValue())) continue;
            bl = true;
        }
        this.buildPrefixIRIMatchingPattern();
        return bl;
    }

    public boolean addPrefixes(Prefixes prefixes) {
        boolean bl = false;
        for (Map.Entry<String, String> entry : prefixes.m_prefixIRIsByPrefixName.entrySet()) {
            if (!this.declarePrefixRaw(entry.getKey(), entry.getValue())) continue;
            bl = true;
        }
        this.buildPrefixIRIMatchingPattern();
        return bl;
    }

    public static boolean isInternalIRI(String string) {
        return string.startsWith("internal:");
    }

    public static boolean isValidLocalName(String string) {
        return s_localNameChecker.matcher(string).matches();
    }

    static {
        s_semanticWebPrefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        s_semanticWebPrefixes.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        s_semanticWebPrefixes.put("owl", "http://www.w3.org/2002/07/owl#");
        s_semanticWebPrefixes.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        s_semanticWebPrefixes.put("swrl", "http://www.w3.org/2003/11/swrl#");
        s_semanticWebPrefixes.put("swrlb", "http://www.w3.org/2003/11/swrlb#");
        s_semanticWebPrefixes.put("swrlx", "http://www.w3.org/2003/11/swrlx#");
        s_semanticWebPrefixes.put("ruleml", "http://www.w3.org/2003/11/ruleml#");
        STANDARD_PREFIXES = new ImmutablePrefixes(s_semanticWebPrefixes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutablePrefixes
    extends Prefixes {
        private static final long serialVersionUID = 8517988865445255837L;

        public ImmutablePrefixes(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                super.declarePrefixRaw(entry.getKey(), entry.getValue());
            }
            this.buildPrefixIRIMatchingPattern();
        }

        @Override
        protected boolean declarePrefixRaw(String string, String string2) {
            throw new UnsupportedOperationException("The well-known standard Prefix instance cannot be modified.");
        }
    }
}

