/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.owlreal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.semanticweb.HermiT.datatypes.owlreal.BigRational;
import org.semanticweb.HermiT.datatypes.owlreal.MinusInfinity;
import org.semanticweb.HermiT.datatypes.owlreal.PlusInfinity;

public class Numbers {
    public static boolean isValidNumber(Number number) {
        return number instanceof Integer || number instanceof Long || number instanceof BigInteger || number instanceof BigDecimal || number instanceof BigRational;
    }

    public static Number parseInteger(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return new BigInteger(string);
            }
        }
    }

    public static Number parseDecimal(String string) throws NumberFormatException {
        BigDecimal bigDecimal = new BigDecimal(string);
        try {
            return bigDecimal.intValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            try {
                return bigDecimal.longValueExact();
            }
            catch (ArithmeticException arithmeticException2) {
                try {
                    return bigDecimal.toBigIntegerExact();
                }
                catch (ArithmeticException arithmeticException3) {
                    return bigDecimal.stripTrailingZeros();
                }
            }
        }
    }

    public static Number parseRational(String string) throws NumberFormatException {
        int n = string.indexOf(47);
        if (n == -1) {
            throw new NumberFormatException("The string does not contain /.");
        }
        BigInteger bigInteger = new BigInteger(string.substring(0, n));
        BigInteger bigInteger2 = new BigInteger(string.substring(n + 1));
        if (bigInteger2.compareTo(BigInteger.ZERO) <= 0) {
            throw new NumberFormatException("Invalid denumerator of the rational.");
        }
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        bigInteger = bigInteger.divide(bigInteger3);
        if ((bigInteger2 = bigInteger2.divide(bigInteger3)).equals(BigInteger.ONE)) {
            int n2 = bigInteger.bitCount();
            if (n2 <= 32) {
                return bigInteger.intValue();
            }
            if (n2 <= 64) {
                return bigInteger.longValue();
            }
            return bigInteger;
        }
        try {
            return new BigDecimal(bigInteger).divide(new BigDecimal(bigInteger2));
        }
        catch (ArithmeticException arithmeticException) {
            return new BigRational(bigInteger, bigInteger2);
        }
    }

    public static int compare(Number number, Number number2) {
        if (number.equals(number2)) {
            return 0;
        }
        if (number.equals(MinusInfinity.INSTANCE) || number2.equals(PlusInfinity.INSTANCE)) {
            return -1;
        }
        if (number.equals(PlusInfinity.INSTANCE) || number2.equals(MinusInfinity.INSTANCE)) {
            return 1;
        }
        int n = Numbers.getNumberType(number);
        int n2 = Numbers.getNumberType(number2);
        int n3 = Math.max(n, n2);
        switch (n3) {
            case 0: {
                int n4 = number.intValue();
                int n5 = number2.intValue();
                return n4 < n5 ? -1 : (n4 == n5 ? 0 : 1);
            }
            case 1: {
                long l = number.longValue();
                long l2 = number2.longValue();
                return l < l2 ? -1 : (l == l2 ? 0 : 1);
            }
            case 2: {
                BigInteger bigInteger = Numbers.toBigInteger(number, n);
                BigInteger bigInteger2 = Numbers.toBigInteger(number2, n2);
                return bigInteger.compareTo(bigInteger2);
            }
            case 3: {
                BigDecimal bigDecimal = Numbers.toBigDecimal(number, n);
                BigDecimal bigDecimal2 = Numbers.toBigDecimal(number2, n2);
                return bigDecimal.compareTo(bigDecimal2);
            }
            case 4: {
                BigRational bigRational = Numbers.toBigRational(number, n);
                BigRational bigRational2 = Numbers.toBigRational(number2, n2);
                return bigRational.compareTo(bigRational2);
            }
        }
        throw new IllegalArgumentException();
    }

    protected static int getNumberType(Number number) {
        if (number instanceof Integer) {
            return 0;
        }
        if (number instanceof Long) {
            return 1;
        }
        if (number instanceof BigInteger) {
            return 2;
        }
        if (number instanceof BigDecimal) {
            return 3;
        }
        if (number instanceof BigRational) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    protected static BigInteger toBigInteger(Number number, int n) {
        switch (n) {
            case 0: 
            case 1: {
                return BigInteger.valueOf(number.longValue());
            }
            case 2: {
                return (BigInteger)number;
            }
        }
        throw new IllegalArgumentException();
    }

    protected static BigDecimal toBigDecimal(Number number, int n) {
        switch (n) {
            case 0: 
            case 1: {
                return BigDecimal.valueOf(number.longValue());
            }
            case 2: {
                return new BigDecimal((BigInteger)number);
            }
            case 3: {
                return (BigDecimal)number;
            }
        }
        throw new IllegalArgumentException();
    }

    protected static BigRational toBigRational(Number number, int n) {
        switch (n) {
            case 0: 
            case 1: {
                return new BigRational(BigInteger.valueOf(number.longValue()), BigInteger.ONE);
            }
            case 2: {
                return new BigRational((BigInteger)number, BigInteger.ONE);
            }
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)number;
                assert (bigDecimal.scale() > 0);
                return new BigRational(bigDecimal.unscaledValue(), BigInteger.TEN.pow(bigDecimal.scale()));
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number getNearestIntegerInBound(Number number, BoundaryDirection boundaryDirection, boolean bl) {
        switch (Numbers.getNumberType(number)) {
            case 0: {
                if (bl) {
                    return number;
                }
                if (BoundaryDirection.LOWER.equals((Object)boundaryDirection)) {
                    int n = number.intValue();
                    if (n == Integer.MAX_VALUE) {
                        return (long)n + 1L;
                    }
                    return n + 1;
                }
                int n = number.intValue();
                if (n == Integer.MIN_VALUE) {
                    return (long)n - 11L;
                }
                return n - 1;
            }
            case 1: {
                if (bl) {
                    return number;
                }
                if (BoundaryDirection.LOWER.equals((Object)boundaryDirection)) {
                    long l = number.longValue();
                    if (l == Long.MAX_VALUE) {
                        return BigInteger.valueOf(l).add(BigInteger.ONE);
                    }
                    return l + 1L;
                }
                long l = number.longValue();
                if (l == Long.MIN_VALUE) {
                    return BigInteger.valueOf(l).subtract(BigInteger.ONE);
                }
                return l - 1L;
            }
            case 2: {
                if (bl) {
                    return number;
                }
                if (BoundaryDirection.LOWER.equals((Object)boundaryDirection)) {
                    return ((BigInteger)number).add(BigInteger.ONE);
                }
                return ((BigInteger)number).subtract(BigInteger.ONE);
            }
            case 3: {
                int n;
                BigDecimal bigDecimal = (BigDecimal)number;
                assert (bigDecimal.scale() > 0);
                BigInteger bigInteger = bigDecimal.toBigInteger();
                if (BoundaryDirection.LOWER.equals((Object)boundaryDirection)) {
                    if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        bigInteger = bigInteger.add(BigInteger.ONE);
                    }
                } else if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    bigInteger = bigInteger.subtract(BigInteger.ONE);
                }
                if ((n = bigInteger.bitCount()) <= 32) {
                    return bigInteger.intValue();
                }
                if (n <= 64) {
                    return bigInteger.longValue();
                }
                return bigInteger;
            }
            case 4: {
                int n;
                BigRational bigRational = (BigRational)number;
                BigDecimal bigDecimal = new BigDecimal(bigRational.getNumerator());
                BigDecimal bigDecimal2 = new BigDecimal(bigRational.getDenominator());
                BigInteger bigInteger = bigDecimal.divideToIntegralValue(bigDecimal2).toBigInteger();
                if (BoundaryDirection.LOWER.equals((Object)boundaryDirection)) {
                    if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        bigInteger = bigInteger.add(BigInteger.ONE);
                    }
                } else if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    bigInteger = bigInteger.subtract(BigInteger.ONE);
                }
                if ((n = bigInteger.bitCount()) <= 32) {
                    return bigInteger.intValue();
                }
                if (n <= 64) {
                    return bigInteger.longValue();
                }
                return bigInteger;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int subtractIntegerIntervalSizeFrom(Number number, Number number2, int n) {
        if (n <= 0) {
            return 0;
        }
        if (number.equals(number2)) {
            return n;
        }
        int n2 = Numbers.getNumberType(number);
        int n3 = Numbers.getNumberType(number2);
        int n4 = Math.max(n2, n3);
        switch (n4) {
            case 0: {
                int n5 = number2.intValue() - number.intValue() + 1;
                if (n5 <= 0) {
                    return 0;
                }
                return Math.max(n - n5, 0);
            }
            case 1: {
                long l = number2.longValue() - number.longValue() + 1L;
                if (l <= 0L) {
                    return 0;
                }
                return (int)Math.max((long)n - l, 0L);
            }
            case 2: {
                BigInteger bigInteger = BigInteger.valueOf(n).subtract(Numbers.toBigInteger(number2, n3)).add(Numbers.toBigInteger(number, n2)).subtract(BigInteger.ONE);
                if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
                    return 0;
                }
                return bigInteger.intValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public static Number nextInteger(Number number) {
        switch (Numbers.getNumberType(number)) {
            case 0: {
                int n = number.intValue();
                if (n == Integer.MAX_VALUE) {
                    return (long)n + 1L;
                }
                return n + 1;
            }
            case 1: {
                long l = number.longValue();
                if (l == Long.MAX_VALUE) {
                    return BigInteger.valueOf(l).add(BigInteger.ONE);
                }
                return l + 1L;
            }
            case 2: {
                return ((BigInteger)number).add(BigInteger.ONE);
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoundaryDirection {
        UPPER,
        LOWER;

    }
}

