/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.Printing;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.tableau.Node;

public class SubtreeViewer
extends JFrame {
    protected final Debugger m_debugger;
    protected final SubtreeTreeModel m_subtreeTreeModel;
    protected final JTextArea m_nodeInfoTextArea;
    protected final JTree m_tableauTree;
    protected final JTextField m_nodeIDField;

    public SubtreeViewer(Debugger debugger, Node node) {
        super("Subtree for node " + node.getNodeID());
        this.setDefaultCloseOperation(2);
        this.m_debugger = debugger;
        this.m_subtreeTreeModel = new SubtreeTreeModel(debugger, node);
        this.m_tableauTree = new JTree(this.m_subtreeTreeModel);
        this.m_tableauTree.setLargeModel(true);
        this.m_tableauTree.setShowsRootHandles(true);
        this.m_tableauTree.setCellRenderer(new NodeCellRenderer(debugger));
        this.m_tableauTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = SubtreeViewer.this.m_tableauTree.getSelectionPath();
                if (treePath == null) {
                    SubtreeViewer.this.showNodeLabels(null);
                } else {
                    SubtreeViewer.this.showNodeLabels((Node)treePath.getLastPathComponent());
                }
            }
        });
        this.m_nodeInfoTextArea = new JTextArea();
        this.m_nodeInfoTextArea.setFont(Debugger.s_monospacedFont);
        JScrollPane jScrollPane = new JScrollPane(this.m_tableauTree);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        JScrollPane jScrollPane2 = new JScrollPane(this.m_nodeInfoTextArea);
        jScrollPane2.setPreferredSize(new Dimension(400, 400));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.add(new JLabel("Node ID:"));
        this.m_nodeIDField = new JTextField();
        this.m_nodeIDField.setPreferredSize(new Dimension(200, this.m_nodeIDField.getPreferredSize().height));
        jPanel.add(this.m_nodeIDField);
        JButton jButton = new JButton("Search");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = SubtreeViewer.this.m_nodeIDField.getText();
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(SubtreeViewer.this, "Invalid node ID '" + string + "'.");
                    return;
                }
                Node node = SubtreeViewer.this.m_debugger.getTableau().getNode(n);
                if (node == null) {
                    JOptionPane.showMessageDialog(SubtreeViewer.this, "Node with ID " + n + " cannot be found.");
                    return;
                }
                SubtreeViewer.this.findNode(node);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SubtreeViewer.this.refresh();
            }
        });
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jSplitPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        this.setLocation(200, 200);
        this.setVisible(true);
        this.m_nodeIDField.requestFocusInWindow();
    }

    public void refresh() {
        this.m_subtreeTreeModel.refresh();
    }

    public void findNode(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node2 = node;
        while (node2 != null && node2 != this.m_subtreeTreeModel.getRoot()) {
            arrayList.add(node2);
            node2 = this.m_debugger.getNodeCreationInfo((Node)node2).m_createdByNode;
        }
        if (node2 == null) {
            JOptionPane.showMessageDialog(this, "Node with ID " + node.getNodeID() + " is not present in the shown subtree.");
            return;
        }
        MyTreePath myTreePath = new MyTreePath(null, this.m_subtreeTreeModel.getRoot());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            myTreePath = new MyTreePath(myTreePath, arrayList.get(i));
        }
        this.m_tableauTree.expandPath(myTreePath);
        this.m_tableauTree.setSelectionPath(myTreePath);
        this.m_tableauTree.scrollPathToVisible(myTreePath);
    }

    public void showNodeLabels(Node node) {
        if (node == null) {
            this.m_nodeInfoTextArea.setText("");
        } else {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter printWriter = new PrintWriter(charArrayWriter);
            Printing.printNodeData(this.m_debugger, node, printWriter);
            printWriter.flush();
            this.m_nodeInfoTextArea.setText(charArrayWriter.toString());
            this.m_nodeInfoTextArea.select(0, 0);
        }
    }

    protected static class MyTreePath
    extends TreePath {
        public MyTreePath(Object object) {
            super(object);
        }

        public MyTreePath(TreePath treePath, Object object) {
            super(treePath, object);
        }
    }

    protected static class DotIcon
    implements Icon {
        protected final Color m_color;

        public DotIcon(Color color) {
            this.m_color = color;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.m_color);
            graphics.fillOval(n + 2, n2 + 2, n + 12, n2 + 12);
            graphics.setColor(color);
        }
    }

    protected static class NodeCellRenderer
    extends DefaultTreeCellRenderer {
        protected static final Icon NOT_ACTIVE_ICON = new DotIcon(Color.LIGHT_GRAY);
        protected static final Icon BLOCKED_ICON = new DotIcon(Color.CYAN);
        protected static final Icon WITH_EXISTENTIALS_ICON = new DotIcon(Color.RED);
        protected static final Icon NI_NODE_ICON = new DotIcon(Color.BLACK);
        protected static final Icon TREE_NODE_ICON = new DotIcon(Color.GREEN);
        protected static final Icon GRAPH_NODE_ICON = new DotIcon(Color.MAGENTA);
        protected static final Icon CONCRETE_NODE_ICON = new DotIcon(Color.BLUE);
        protected final Debugger m_debugger;

        public NodeCellRenderer(Debugger debugger) {
            this.m_debugger = debugger;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Node node = (Node)object;
            StringBuffer stringBuffer = new StringBuffer();
            ExistentialConcept existentialConcept = this.m_debugger.getNodeCreationInfo((Node)node).m_createdByExistential;
            if (existentialConcept == null) {
                stringBuffer.append(node.getNodeID());
                stringBuffer.append(":(root)");
            } else if (existentialConcept instanceof AtLeastConcept) {
                AtLeastConcept atLeastConcept = (AtLeastConcept)existentialConcept;
                stringBuffer.append(atLeastConcept.getOnRole().toString(this.m_debugger.getPrefixes()));
                stringBuffer.append("  -->  ");
                stringBuffer.append(node.getNodeID());
                stringBuffer.append(":[");
                stringBuffer.append(atLeastConcept.getToConcept().toString(this.m_debugger.getPrefixes()));
                stringBuffer.append("]");
            }
            super.getTreeCellRendererComponent(jTree, stringBuffer.toString(), bl, bl2, bl3, n, bl4);
            if (!node.isActive()) {
                this.setIcon(NOT_ACTIVE_ICON);
            } else if (node.isBlocked()) {
                this.setIcon(BLOCKED_ICON);
            } else if (node.hasUnprocessedExistentials()) {
                this.setIcon(WITH_EXISTENTIALS_ICON);
            } else {
                switch (node.getNodeType()) {
                    case TREE_NODE: {
                        this.setIcon(TREE_NODE_ICON);
                        break;
                    }
                    case GRAPH_NODE: {
                        this.setIcon(GRAPH_NODE_ICON);
                        break;
                    }
                    case NI_NODE: {
                        this.setIcon(NI_NODE_ICON);
                        break;
                    }
                    default: {
                        this.setIcon(CONCRETE_NODE_ICON);
                    }
                }
            }
            return this;
        }
    }

    protected static class SubtreeTreeModel
    implements TreeModel {
        protected final EventListenerList m_eventListeners = new EventListenerList();
        protected final Debugger m_debugger;
        protected final Node m_root;

        public SubtreeTreeModel(Debugger debugger, Node node) {
            this.m_debugger = debugger;
            this.m_root = node;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.m_eventListeners.add(TreeModelListener.class, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.m_eventListeners.remove(TreeModelListener.class, treeModelListener);
        }

        public Node getChild(Object object, int n) {
            Debugger.NodeCreationInfo nodeCreationInfo = null;
            if (object instanceof Node) {
                nodeCreationInfo = this.m_debugger.getNodeCreationInfo((Node)object);
            }
            if (nodeCreationInfo == null) {
                return null;
            }
            return nodeCreationInfo.m_children.get(n);
        }

        public int getChildCount(Object object) {
            Debugger.NodeCreationInfo nodeCreationInfo = null;
            if (object instanceof Node) {
                nodeCreationInfo = this.m_debugger.getNodeCreationInfo((Node)object);
            }
            if (nodeCreationInfo == null) {
                return 0;
            }
            return nodeCreationInfo.m_children.size();
        }

        public int getIndexOfChild(Object object, Object object2) {
            Debugger.NodeCreationInfo nodeCreationInfo = null;
            if (object instanceof Node) {
                nodeCreationInfo = this.m_debugger.getNodeCreationInfo((Node)object);
            }
            if (nodeCreationInfo == null) {
                return -1;
            }
            return nodeCreationInfo.m_children.indexOf(object2);
        }

        public Object getRoot() {
            return this.m_root;
        }

        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void refresh() {
            Object[] objectArray = this.m_eventListeners.getListenerList();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
            for (Object object : objectArray) {
                if (!(object instanceof TreeModelListener)) continue;
                ((TreeModelListener)object).treeStructureChanged(treeModelEvent);
            }
        }
    }
}

