/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
implements Serializable {
    private static final long serialVersionUID = 5372948202031042380L;
    protected final Set<T> m_elements = new HashSet<T>();
    protected final Map<T, Set<T>> m_successorsByNodes = new HashMap<T, Set<T>>();

    public void addEdge(T t, T t2) {
        Set<T> set = this.m_successorsByNodes.get(t);
        if (set == null) {
            set = new HashSet<T>();
            this.m_successorsByNodes.put(t, set);
        }
        set.add(t2);
        this.m_elements.add(t);
        this.m_elements.add(t2);
    }

    public void addEdges(T t, Set<T> set) {
        Set<T> set2 = this.m_successorsByNodes.get(t);
        if (set2 == null) {
            set2 = new HashSet<T>();
            this.m_successorsByNodes.put(t, set2);
        }
        set2.addAll(set);
        this.m_elements.add(t);
        this.m_elements.addAll(set);
    }

    public Set<T> getElements() {
        return this.m_elements;
    }

    public Set<T> getSuccessors(T t) {
        Set<T> set = this.m_successorsByNodes.get(t);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public void transitivelyClose() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Set<T> set : this.m_successorsByNodes.values()) {
            arrayList.clear();
            arrayList.addAll(set);
            while (!arrayList.isEmpty()) {
                Object e = arrayList.remove(arrayList.size() - 1);
                Set<T> set2 = this.m_successorsByNodes.get(e);
                if (set2 == null) continue;
                for (T t : set2) {
                    if (!set.add(t)) continue;
                    arrayList.add(t);
                }
            }
        }
    }

    public Graph<T> getInverse() {
        Graph<T> graph = new Graph<T>();
        for (Map.Entry<T, Set<T>> entry : this.m_successorsByNodes.entrySet()) {
            T t = entry.getKey();
            for (T t2 : entry.getValue()) {
                graph.addEdge(t2, t);
            }
        }
        return graph;
    }

    public Graph<T> clone() {
        Graph<T> graph = new Graph<T>();
        graph.m_elements.addAll(this.m_elements);
        for (Map.Entry<T, Set<T>> entry : this.m_successorsByNodes.entrySet()) {
            T t = entry.getKey();
            for (T t2 : entry.getValue()) {
                graph.addEdge(t, t2);
            }
        }
        return graph;
    }

    public void removeElements(Set<T> set) {
        for (T t : set) {
            this.m_elements.remove(t);
            this.m_successorsByNodes.remove(t);
        }
    }

    public boolean isReachableSuccessor(T t, T t2) {
        if (t.equals(t2)) {
            return true;
        }
        HashSet hashSet = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(t);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.poll();
            Set set = this.getSuccessors(e);
            if (set.contains(t2)) {
                return true;
            }
            if (!hashSet.add(e)) continue;
            linkedList.addAll(set);
        }
        return false;
    }

    public Set<T> getReachableSuccessors(T t) {
        HashSet hashSet = new HashSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(t);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.poll();
            if (!hashSet.add(e)) continue;
            linkedList.addAll(this.getSuccessors(e));
        }
        return hashSet;
    }
}

