/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityType<E extends OWLEntity> {
    public static final EntityType<OWLClass> CLASS = new EntityType("Class", OWLRDFVocabulary.OWL_CLASS);
    public static final EntityType<OWLObjectProperty> OBJECT_PROPERTY = new EntityType("ObjectProperty", OWLRDFVocabulary.OWL_OBJECT_PROPERTY);
    public static final EntityType<OWLDataProperty> DATA_PROPERTY = new EntityType("DataProperty", OWLRDFVocabulary.OWL_DATA_PROPERTY);
    public static final EntityType<OWLAnnotationProperty> ANNOTATION_PROPERTY = new EntityType("AnnotationProperty", OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY);
    public static final EntityType<OWLNamedIndividual> NAMED_INDIVIDUAL = new EntityType("NamedIndividual", OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL);
    public static final EntityType<OWLDatatype> DATATYPE = new EntityType("Datatype", OWLRDFVocabulary.RDFS_DATATYPE);
    private static List<EntityType<?>> values;
    private String name;
    private OWLRDFVocabulary vocabulary;

    private EntityType(String name, OWLRDFVocabulary vocabulary) {
        this.name = name;
        this.vocabulary = vocabulary;
    }

    public OWLRDFVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static List<EntityType<?>> values() {
        return values;
    }

    static {
        ArrayList<EntityType<Object>> l = new ArrayList<EntityType<Object>>();
        l.add(CLASS);
        l.add(OBJECT_PROPERTY);
        l.add(DATA_PROPERTY);
        l.add(ANNOTATION_PROPERTY);
        l.add(NAMED_INDIVIDUAL);
        l.add(DATATYPE);
        values = Collections.unmodifiableList(l);
    }
}

