/*
 * Decompiled with CFR 0.152.
 */
package rationals.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import rationals.Automaton;
import rationals.State;
import rationals.Transition;
import rationals.properties.Relation;
import rationals.transformations.StatesCouple;
import rationals.transformations.TransformationsToolBox;

public class TraceEquivalence
implements Relation {
    private Automaton a1;
    private Automaton a2;
    private List errorTrace;

    public void setAutomata(Automaton a1, Automaton a2) {
        this.a1 = a1;
        this.a2 = a2;
    }

    public boolean equivalence(State q0a, State q0b) {
        Set nsa = this.a1.getStateFactory().stateSet();
        Set nsb = this.a2.getStateFactory().stateSet();
        nsa.add(q0a);
        nsb.add(q0b);
        return this.equivalence(nsa, nsb);
    }

    public boolean equivalence(Set nsa, Set nsb) {
        Stack<StatesCouple> todo = new Stack<StatesCouple>();
        Stack<String> labels = new Stack<String>();
        ArrayList trace = new ArrayList();
        HashSet<StatesCouple> done = new HashSet<StatesCouple>();
        todo.push(new StatesCouple(nsa, nsb));
        labels.push("");
        do {
            StatesCouple cpl = (StatesCouple)todo.pop();
            Object lbl = labels.pop();
            Set sa = TransformationsToolBox.epsilonClosure(cpl.sa, this.a1);
            Set sb = TransformationsToolBox.epsilonClosure(cpl.sb, this.a2);
            if (done.contains(cpl)) {
                trace.remove(trace.size() - 1);
                continue;
            }
            trace.add(lbl);
            done.add(cpl);
            ArrayList tas = new ArrayList(this.a1.delta(sa));
            ArrayList tbs = new ArrayList(this.a2.delta(sb));
            HashMap am = new HashMap();
            HashMap bm = new HashMap();
            this.mapAlphabet(tas, am, this.a1);
            this.mapAlphabet(tbs, bm, this.a2);
            Iterator it2 = am.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry me = it2.next();
                Object l = me.getKey();
                Set as = (Set)me.getValue();
                Set bs = (Set)bm.remove(l);
                if (bs == null) {
                    this.errorTrace = trace;
                    this.errorTrace.add(l);
                    return false;
                }
                StatesCouple sc = new StatesCouple(as, bs);
                todo.push(sc);
                labels.push((String)l);
            }
            if (bm.isEmpty()) continue;
            this.errorTrace = trace;
            this.errorTrace.add(bm.keySet());
            return false;
        } while (!todo.isEmpty());
        return true;
    }

    public void mapAlphabet(List tas, Map am, Automaton a) {
        while (!tas.isEmpty()) {
            Transition tr = (Transition)tas.remove(0);
            Object l = tr.label();
            if (l == null) continue;
            Set as = (Set)am.get(l);
            if (as == null) {
                as = a.getStateFactory().stateSet();
                am.put(l, as);
            }
            as.add(tr.end());
        }
    }

    public List getErrorTrace() {
        return this.errorTrace;
    }
}

