/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.interfaces.Peak;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.FragmentIon;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.Peptide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class InSilicoDigester {
    private final String iSequence;
    private final Peptide iPeptide;
    private final HashMap<String, Double> iMasses;
    private final FragmentIon[] iAIons;
    private final FragmentIon[] iANH3Ions;
    private final FragmentIon[] iAH2OIons;
    private final FragmentIon[] iBIons;
    private final FragmentIon[] iBNH3Ions;
    private final FragmentIon[] iBH2OIons;
    private final FragmentIon[] iCIons;
    private final FragmentIon[] iXIons;
    private final FragmentIon[] iYIons;
    private final FragmentIon[] iYNH3Ions;
    private final FragmentIon[] iYH2OIons;
    private final FragmentIon[] iZIons;
    private final FragmentIon[] iMH;
    private final FragmentIon[] iMHNH3;
    private final FragmentIon[] iMHH2O;
    private final double iFragmentMassError;
    private final int iPeptideCharge;
    private final ModificationMap iModMap;
    private Domain iDomain;

    public InSilicoDigester(Peptide aPeptide, Domain aDomain, ModificationMap aModMap, HashMap aMasses, int aCharge, double aFragmentMassError) {
        this.iPeptide = aPeptide;
        this.iDomain = aDomain;
        this.iSequence = aDomain.getDomainSequence();
        this.iModMap = aModMap;
        this.iMasses = aMasses;
        this.iPeptideCharge = aCharge;
        int length = this.iSequence.length() * this.iPeptideCharge;
        this.iAIons = new FragmentIon[length];
        this.iAH2OIons = new FragmentIon[length];
        this.iANH3Ions = new FragmentIon[length];
        this.iBIons = new FragmentIon[length];
        this.iBH2OIons = new FragmentIon[length];
        this.iBNH3Ions = new FragmentIon[length];
        this.iCIons = new FragmentIon[length];
        this.iXIons = new FragmentIon[length];
        this.iYIons = new FragmentIon[length];
        this.iYNH3Ions = new FragmentIon[length];
        this.iYH2OIons = new FragmentIon[length];
        this.iZIons = new FragmentIon[length];
        this.iMH = new FragmentIon[this.iPeptideCharge];
        this.iMHNH3 = new FragmentIon[this.iPeptideCharge];
        this.iMHH2O = new FragmentIon[this.iPeptideCharge];
        this.iFragmentMassError = aFragmentMassError;
        this.calculateIons();
    }

    double[] calculatePeptideMasses() {
        double[] peptideMasses = new double[this.iSequence.length()];
        for (int i = 0; i < this.iSequence.length(); ++i) {
            String aa;
            ArrayList<Modification> varModList;
            double mass = 0.0;
            ArrayList<Modification> fixModList = this.iModMap.getFixedModifications(this.iDomain.getDomainKey());
            if (fixModList.size() > 0) {
                for (Modification fixMod : fixModList) {
                    int modIndex = Integer.parseInt(fixMod.getLocation()) - this.iDomain.getDomainStart();
                    if (modIndex != i) continue;
                    mass += fixMod.getMass();
                }
            }
            if ((varModList = this.iModMap.getVariableModifications(this.iDomain.getDomainKey())).size() > 0) {
                for (Modification varMod : varModList) {
                    int modIndex = Integer.parseInt(varMod.getLocation()) - this.iDomain.getDomainStart();
                    if (modIndex != i) continue;
                    mass += varMod.getMass();
                }
            }
            if (!this.iMasses.containsKey(aa = String.valueOf(this.iSequence.charAt(i)))) {
                throw new IllegalArgumentException("'" + aa + "' is an unknown amino acid! Complete peptide sequence: '" + this.iSequence + "'. Please check your X!Tandem file.");
            }
            peptideMasses[i] = mass += this.iMasses.get(aa).doubleValue();
        }
        return peptideMasses;
    }

    private void calculateIons() {
        double[] peptideMasses = this.calculatePeptideMasses();
        double hydrogenMass = 1.007825;
        double oxygenMass = 15.99491;
        double nitrogenMass = 14.00307;
        double carbonMass = 12.0;
        double c_termMass = this.iMasses.get("C_term");
        int length = this.iSequence.length();
        if (this.iSequence.compareTo("LHYFNAR") == 0) {
            boolean a = false;
        }
        int cptb = 0;
        int cpty = 0;
        for (int charge = 1; charge <= this.iPeptideCharge; ++charge) {
            this.iMH[charge - 1] = new FragmentIon((this.iDomain.getDomainMh() + (double)(charge - 1) * hydrogenMass) / (double)charge, 12, 0, charge, this.iFragmentMassError);
            this.iMHH2O[charge - 1] = new FragmentIon((this.iDomain.getDomainMh() - oxygenMass - 2.0 * hydrogenMass + (double)(charge - 1) * hydrogenMass) / (double)charge, 14, 0, charge, this.iFragmentMassError);
            this.iMHNH3[charge - 1] = new FragmentIon((this.iDomain.getDomainMh() - nitrogenMass - 3.0 * hydrogenMass + (double)(charge - 1) * hydrogenMass) / (double)charge, 13, 0, charge, this.iFragmentMassError);
            for (int i = 0; i < length; ++i) {
                int j;
                double bMass = 0.0;
                double yMass = 0.0;
                for (j = 0; j <= i; ++j) {
                    bMass += peptideMasses[j];
                }
                if (charge <= this.iPeptideCharge) {
                    this.iAIons[cptb] = new FragmentIon((bMass - oxygenMass - carbonMass + (double)charge * hydrogenMass) / (double)charge, 0, i + 1, charge, this.iFragmentMassError);
                    this.iANH3Ions[cptb] = new FragmentIon((bMass - oxygenMass - carbonMass - nitrogenMass - 3.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 1, i + 1, charge, this.iFragmentMassError);
                    this.iAH2OIons[cptb] = new FragmentIon((bMass - 2.0 * oxygenMass - carbonMass - 2.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 2, i + 1, charge, this.iFragmentMassError);
                    this.iBIons[cptb] = new FragmentIon((bMass + (double)charge * hydrogenMass) / (double)charge, 3, i + 1, charge, this.iFragmentMassError);
                    this.iBNH3Ions[cptb] = new FragmentIon((bMass - nitrogenMass - 3.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 4, i + 1, charge, this.iFragmentMassError);
                    this.iBH2OIons[cptb] = new FragmentIon((bMass - oxygenMass - 2.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 5, i + 1, charge, this.iFragmentMassError);
                    this.iCIons[cptb] = new FragmentIon((bMass + nitrogenMass + 3.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 6, i + 1, charge, this.iFragmentMassError);
                    ++cptb;
                }
                for (j = 0; j <= i; ++j) {
                    yMass += peptideMasses[length - 1 - j];
                }
                yMass = yMass + c_termMass + hydrogenMass;
                this.iXIons[cpty] = new FragmentIon((yMass + carbonMass + oxygenMass - 2.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 7, i + 1, charge, this.iFragmentMassError);
                this.iYIons[cpty] = new FragmentIon((yMass + (double)charge * hydrogenMass) / (double)charge, 8, i + 1, charge, this.iFragmentMassError);
                this.iYNH3Ions[cpty] = new FragmentIon((yMass - nitrogenMass - 3.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 9, i + 1, charge, this.iFragmentMassError);
                this.iYH2OIons[cpty] = new FragmentIon((yMass - 2.0 * hydrogenMass - oxygenMass + (double)charge * hydrogenMass) / (double)charge, 10, i + 1, charge, this.iFragmentMassError);
                this.iZIons[cpty] = new FragmentIon((yMass - nitrogenMass - 2.0 * hydrogenMass + (double)charge * hydrogenMass) / (double)charge, 11, i + 1, charge, this.iFragmentMassError);
                ++cpty;
            }
        }
    }

    public Vector getMatchedIons(int ionType, Peak[] aPeaks) {
        FragmentIon[] theoreticIons;
        Vector<FragmentIon> matchedIons = new Vector<FragmentIon>();
        for (FragmentIon fragIon : theoreticIons = this.getTheoreticIons(ionType)) {
            if (fragIon == null || !fragIon.isMatch(aPeaks, this.iFragmentMassError)) continue;
            matchedIons.add(fragIon);
        }
        return matchedIons;
    }

    public FragmentIon[] getTheoreticIons(int type) {
        switch (type) {
            case 0: {
                return this.iAIons;
            }
            case 2: {
                return this.iAH2OIons;
            }
            case 1: {
                return this.iANH3Ions;
            }
            case 3: {
                return this.iBIons;
            }
            case 5: {
                return this.iBH2OIons;
            }
            case 4: {
                return this.iBNH3Ions;
            }
            case 6: {
                return this.iCIons;
            }
            case 7: {
                return this.iXIons;
            }
            case 8: {
                return this.iYIons;
            }
            case 10: {
                return this.iYH2OIons;
            }
            case 9: {
                return this.iYNH3Ions;
            }
            case 11: {
                return this.iZIons;
            }
            case 12: {
                return this.iMH;
            }
            case 13: {
                return this.iMHNH3;
            }
            case 14: {
                return this.iMHH2O;
            }
        }
        return null;
    }
}

