/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise.rna;

import edu.msu.cme.rdp.alignment.pairwise.rna.DistMatrixSeq;
import edu.msu.cme.rdp.alignment.pairwise.rna.DistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.OverlapCheckFailedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryResidentDistanceMatrix {
    List<DistMatrixSeq> xSeqs;
    List<DistMatrixSeq> ySeqs;
    DistanceModel distanceModel;
    double[][] distanceMatrix;

    protected MemoryResidentDistanceMatrix(List<DistMatrixSeq> sequenceList, DistanceModel distanceModel, int overlapLimit) throws OverlapCheckFailedException {
        this.ySeqs = sequenceList;
        this.xSeqs = this.ySeqs;
        this.distanceModel = distanceModel;
        this.distanceMatrix = new double[sequenceList.size()][sequenceList.size()];
        HashMap<String, Set<String>> errorMap = new HashMap<String, Set<String>>();
        for (int seq1 = 0; seq1 < sequenceList.size(); ++seq1) {
            this.distanceMatrix[seq1][seq1] = 0.0;
            HashSet<String> nonOverlappingSet = new HashSet<String>();
            for (int seq2 = seq1 + 1; seq2 < sequenceList.size(); ++seq2) {
                try {
                    double dist;
                    this.distanceMatrix[seq1][seq2] = dist = distanceModel.getDistance(sequenceList.get(seq1).getSeqBytes(), sequenceList.get(seq2).getSeqBytes(), overlapLimit);
                    this.distanceMatrix[seq2][seq1] = dist;
                    continue;
                }
                catch (OverlapCheckFailedException ex) {
                    this.distanceMatrix[seq1][seq2] = Double.NaN;
                    this.distanceMatrix[seq2][seq1] = Double.NaN;
                    nonOverlappingSet.add(sequenceList.get(seq2).getSeqid());
                }
            }
            if (nonOverlappingSet.isEmpty()) continue;
            errorMap.put(sequenceList.get(seq1).getSeqid(), nonOverlappingSet);
        }
        if (!errorMap.isEmpty()) {
            throw new OverlapCheckFailedException(errorMap);
        }
    }

    protected MemoryResidentDistanceMatrix(List<DistMatrixSeq> xSeqList, List<DistMatrixSeq> ySeqList, DistanceModel distanceModel, int overlapLimit) throws OverlapCheckFailedException {
        this.xSeqs = xSeqList;
        this.ySeqs = ySeqList;
        this.distanceModel = distanceModel;
        this.distanceMatrix = new double[xSeqList.size()][ySeqList.size()];
        int x = 0;
        HashMap<String, Set<String>> errorMap = new HashMap<String, Set<String>>();
        for (DistMatrixSeq xSeq : xSeqList) {
            int y = 0;
            HashSet<String> nonOverlappingSet = new HashSet<String>();
            for (DistMatrixSeq ySeq : ySeqList) {
                try {
                    this.distanceMatrix[x][y] = distanceModel.getDistance(xSeq.getSeqBytes(), ySeq.getSeqBytes(), overlapLimit);
                }
                catch (OverlapCheckFailedException ex) {
                    this.distanceMatrix[x][y] = Double.NaN;
                    nonOverlappingSet.add(ySeq.getSeqid());
                }
                ++y;
            }
            if (!nonOverlappingSet.isEmpty()) {
                errorMap.put(xSeq.getSeqid(), nonOverlappingSet);
            }
            ++x;
        }
        if (!errorMap.isEmpty()) {
            throw new OverlapCheckFailedException(errorMap);
        }
    }

    public List<DistMatrixSeq> getXSeqs() {
        return this.xSeqs;
    }

    public List<DistMatrixSeq> getYSeqs() {
        return this.ySeqs;
    }

    public double[][] getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public double getDistance(int x, int y) {
        return this.distanceMatrix[x][y];
    }
}

