/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.cli;

import edu.msu.cme.rdp.alignment.errorcheck.RmPartialSeqs;
import edu.msu.cme.rdp.classifier.comparison.ComparisonCmd;
import edu.msu.cme.rdp.classifier.train.ClassifierTraineeMaker;
import edu.msu.cme.rdp.classifier.train.validation.crossvalidate.CrossValidateMain;
import edu.msu.cme.rdp.classifier.train.validation.distance.CompareTrainingSets;
import edu.msu.cme.rdp.classifier.train.validation.distance.TaxaSimilarityMain;
import edu.msu.cme.rdp.classifier.train.validation.leaveoneout.LeaveOneOutTesterMain;
import edu.msu.cme.rdp.classifier.train.validation.movingwindow.MainMovingWindow;
import edu.msu.cme.rdp.multicompare.Main;
import edu.msu.cme.rdp.multicompare.MergeTaxonCount;
import edu.msu.cme.rdp.multicompare.Reprocess;
import edu.msu.cme.rdp.readseq.utils.ResampleSeqFile;
import edu.msu.cme.rdp.readseq.utils.RmDupSeqs;
import java.util.Arrays;

public class ClassifierMain {
    public static void main(String[] args) throws Exception {
        String usage = "USAGE: ClassifierMain <subcommand> <subcommand args ...>\ndefault command is classify\n\tclassify      - classify one or multiple samples\n\tcrossvalidate - cross validate accuracy testing\n\tcomp-trainset - compare multiple training sets to find shared and unique taxa and sequences\n\tlibcompare    - compare two samples\n\tloot          - leave one (sequence or taxon) out accuracy testing\n\tmerge-detail  - merge classification detail result files to create a taxon assignment counts file\n\tmerge-count   - merge multiple taxon assignment count files to into one count file\n\trandom-sample - random select a subset or subregion of sequences\n\trm-dupseq     - remove identical or any sequence contained by another sequence\n\trm-partialseq - remove partial sequences\n\ttaxa-sim      - calculate and plot the similarities within taxa\n\ttrain         - retrain classifier";
        if (args.length == 0) {
            System.err.println(usage);
            return;
        }
        String cmd = args[0];
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (cmd.equals("classify")) {
            Main.main(newArgs);
        } else if (cmd.equals("libcompare")) {
            ComparisonCmd.main(newArgs);
        } else if (cmd.equals("merge-detail")) {
            Reprocess.main(newArgs);
        } else if (cmd.equals("merge-count")) {
            MergeTaxonCount.main(newArgs);
        } else if (cmd.equals("train")) {
            ClassifierTraineeMaker.main(newArgs);
        } else if (cmd.equals("loot")) {
            LeaveOneOutTesterMain.main(newArgs);
        } else if (cmd.equals("crossvalidate")) {
            CrossValidateMain.main(newArgs);
        } else if (cmd.equals("taxa-sim")) {
            TaxaSimilarityMain.main(newArgs);
        } else if (cmd.equals("random-sample")) {
            ResampleSeqFile.main((String[])newArgs);
        } else if (cmd.equals("rm-dupseq")) {
            RmDupSeqs.main((String[])newArgs);
        } else if (cmd.equals("rm-partialseq")) {
            RmPartialSeqs.main((String[])newArgs);
        } else if (cmd.equals("comp-trainset")) {
            CompareTrainingSets.main(newArgs);
        } else if (cmd.equals("segment")) {
            MainMovingWindow.main(newArgs);
        } else if (cmd.startsWith("-")) {
            Main.main(args);
        } else {
            System.err.println("ERROR: wrong subcommand");
            System.err.println(usage);
            return;
        }
    }
}

