/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Ztable {
    private static String ztable_dataDir = "/data/classifier/ztable.txt";
    private static DecimalFormat df = new DecimalFormat("0.00");
    private Hashtable zHash = null;
    private static final double MAX_Z = 7.5;
    private static final double DELIMITER_Z = 4.0;

    public Ztable() {
        if (this.zHash == null) {
            this.zHash = new Hashtable();
            InputStreamReader in = new InputStreamReader(Ztable.class.getResourceAsStream(ztable_dataDir));
            this.readZtable(in);
        }
    }

    private void readZtable(InputStreamReader in) {
        try {
            BufferedReader reader = new BufferedReader(in);
            String line = "";
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (tokenizer.countTokens() == 0) continue;
                String initial_value = tokenizer.nextToken();
                int k = 0;
                while (tokenizer.hasMoreTokens()) {
                    double orig = Double.parseDouble(tokenizer.nextToken());
                    double pvalue = 2.0 * (1.0 - orig);
                    this.zHash.put(initial_value + k, new Double(pvalue));
                    ++k;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public double getPvalue(double z) {
        if ((z = Math.abs(z)) > 7.5) {
            z = 7.5;
        }
        String key = df.format(z).toString();
        if (z >= 4.0) {
            key = key.substring(0, 3) + "0";
        }
        return (Double)this.zHash.get(key);
    }
}

