/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.NBClassifier;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.classifier.train.validation.ValidationClassificationResult;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DecisionMaker {
    public static final int NUM_OF_RUNS = 100;
    private int numOfRuns = 100;
    private TreeFactory factory;

    public DecisionMaker(TreeFactory factory) {
        this.factory = factory;
    }

    public List<ValidationClassificationResult> getBestClasspath(GoodWordIterator iterator, HashMap<String, HierarchyTree> nodeMap, boolean useSeed, int min_bootstrap_words) throws IOException {
        ValidationClassificationResult result = null;
        try {
            NBClassifier classifier = new NBClassifier(this.factory, iterator.getWordArr(), new ArrayList<HierarchyTree>(nodeMap.values()), useSeed, min_bootstrap_words);
            ValidationClassificationResult determinedResult = classifier.assignClass();
            HashMap<HierarchyTree, ValidationClassificationResult> determinedMap = new HashMap<HierarchyTree, ValidationClassificationResult>();
            for (HierarchyTree aNode = determinedResult.getBestClass(); aNode != null; aNode = aNode.getParent()) {
                determinedMap.put(aNode, new ValidationClassificationResult(aNode, 0.0f, 0.0f));
            }
            this.numOfRuns = 100;
            for (int i = 0; i < this.numOfRuns; ++i) {
                result = classifier.assignClassRandomsample();
                this.addResult(result, determinedMap);
            }
            return this.getFinalResultList(determinedMap, determinedResult);
        }
        catch (IllegalStateException ex) {
            System.err.println(ex.toString());
            return new ArrayList<ValidationClassificationResult>();
        }
    }

    void addResult(ValidationClassificationResult result, HashMap map) {
        for (HierarchyTree node = result.getBestClass(); node != null; node = node.getParent()) {
            ValidationClassificationResult assign = (ValidationClassificationResult)map.get(node);
            if (assign == null) continue;
            assign.setNumOfVotes(assign.getNumOfVotes() + 1.0f);
        }
    }

    private List getFinalResultList(HashMap map, ValidationClassificationResult determinedResult) {
        ArrayList<ValidationClassificationResult> finalAssigns = new ArrayList<ValidationClassificationResult>();
        for (HierarchyTree aNode = determinedResult.getBestClass(); aNode != null; aNode = aNode.getParent()) {
            ValidationClassificationResult assign = (ValidationClassificationResult)map.get(aNode);
            assign.setPosteriorProb(determinedResult.getPosteriorProb());
            assign.setNumOfVotes(assign.getNumOfVotes() / (float)this.numOfRuns);
            finalAssigns.add(0, assign);
        }
        return finalAssigns;
    }
}

