/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.leaveoneout;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.LineageSequenceParser;
import edu.msu.cme.rdp.classifier.train.validation.CorrectAssignment;
import edu.msu.cme.rdp.classifier.train.validation.DecisionMaker;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.StatusCount;
import edu.msu.cme.rdp.classifier.train.validation.StatusCountUtils;
import edu.msu.cme.rdp.classifier.train.validation.TreeFactory;
import edu.msu.cme.rdp.classifier.train.validation.ValidClassificationResultFacade;
import edu.msu.cme.rdp.classifier.train.validation.ValidationClassificationResult;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LeaveOneOutTester {
    BufferedWriter outFile;
    private Map<String, CorrectAssignment> num_hierLevel = new HashMap<String, CorrectAssignment>();
    private String testRank = "GENUS";
    private int numGoodBases = 0;

    public LeaveOneOutTester(Writer writer, int numGoodBases) throws IOException {
        this.outFile = new BufferedWriter(writer);
        this.numGoodBases = numGoodBases;
    }

    public ArrayList<HashMap<String, StatusCount>> classify(TreeFactory factory, LineageSequenceParser parser, boolean useSeed, int min_bootstrap_words, boolean hideTaxon) throws IOException {
        this.testRank = factory.getLowestRank();
        ArrayList<ValidClassificationResultFacade> resultList = new ArrayList<ValidClassificationResultFacade>();
        HashMap<String, HierarchyTree> nodeMap = new HashMap<String, HierarchyTree>();
        DecisionMaker dm = new DecisionMaker(factory);
        HierarchyTree root = factory.getRoot();
        root.getNodeMap(this.testRank, nodeMap);
        if (nodeMap.isEmpty()) {
            throw new IllegalArgumentException("\nThere is no node in " + this.testRank + " level!");
        }
        ArrayList<HashMap<String, StatusCount>> statusCountList = new ArrayList<HashMap<String, StatusCount>>();
        for (int b = 0; b <= 100; ++b) {
            HashMap<String, StatusCount> statusCountMap = new HashMap<String, StatusCount>();
            statusCountList.add(statusCountMap);
            for (String rank : factory.getRankSet()) {
                statusCountMap.put(rank, new StatusCount());
            }
        }
        int i = 0;
        while (parser.hasNext()) {
            LineageSequence pSeq = parser.next();
            if (pSeq.getSeqString().length() == 0) continue;
            GoodWordIterator wordIterator = null;
            wordIterator = this.numGoodBases > 0 ? pSeq.getPartialSeqIteratorbyGoodBases(this.numGoodBases) : new GoodWordIterator(pSeq.getSeqString());
            if (wordIterator == null || wordIterator.getNumofWords() == 0) continue;
            HierarchyTree curTree = nodeMap.get(pSeq.getAncestors().get(pSeq.getAncestors().size() - 1));
            if (!hideTaxon) {
                if (curTree.isSingleton()) {
                    nodeMap.remove(curTree.getName());
                } else {
                    curTree.hideSeq(wordIterator);
                }
            } else {
                nodeMap.remove(curTree.getName());
            }
            List<ValidationClassificationResult> result = dm.getBestClasspath(wordIterator, nodeMap, useSeed, min_bootstrap_words);
            ValidClassificationResultFacade resultFacade = new ValidClassificationResultFacade(pSeq, result);
            resultFacade.setLabeledNode(curTree);
            this.compareClassificationResult(resultFacade);
            this.labelAssignmentStatus(factory, resultFacade, statusCountList);
            resultList.add(resultFacade);
            System.out.print(i++ + " ");
            if (!hideTaxon) {
                if (curTree.isSingleton()) {
                    nodeMap.put(curTree.getName(), curTree);
                    continue;
                }
                curTree.unhideSeq(wordIterator);
                continue;
            }
            nodeMap.put(curTree.getName(), curTree);
        }
        this.displayClassification(resultList);
        this.outFile.write("\n**misclassified sequences group by taxon\n");
        this.outFile.write("Rank\tName\tTotal Seqs\tTested Seqs (non-singleton)\tmisclassified\tpct misclassified\n");
        this.displayTreeErrorRate(root, 0);
        this.outFile.write("\n**ROC matrix\n");
        this.outFile.write(StatusCountUtils.calROCMatrix(Integer.toString(min_bootstrap_words), statusCountList));
        this.outFile.write("\n**Area under curve\n");
        this.outFile.write(StatusCountUtils.calAUC(Integer.toString(min_bootstrap_words), statusCountList));
        this.outFile.close();
        return statusCountList;
    }

    public void displayTreeErrorRate(HierarchyTree root, int indent) throws IOException {
        double pct_miss = 0.0;
        if (root.getNumTotalTestedseq() > 0) {
            pct_miss = (double)root.getMissCount() / (double)root.getNumTotalTestedseq();
        }
        this.outFile.write(root.getTaxonomy().getHierLevel() + "\t" + root.getName() + "\t" + root.getTotalSeqs() + "\t" + root.getNumTotalTestedseq() + "\t" + root.getMissCount() + "\t" + pct_miss + "\n");
        Iterator<HierarchyTree> i = root.getSubclasses().iterator();
        while (i.hasNext()) {
            this.displayTreeErrorRate(i.next(), indent + 1);
        }
    }

    private void displayClassification(List seqs) throws IOException {
        ValidClassificationResultFacade resultFacade;
        CorrectAssignment assign;
        int i = 0;
        DecimalFormat df = new DecimalFormat("0.###");
        this.outFile.write("\n\n**The statistics for each hierarchy level: \n 1: number of correct assigned sequences / number of total sequences for that bin rage\n");
        this.outFile.write("Level\t100-95\t\t94-90");
        for (i = 9; i > 0; --i) {
            this.outFile.write("\t\t" + (i * 10 - 1) + "-" + (i - 1) * 10);
        }
        this.outFile.write("\t\tCorrect Assigned\tTotal Seqs\tCorrect/Total\n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + "\t");
            assign = this.num_hierLevel.get(name);
            this.calStandardError(assign);
            int total = 0;
            int correct = 0;
            for (i = assign.bins - 1; i >= 0; --i) {
                this.outFile.write(assign.numCorrect[i] + "\t" + assign.numTotal[i] + "\t");
                total += assign.numTotal[i];
                correct += assign.numCorrect[i];
            }
            if (total > 0) {
                this.outFile.write(correct + "\t" + total + "\t" + (double)correct / (double)total + "\t");
            } else {
                this.outFile.write(correct + "\t" + total + "\t" + 0 + "\t");
            }
            this.outFile.write("\n");
        }
        this.outFile.write("\n\n** 2. The average votes for each bin range \n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                if (assign.numTotal[i] == 0) {
                    this.outFile.write("0\t");
                    continue;
                }
                this.outFile.write(df.format(assign.sumOfVotes[i] * 100.0f / (float)assign.numTotal[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
        this.outFile.write("\n\n** 3. The percentage of correctness for each bin range (the percentage of #1)\n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                if (assign.numTotal[i] == 0) {
                    this.outFile.write("0\t");
                    continue;
                }
                this.outFile.write(df.format((float)assign.numCorrect[i] / (float)assign.numTotal[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
        this.outFile.write("\n\n** 4. The standard error for each bin range \n");
        for (String name : this.num_hierLevel.keySet()) {
            this.outFile.write(name + " \t ");
            assign = this.num_hierLevel.get(name);
            for (i = assign.bins - 1; i >= 0; --i) {
                this.outFile.write(df.format(assign.standardError[i]) + "\t");
            }
            this.outFile.write(" \n");
        }
        this.outFile.write("\n**misclassified sequences: \n");
        for (i = 0; i < seqs.size(); ++i) {
            resultFacade = (ValidClassificationResultFacade)seqs.get(i);
            if (!resultFacade.isMissed()) continue;
            this.outFile.write(resultFacade.getPath() + "\n");
        }
        this.outFile.write("\n**singleton sequences: \n");
        for (i = 0; i < seqs.size(); ++i) {
            resultFacade = (ValidClassificationResultFacade)seqs.get(i);
            if (!resultFacade.getLabeledNode().isSingleton()) continue;
            this.outFile.write(resultFacade.getPath() + "\n");
        }
    }

    private void compareClassificationResult(ValidClassificationResultFacade resultFacade) {
        List<ValidationClassificationResult> hitList = resultFacade.getRankAssignment();
        for (HierarchyTree trueParent = resultFacade.getLabeledNode(); trueParent != null; trueParent = trueParent.getParent()) {
            if (trueParent.isSingleton()) continue;
            ValidationClassificationResult hit = null;
            for (int i = 0; i < hitList.size(); ++i) {
                ValidationClassificationResult tmp = hitList.get(i);
                if (!trueParent.getTaxonomy().getHierLevel().equals(tmp.getBestClass().getTaxonomy().getHierLevel())) continue;
                hit = tmp;
                break;
            }
            if (trueParent.getTaxonomy().getHierLevel().equalsIgnoreCase(this.testRank)) {
                trueParent.incNumTotalTestedseq();
            }
            boolean correct = false;
            if (hit != null) {
                if (trueParent.getTaxonomy().getTaxID() == hit.getBestClass().getTaxonomy().getTaxID()) {
                    correct = true;
                } else {
                    resultFacade.setMissedRank(trueParent.getTaxonomy().getHierLevel());
                }
                this.increaseCount(hit, trueParent.getTaxonomy().getHierLevel(), correct, this.num_hierLevel);
            }
            if (correct || !trueParent.getTaxonomy().getHierLevel().equalsIgnoreCase(this.testRank)) continue;
            trueParent.incMissCount();
        }
    }

    private void increaseCount(ValidationClassificationResult aResult, String level, boolean correct, Map aMap) {
        int binIndex;
        CorrectAssignment assign = (CorrectAssignment)aMap.get(level);
        if (assign == null) {
            assign = new CorrectAssignment();
            aMap.put(level, assign);
        }
        if ((binIndex = (int)Math.floor(aResult.getNumOfVotes() * 10.0f)) == 9 && (double)aResult.getNumOfVotes() >= 0.95) {
            binIndex = 10;
        }
        int n = binIndex;
        assign.numTotal[n] = assign.numTotal[n] + 1;
        int n2 = binIndex;
        assign.sumOfVotes[n2] = assign.sumOfVotes[n2] + aResult.getNumOfVotes();
        if (correct) {
            int n3 = binIndex;
            assign.numCorrect[n3] = assign.numCorrect[n3] + 1;
        }
    }

    private void calStandardError(CorrectAssignment assign) {
        for (int i = 0; i < assign.bins; ++i) {
            if (assign.numTotal[i] == 0) {
                assign.standardError[i] = 0.0f;
                continue;
            }
            float p = (float)assign.numCorrect[i] / (float)assign.numTotal[i];
            assign.standardError[i] = (float)Math.sqrt(p * (1.0f - p) / (float)assign.numTotal[i]);
        }
    }

    private void labelAssignmentStatus(TreeFactory factory, ValidClassificationResultFacade resultFacade, ArrayList<HashMap<String, StatusCount>> statusCountList) throws IOException {
        HashMap<String, HierarchyTree> labeledTreeMap = new HashMap<String, HierarchyTree>();
        for (HierarchyTree trueParent = resultFacade.getLabeledNode(); trueParent != null; trueParent = trueParent.getParent()) {
            labeledTreeMap.put(trueParent.getTaxonomy().getHierLevel(), trueParent);
        }
        List<ValidationClassificationResult> hitList = resultFacade.getRankAssignment();
        for (ValidationClassificationResult curRankResult : hitList) {
            int b;
            String curRank = curRankResult.getBestClass().getTaxonomy().getHierLevel();
            boolean match = true;
            HierarchyTree matchingRankTreeNode = (HierarchyTree)labeledTreeMap.get(curRank);
            if (matchingRankTreeNode != null && matchingRankTreeNode.isSingleton()) continue;
            if (matchingRankTreeNode == null) {
                match = false;
            } else if (!curRankResult.getBestClass().getName().equalsIgnoreCase(matchingRankTreeNode.getName())) {
                match = false;
            }
            int bootstrap = (int)(curRankResult.getNumOfVotes() * 100.0f);
            if (match) {
                for (b = 0; b <= bootstrap; ++b) {
                    statusCountList.get(b).get(curRank).incNumTP(1);
                }
                for (b = bootstrap + 1; b < statusCountList.size(); ++b) {
                    statusCountList.get(b).get(curRank).incNumFN(1);
                }
                continue;
            }
            for (b = 0; b <= bootstrap; ++b) {
                statusCountList.get(b).get(curRank).incNumFP(1);
            }
            for (b = bootstrap + 1; b < statusCountList.size(); ++b) {
                statusCountList.get(b).get(curRank).incNumTN(1);
            }
        }
    }

    protected Map getNum_hierLevelMap() {
        return this.num_hierLevel;
    }
}

