/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.multicompare.MCSample;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MCSamplePrintUtil {
    private static ArrayList<String> orderedRankList = new ArrayList();

    private static String[] generateBinRange() {
        String[] binRange = new String[11];
        int index = 0;
        int begin = 0;
        int countArrIndex = MCSample.getBootstrapIndex(0.0);
        for (int i = 0; i <= 100; ++i) {
            int newCountArrIndex = MCSample.getBootstrapIndex((double)i / 100.0);
            if (newCountArrIndex <= countArrIndex) continue;
            binRange[index++] = new String(i - 1 + "-" + begin);
            countArrIndex = newCountArrIndex;
            begin = i;
        }
        binRange[index++] = new String(">" + (begin - 1));
        return binRange;
    }

    public static void printBootstrapCountTable(PrintStream out, MCSample sample) throws IOException {
        out.println("sample: " + sample.getSampleName());
        out.println("\tNumber of matching assignments out of 100 bootstraps");
        String[] binRange = MCSamplePrintUtil.generateBinRange();
        out.print("Rank");
        for (int i = binRange.length - 1; i > 0; --i) {
            out.print("\t" + binRange[i]);
        }
        out.println();
        for (String rank : orderedRankList) {
            int[] bootstrapCountArr = sample.getBootstrapCountTable().get(rank);
            if (bootstrapCountArr == null) continue;
            out.print(rank);
            for (int i = bootstrapCountArr.length - 1; i > 0; --i) {
                out.print("\t" + bootstrapCountArr[i]);
            }
            out.println();
        }
    }

    static {
        orderedRankList.add("domain");
        orderedRankList.add("phylum");
        orderedRankList.add("class");
        orderedRankList.add("order");
        orderedRankList.add("family");
        orderedRankList.add("genus");
    }
}

