/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

public class IUBUtilities {
    public static boolean isIUB(char base) {
        switch (base) {
            case '-': 
            case '.': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'k': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isIUB(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            if (IUBUtilities.isIUB((char)bases[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIUB(char[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            if (IUBUtilities.isIUB(bases[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isGap(char base) {
        switch (base) {
            case '-': 
            case '.': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isAmbiguity(char base) {
        switch (base) {
            case 'B': 
            case 'D': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'b': 
            case 'd': 
            case 'h': 
            case 'i': 
            case 'k': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 's': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static boolean isACGU(char base) {
        switch (base) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'U': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    public static boolean isIUPACDNA(char base) {
        switch (base) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'G': 
            case 'H': 
            case 'K': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'Y': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'g': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static boolean isA(char base) {
        switch (base) {
            case 'A': 
            case 'D': 
            case 'H': 
            case 'I': 
            case 'M': 
            case 'N': 
            case 'R': 
            case 'V': 
            case 'W': 
            case 'a': 
            case 'd': 
            case 'h': 
            case 'i': 
            case 'm': 
            case 'n': 
            case 'r': 
            case 'v': 
            case 'w': {
                return true;
            }
        }
        return false;
    }

    public static boolean isC(char base) {
        switch (base) {
            case 'B': 
            case 'C': 
            case 'H': 
            case 'M': 
            case 'N': 
            case 'S': 
            case 'V': 
            case 'Y': 
            case 'b': 
            case 'c': 
            case 'h': 
            case 'm': 
            case 'n': 
            case 's': 
            case 'v': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static boolean isG(char base) {
        switch (base) {
            case 'B': 
            case 'D': 
            case 'G': 
            case 'I': 
            case 'K': 
            case 'N': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'b': 
            case 'd': 
            case 'g': 
            case 'i': 
            case 'k': 
            case 'n': 
            case 'r': 
            case 's': 
            case 'v': {
                return true;
            }
        }
        return false;
    }

    public static boolean isU(char base) {
        switch (base) {
            case 'B': 
            case 'D': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'N': 
            case 'T': 
            case 'U': 
            case 'W': 
            case 'Y': 
            case 'b': 
            case 'd': 
            case 'h': 
            case 'i': 
            case 'k': 
            case 'n': 
            case 't': 
            case 'u': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static boolean matches(char b1, char b2) {
        return IUBUtilities.isA(b1) && IUBUtilities.isA(b2) || IUBUtilities.isC(b1) && IUBUtilities.isC(b2) || IUBUtilities.isG(b1) && IUBUtilities.isG(b2) || IUBUtilities.isU(b1) && IUBUtilities.isU(b2);
    }

    public static String makeProper(String seq) {
        StringBuffer properSeq = new StringBuffer("");
        block20: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case '-': 
                case '.': 
                case '~': {
                    properSeq = properSeq.append("-");
                    continue block20;
                }
                case 'A': 
                case 'a': {
                    properSeq = properSeq.append("A");
                    continue block20;
                }
                case 'C': 
                case 'c': {
                    properSeq = properSeq.append("C");
                    continue block20;
                }
                case 'G': 
                case 'g': {
                    properSeq = properSeq.append("G");
                    continue block20;
                }
                case 'T': 
                case 'U': 
                case 't': 
                case 'u': {
                    properSeq = properSeq.append("T");
                    continue block20;
                }
                case 'N': 
                case 'n': {
                    properSeq = properSeq.append("N");
                    continue block20;
                }
                case 'X': 
                case 'x': {
                    properSeq = properSeq.append("X");
                    continue block20;
                }
                case 'M': 
                case 'm': {
                    properSeq = properSeq.append("M");
                    continue block20;
                }
                case 'R': 
                case 'r': {
                    properSeq = properSeq.append("R");
                    continue block20;
                }
                case 'W': 
                case 'w': {
                    properSeq = properSeq.append("W");
                    continue block20;
                }
                case 'S': 
                case 's': {
                    properSeq = properSeq.append("S");
                    continue block20;
                }
                case 'Y': 
                case 'y': {
                    properSeq = properSeq.append("Y");
                    continue block20;
                }
                case 'K': 
                case 'k': {
                    properSeq = properSeq.append("K");
                    continue block20;
                }
                case 'V': 
                case 'v': {
                    properSeq = properSeq.append("V");
                    continue block20;
                }
                case 'H': 
                case 'h': {
                    properSeq = properSeq.append("H");
                    continue block20;
                }
                case 'D': 
                case 'd': {
                    properSeq = properSeq.append("D");
                    continue block20;
                }
                case 'I': 
                case 'i': {
                    properSeq = properSeq.append("D");
                    continue block20;
                }
                case 'B': 
                case 'b': {
                    properSeq = properSeq.append("B");
                    continue block20;
                }
            }
        }
        return properSeq.toString();
    }

    public static String reverseComplement(String bases) {
        return IUBUtilities.reverse(IUBUtilities.complement(bases));
    }

    public static char[] reverseComplement(char[] bases) {
        return IUBUtilities.reverse(IUBUtilities.complement(bases));
    }

    public static String reverse(String str) {
        return new String(IUBUtilities.reverse(str.toCharArray()));
    }

    public static char[] reverse(char[] bases) {
        char[] ret = new char[bases.length];
        for (int i = bases.length; i > 0; --i) {
            ret[bases.length - i] = bases[i - 1];
        }
        return ret;
    }

    public static String complement(String bases) {
        return new String(IUBUtilities.complement(bases.toCharArray()));
    }

    public static char[] complement(char[] bases) {
        char[] ret = new char[bases.length];
        block20: for (int index = 0; index < bases.length; ++index) {
            switch (bases[index]) {
                case '-': 
                case '.': 
                case '~': {
                    ret[index] = 45;
                    continue block20;
                }
                case 'A': 
                case 'a': {
                    ret[index] = 84;
                    continue block20;
                }
                case 'C': 
                case 'c': {
                    ret[index] = 71;
                    continue block20;
                }
                case 'G': 
                case 'g': {
                    ret[index] = 67;
                    continue block20;
                }
                case 'T': 
                case 'U': 
                case 't': 
                case 'u': {
                    ret[index] = 65;
                    continue block20;
                }
                case 'N': 
                case 'n': {
                    ret[index] = 78;
                    continue block20;
                }
                case 'X': 
                case 'x': {
                    ret[index] = 88;
                    continue block20;
                }
                case 'M': 
                case 'm': {
                    ret[index] = 75;
                    continue block20;
                }
                case 'R': 
                case 'r': {
                    ret[index] = 89;
                    continue block20;
                }
                case 'W': 
                case 'w': {
                    ret[index] = 87;
                    continue block20;
                }
                case 'S': 
                case 's': {
                    ret[index] = 83;
                    continue block20;
                }
                case 'Y': 
                case 'y': {
                    ret[index] = 82;
                    continue block20;
                }
                case 'K': 
                case 'k': {
                    ret[index] = 77;
                    continue block20;
                }
                case 'V': 
                case 'v': {
                    ret[index] = 66;
                    continue block20;
                }
                case 'H': 
                case 'h': {
                    ret[index] = 68;
                    continue block20;
                }
                case 'D': 
                case 'd': {
                    ret[index] = 72;
                    continue block20;
                }
                case 'I': 
                case 'i': {
                    ret[index] = 72;
                    continue block20;
                }
                case 'B': 
                case 'b': {
                    ret[index] = 86;
                    continue block20;
                }
            }
        }
        return ret;
    }
}

