/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAligner;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import edu.msu.cme.rdp.alignment.pairwise.rna.DistanceModel;
import edu.msu.cme.rdp.alignment.pairwise.rna.IdentityDistanceModel;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.List;

public class PairwiseMatcher {
    public static void main(String[] args) throws Exception {
        Sequence seq;
        if (args.length != 3) {
            System.err.println("USAGE: PairwiseMatcher <ref_file> <query_file> <out_file>");
            return;
        }
        File inFile = new File(args[1]);
        File refFile = new File(args[0]);
        List refSeqs = SequenceReader.readFully((File)refFile);
        ScoringMatrix matrix = ScoringMatrix.getDefaultProteinMatrix();
        IdentityDistanceModel model = new IdentityDistanceModel();
        SequenceReader reader = new SequenceReader(inFile);
        LinkedHashMap<String, Integer> hits = new LinkedHashMap<String, Integer>();
        for (Sequence refSeq : refSeqs) {
            hits.put(refSeq.getSeqName(), 0);
        }
        PrintStream out = new PrintStream(args[2]);
        while ((seq = reader.readNextSequence()) != null) {
            long startTime = System.currentTimeMillis();
            PairwiseAlignment bestAlignment = null;
            Sequence bestRef = null;
            for (Sequence refSeq : refSeqs) {
                PairwiseAlignment alignment = PairwiseAligner.align(refSeq.getSeqString(), seq.getSeqString(), matrix, AlignmentMode.glocal);
                if (bestAlignment != null && bestAlignment.getScore() >= alignment.getScore()) continue;
                bestAlignment = alignment;
                bestRef = refSeq;
            }
            int start = -1;
            int end = -1;
            int refPos = 0;
            char[] seqi = bestAlignment.getAlignedSeqi().toCharArray();
            char[] seqj = bestAlignment.getAlignedSeqj().toCharArray();
            for (int index = 0; index < bestAlignment.getAlignedSeqi().length(); ++index) {
                if (seqj[index] != '-') {
                    if (start == -1) {
                        start = refPos;
                    }
                    end = refPos + 1;
                }
                if (seqi[index] == '-') continue;
                ++refPos;
            }
            double ident = ((DistanceModel)model).getDistance(bestAlignment.getAlignedSeqi().getBytes(), bestAlignment.getAlignedSeqj().getBytes(), 0);
            out.println(">\t" + seq.getSeqName() + "\t" + bestRef.getSeqName() + "\t" + bestAlignment.getScore() + "\t" + start + "\t" + end + "\t" + ident);
            out.println(bestAlignment.getAlignedSeqi());
            out.println(bestAlignment.getAlignedSeqj());
            hits.put(bestRef.getSeqName(), (Integer)hits.get(bestRef.getSeqName()) + 1);
            System.out.println("Processed " + seq.getSeqName() + " in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        out.close();
        for (String seqid : hits.keySet()) {
            int hitCount = (Integer)hits.get(seqid);
            if (hitCount == 0) continue;
            System.out.println(seqid + "\t" + hitCount);
        }
    }
}

