/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.pairwise;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScoringMatrix {
    private static ScoringMatrix defaultNuclMatrix = null;
    private static ScoringMatrix defaultProtMatrix = null;
    private static ScoringMatrix defaultProtMetricMatrix = null;
    public static final int DEFAULT_GAP_OPEN_PEALTY = -10;
    public static final int DEFAULT_GAP_EXT_PENALTY = -1;
    public static final int DEFAULT_FRAME_SHIFT_PENALTY = -10;
    public static final int DEFAULT_METRIC_GAP_OPEN_PEALTY = -13;
    public static final int DEFAULT_METRIC_GAP_EXT_PENALTY = -4;
    private int[][] scoringMatrix;
    private int[] reverseLookup = new int[127];
    private int gapPenalty;
    private int gapExtend;
    private int frameshiftPenalty = -10;

    private ScoringMatrix() {
    }

    public ScoringMatrix(File f, int gapOpenPenalty, int gapExtendPenalty) throws IOException {
        this(new FileInputStream(f), gapOpenPenalty, gapExtendPenalty);
    }

    public ScoringMatrix(InputStream is, int gapOpenPenalty, int gapExtendPenalty, int frameshiftPenalty) throws IOException {
        this(is, gapOpenPenalty, gapExtendPenalty);
        this.frameshiftPenalty = frameshiftPenalty;
    }

    public ScoringMatrix(InputStream is, int gapOpenPenalty, int gapExtendPenalty) throws IOException {
        String line;
        this.gapPenalty = gapOpenPenalty;
        this.gapExtend = gapExtendPenalty;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        for (int index = 0; index < 127; ++index) {
            this.reverseLookup[index] = -1;
        }
        int curRow = -1;
        ArrayList<Character> validChars = new ArrayList<Character>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim().toLowerCase()).startsWith("#") || line.equals("")) continue;
            if (curRow == -1) {
                for (String s : line.split("\\s+")) {
                    if (s.length() > 1) {
                        throw new IOException("Scoring matrix header " + s + " is longer than 1 character, cannot parse");
                    }
                    validChars.add(Character.valueOf(s.charAt(0)));
                }
                curRow = 0;
                this.scoringMatrix = new int[validChars.size()][validChars.size()];
                continue;
            }
            String[] values = line.split("\\s+");
            if (values.length != validChars.size() + 1) {
                throw new IOException("Expected " + validChars.size() + " columns in matrix row " + curRow + " but instead found " + (values.length - 1));
            }
            if (values[0].charAt(0) != ((Character)validChars.get(curRow)).charValue() || values[0].length() > 1) {
                throw new IOException("Scoring matrix must be symetric (expected " + validChars.get(curRow) + " but saw " + values[0] + ")");
            }
            for (int index = 1; index < values.length; ++index) {
                this.scoringMatrix[curRow][index - 1] = Integer.valueOf(values[index]);
            }
            ++curRow;
        }
        for (int index = 0; index < validChars.size(); ++index) {
            int n = index;
            this.reverseLookup[Character.toUpperCase((char)((Character)validChars.get((int)index)).charValue())] = n;
            this.reverseLookup[Character.toLowerCase((char)((Character)validChars.get((int)index)).charValue())] = n;
        }
    }

    public static ScoringMatrix getDefaultNuclMatrix() {
        if (defaultNuclMatrix == null) {
            try {
                defaultNuclMatrix = new ScoringMatrix(ScoringMatrix.class.getResourceAsStream("/data/NUC.4.4"), -10, -1);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get default nucl matrix...something is very wrong!", e);
            }
        }
        return defaultNuclMatrix;
    }

    public static ScoringMatrix getSimpleScoringMatrix(int match, int mismatch) {
        ScoringMatrix ret = new ScoringMatrix();
        ret.gapExtend = mismatch;
        ret.gapPenalty = mismatch;
        for (int index = 0; index < 127; ++index) {
            ret.reverseLookup[index] = -1;
        }
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            int n = c - 97;
            ret.reverseLookup[Character.toUpperCase((char)c)] = n;
            ret.reverseLookup[c] = n;
        }
        ret.scoringMatrix = new int[25][25];
        for (int row = 0; row < ret.scoringMatrix.length; ++row) {
            ret.scoringMatrix[row][row] = match;
            for (int col = row + 1; col < ret.scoringMatrix.length; ++col) {
                int n = mismatch;
                ret.scoringMatrix[col][row] = n;
                ret.scoringMatrix[row][col] = n;
            }
        }
        return ret;
    }

    public static ScoringMatrix getDefaultProteinMatrix() {
        if (defaultProtMatrix == null) {
            try {
                defaultProtMatrix = new ScoringMatrix(ScoringMatrix.class.getResourceAsStream("/data/blosum62.txt"), -10, -1);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get default protein scoring matrix...something is very wrong!", e);
            }
        }
        return defaultProtMatrix;
    }

    public static ScoringMatrix getDefaultProteinMetricMatrix() {
        if (defaultProtMetricMatrix == null) {
            try {
                defaultProtMetricMatrix = new ScoringMatrix(ScoringMatrix.class.getResourceAsStream("/data/blosum62_metric.txt"), -13, -4);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get default protein scoring matrix blosum62_metric...something is very wrong!", e);
            }
        }
        return defaultProtMetricMatrix;
    }

    public int score(Character b1, Character b2) {
        int i1 = this.reverseLookup[b1.charValue()];
        int i2 = this.reverseLookup[b2.charValue()];
        if (i1 == -1 || i2 == -1) {
            throw new IllegalArgumentException("Cannot score " + b1 + ", " + b2);
        }
        return this.scoringMatrix[i1][i2];
    }

    public int getGapOpen() {
        return this.gapPenalty;
    }

    public int getGapExtend() {
        return this.gapExtend;
    }

    public int getFrameshiftPenalty() {
        return this.frameshiftPenalty;
    }

    public int getIndelPenalty() {
        return this.gapPenalty + this.gapExtend;
    }

    public static InputStream getDefaultProteinMatrixStream() {
        return ScoringMatrix.class.getResourceAsStream("/data/blosum62.txt");
    }

    public static InputStream getDefaultProteinMatrixMetricStream() {
        return ScoringMatrix.class.getResourceAsStream("/data/blosum62_metric.txt");
    }
}

