/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.IndexedSeqReader;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QSeqReader
implements SeqReader {
    private List<String> seqids;
    private int seqIndex = 0;
    private IndexedSeqReader seqReader;
    private IndexedSeqReader qualReader = null;
    private SequenceFormat format;
    private boolean validate;

    public QSeqReader(File seqFile, File qualFile) throws IOException {
        this(seqFile, qualFile, true);
    }

    public QSeqReader(File seqFile, File qualFile, boolean validate) throws IOException {
        this.format = SeqUtils.guessFileFormat(seqFile);
        SequenceFormat qualFormat = SeqUtils.guessFileFormat(qualFile);
        if (this.format == SequenceFormat.FASTA && qualFormat == SequenceFormat.FASTA) {
            this.seqReader = new IndexedSeqReader(seqFile);
            this.qualReader = new IndexedSeqReader(qualFile, false, false);
            this.seqids = this.seqReader.getSeqIds();
            if (validate) {
                HashSet<String> qualIds = new HashSet<String>(this.qualReader.getSeqIdSet());
                HashSet<String> tmpSeqIds = new HashSet<String>(this.seqids);
                tmpSeqIds.removeAll(qualIds);
                qualIds.removeAll(this.seqids);
                if (!qualIds.isEmpty() || !tmpSeqIds.isEmpty()) {
                    throw new IOException("Quality and sequence files don't contain the same sequences, non-matched qual-ids=" + qualIds + " non-matched seqids=" + tmpSeqIds);
                }
            }
        } else {
            throw new IOException("Both quality and sequence file must be in fasta format for reading from seperate files [sequence file format detected as " + (Object)((Object)this.format) + " qual file format detected as " + (Object)((Object)qualFormat));
        }
        this.validate = validate;
    }

    @Override
    public SequenceFormat getFormat() {
        return this.format;
    }

    public Sequence readNextSequence() throws IOException {
        if (this.seqIndex == this.seqids.size()) {
            return null;
        }
        return this.readSeq(this.seqids.get(this.seqIndex++));
    }

    public List<String> getSeqIds() {
        return Collections.unmodifiableList(this.seqids);
    }

    public byte[] readQual(String seqid) throws IOException {
        if (this.qualReader == null) {
            throw new IOException("No quality reader associated");
        }
        Sequence qualSeq = this.qualReader.readSeq(seqid);
        String[] lexemes = qualSeq.getSeqString().trim().split("\\s+");
        byte[] qual = new byte[lexemes.length];
        for (int index = 0; index < lexemes.length; ++index) {
            qual[index] = Byte.valueOf(lexemes[index]);
        }
        return qual;
    }

    public Sequence readPlainSequence(String seqid) throws IOException {
        return this.seqReader.readSeq(seqid);
    }

    public QSequence readSeq(String seqid) throws IOException {
        byte[] qual;
        Sequence seq;
        block6: {
            seq = this.seqReader.readSeq(seqid);
            qual = null;
            try {
                qual = this.readQual(seqid);
            }
            catch (IOException e) {
                if (!this.validate) break block6;
                throw e;
            }
        }
        if (this.validate) {
            int unalignedLength = SeqUtils.getUnalignedSeqString(seq.getSeqString()).length();
            if (unalignedLength != qual.length) {
                throw new IOException("Sequence " + seq.getSeqName() + " length [" + seq.getSeqString().length() + "] doesn't equal quality sequence length [" + qual.length + "]");
            }
        } else if (qual == null) {
            qual = new byte[SeqUtils.getUnalignedSeqString(seq.getSeqString()).length()];
        }
        return new QSequence(seq, qual);
    }

    @Override
    public void close() throws IOException {
        this.seqReader.close();
        if (this.qualReader != null) {
            this.qualReader.close();
        }
    }
}

