## ----include=FALSE-------------------------------------------------------
knitr::opts_chunk$set(eval = FALSE)

## ----setup, include=FALSE------------------------------------------------
#  knitr::opts_chunk$set(echo = TRUE)

## ---- eval = FALSE-------------------------------------------------------
#  library("SPARQL")
#  endpoint = "https://opensparql.sbgenomics.com/blazegraph/namespace/tcga_metadata_kb/sparql"
#  query = "
#  prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>
#  prefix tcga: <https://www.sbgenomics.com/ontologies/2014/11/tcga#>
#  
#  select distinct ?case ?sample ?file_name ?path ?xs_label ?subtype_label
#  where
#  {
#   ?case a tcga:Case .
#   ?case tcga:hasDiseaseType ?disease_type .
#   ?disease_type rdfs:label 'Lung Adenocarcinoma' .
#  
#   ?case tcga:hasHistologicalDiagnosis ?hd .
#   ?hd rdfs:label 'Lung Adenocarcinoma Mixed Subtype' .
#  
#   ?case tcga:hasFollowUp ?follow_up .
#   ?follow_up tcga:hasDaysToLastFollowUp ?days_to_last_follow_up .
#   filter(?days_to_last_follow_up>550)
#  
#   ?follow_up tcga:hasVitalStatus ?vital_status .
#   ?vital_status rdfs:label ?vital_status_label .
#   filter(?vital_status_label='Alive')
#  
#   ?case tcga:hasDrugTherapy ?drug_therapy .
#   ?drug_therapy tcga:hasPharmaceuticalTherapyType ?pt_type .
#   ?pt_type rdfs:label ?pt_type_label .
#   filter(?pt_type_label='Chemotherapy')
#  
#   ?case tcga:hasSample ?sample .
#   ?sample tcga:hasSampleType ?st .
#   ?st rdfs:label ?st_label
#   filter(?st_label='Primary Tumor')
#  
#   ?sample tcga:hasFile ?file .
#   ?file rdfs:label ?file_name .
#  
#   ?file tcga:hasStoragePath ?path.
#  
#   ?file tcga:hasExperimentalStrategy ?xs.
#   ?xs rdfs:label ?xs_label .
#   filter(?xs_label='WXS')
#  
#   ?file tcga:hasDataSubtype ?subtype .
#   ?subtype rdfs:label ?subtype_label
#  
#  }
#  
#  "
#  qd <- SPARQL(endpoint, query)
#  df <- qd$results
#  head(df)

## ------------------------------------------------------------------------
#  # api(api_url = base, auth_token = auth_token, path = "action/files/get_ids",
#  #     method = "POST", query = None, data = filelist)
#  df.path <- df[,"path"]
#  df.path

## ------------------------------------------------------------------------
#  library("sevenbridges")
#  a = Auth(platform = "cgc", token = "your_cgc_token")
#  # get id (only works for CGC platform)
#  ids = a$get_id_from_path(df.path)
#  # copy file from id to project with controlled access
#  (p = a$project(id = "tengfei/control-test"))
#  a$copyFile(ids, p$id)

## ------------------------------------------------------------------------
#  library("sevenbridges")
#  # create an Auth object
#  a = Auth(url = "https://cgc-datasets-api.sbgenomics.com/",
#           token = "your_cgc_token")
#  a$api(path = "datasets")

## ------------------------------------------------------------------------
#  a = Auth(url = "https://cgc-datasets-api.sbgenomics.com/datasets/tcga/v0",
#           token = "your_cgc_token")
#  (res = a$api())  # default method is GET
#  # list all resources/entities
#  names(res$"_links")

## ------------------------------------------------------------------------
#  (res = a$api(path = "files"))

## ------------------------------------------------------------------------
#  a$api(path = "files/schema")

## ------------------------------------------------------------------------
#  (res = a$api(path = "files"))
#  get_id = function(obj){
#     sapply(obj$"_embedded"$files, function(x) x$id)
#  }
#  ids = get_id(res)
#  # create CGC auth
#  a_cgc = Auth(platform = "cgc", token = a$token)
#  a_cgc$copyFile(id = ids, project = "tengfei/tcga-demo")

## ------------------------------------------------------------------------
#  body = list(
#      entity = "samples",
#      hasCase = "0004D251-3F70-4395-B175-C94C2F5B1B81"
#  )
#  a$api(path = "query", body = body, method = "POST")

## ------------------------------------------------------------------------
#  a$api(path = "query/total", body = body, method = "POST")

## ------------------------------------------------------------------------
#  httr::content(
#      api(token = a$token,
#          base_url = "https://cgc-datasets-api.sbgenomics.com/datasets/tcga/v0/samples/9259E9EE-7279-4B62-8512-509CB705029C"))

## ------------------------------------------------------------------------
#  body = list(
#     "entity" = "cases",
#     "hasAgeAtDiagnosis" = list(
#         "filter" = list(
#             "gt" = 10,
#             "lt" = 50
#         )
#     )
#  )
#  a$api(path = "query", body = body, method = "POST")

## ------------------------------------------------------------------------
#  body = list(
#     "entity" = "cases",
#     "hasAgeAtDiagnosis" = list(
#         "filter" = list(
#             "gt" = 10,
#             "lt" = 50
#         )
#     ),
#     "hasDiseaseType" = "Kidney Chromophobe"
#  )
#  a$api(path = "query", body = body, method = "POST")

## ------------------------------------------------------------------------
#  body = list(
#      "entity" = "cases",
#      "hasSample" = list(
#          "hasSampleType" = "Primary Tumor",
#          "hasPortion" = list(
#              "hasPortionNumber" = 11
#          )
#          ),
#      "hasNewTumorEvent" = list(
#          "hasNewTumorAnatomicSite" = c("Liver", "Pancreas"),
#          "hasNewTumorEventType" = list(
#              "filter" = list(
#                  "contains" = "Recurrence"
#              )
#          )
#      )
#  )
#  a$api(path = "query", body = body, method = "POST")

## ------------------------------------------------------------------------
#  httr::content(
#      api(token = a$token,
#          base_url = "https://cgc-datasets-api.sbgenomics.com/datasets/tcga/v0/cases/0004D251-3F70-4395-B175-C94C2F5B1B81"))

## ------------------------------------------------------------------------
#  get_id = function(obj) sapply(obj$"_embedded"$files, function(x) x$id)
#  names(res)
#  body = list("entity" = "cases",
#              "hasSample" = list(
#                  "hasSampleType" = "Primary Tumor",
#                  "hasPortion" = list(
#                      "hasPortionNumber" = 11,
#                      "hasID" = "TCGA-DD-AAVP-01A-11"
#                  )
#              ),
#              "hasNewTumorEvent" = list(
#                  "hasNewTumorAnatomicSite" = "Liver",
#                  "hasNewTumorEventType" = "Intrahepatic Recurrence"
#              )
#  )
#  (res = a$api(path = "files", body = body))
#  get_id(res)

