## ----load.package, echo=FALSE-----------------------------
  options(width=60)
  library(synergyfinder)

## ----loading.data-----------------------------------------
data("mathews_screening_data")
head(mathews_screening_data)

## ---------------------------------------------------------
dose.response.mat <- ReshapeData(mathews_screening_data,
                                 data.type = "viability")

## ---------------------------------------------------------
str(dose.response.mat)

## ----fig.show='hide'--------------------------------------
  PlotDoseResponse(dose.response.mat)

## ----fig.show='hide'--------------------------------------
  PlotDoseResponse(dose.response.mat, save.file = TRUE)

## ---------------------------------------------------------
  synergy.score <- CalculateSynergy(data = dose.response.mat,
                                      method = "ZIP",
                                      correction = TRUE,
                                      Emin = 0, Emax = 100)

## ---------------------------------------------------------
  str(synergy.score)

## ----fig.show='hide'--------------------------------------
  PlotSynergy(synergy.score, type = "all", save.file = TRUE)

