### R code from vignette source 'ternarynet.Rnw'

###################################################
### code chunk number 1: ternarynet.Rnw:43-44
###################################################
library(ternarynet)


###################################################
### code chunk number 2: ternarynet.Rnw:59-65
###################################################
perturbationObj <- matrix(c(
1,0,0,0,0,	
0,1,0,0,0,	
0,0,1,0,0,	
0,0,0,1,0,
0,0,0,0,1),nrow=5,ncol=5,byrow=T)	


###################################################
### code chunk number 3: ternarynet.Rnw:67-68
###################################################
perturbationObj


###################################################
### code chunk number 4: ternarynet.Rnw:72-78
###################################################
steadyStateObj<-matrix(c(
 1, 0, 0, 0, 0,	
 0, 1, 1, 1, 0,
 0, 1, 1, 1, 0,	
 0, 1, 1, 1, 0,
 1, 0, 0, 0, 1),nrow=5,ncol=5,byrow=T)


###################################################
### code chunk number 5: ternarynet.Rnw:80-81
###################################################
steadyStateObj


###################################################
### code chunk number 6: ternarynet.Rnw:93-94
###################################################
tnfit <- tnetfit(steadyStateObj, perturbationObj, xSeed=11235)


###################################################
### code chunk number 7: ternarynet.Rnw:100-101
###################################################
plotTraces(tnfit)


###################################################
### code chunk number 8: ternarynet.Rnw:107-108
###################################################
tnpost <- tnetpost(tnfit, xSeed=11235)


###################################################
### code chunk number 9: ternarynet.Rnw:119-121
###################################################
attractorSummary(tnpost)
attractorSummary(tnpost, wildtype=FALSE)


###################################################
### code chunk number 10: ternarynet.Rnw:135-136
###################################################
graphPosterior(tnpost)


###################################################
### code chunk number 11: ternarynet.Rnw:147-148
###################################################
sessionInfo()


