## ----style, echo=FALSE, results="asis", message=FALSE--------------------
knitr::opts_chunk$set(tidy = FALSE,
		   message = FALSE)

## ----echo=FALSE, results="hide", message=FALSE---------------------------
library("ape")
library("Biostrings")
library("treeio")

## ------------------------------------------------------------------------
file <- system.file("extdata/BEAST", "beast_mcc.tree", package="treeio")
beast <- read.beast(file)
beast

## ------------------------------------------------------------------------
get.fields(beast)

## ----fig.width=12, fig.height=10, warning=FALSE, fig.align="center"------
brstfile <- system.file("extdata/PAML_Baseml", "rst", package="treeio")
brst <- read.paml_rst(brstfile)
brst

## ------------------------------------------------------------------------
crstfile <- system.file("extdata/PAML_Codeml", "rst", package="treeio")
crst <- read.paml_rst(crstfile)
crst

## ------------------------------------------------------------------------
mlcfile <- system.file("extdata/PAML_Codeml", "mlc", package="treeio")
mlc <- read.codeml_mlc(mlcfile)
mlc

## ------------------------------------------------------------------------
ml <- read.codeml(crstfile, mlcfile)
ml

## ----warning=FALSE-------------------------------------------------------
nwk <- system.file("extdata/HYPHY", "labelledtree.tree", package="treeio")
ancseq <- system.file("extdata/HYPHY", "ancseq.nex", package="treeio")
tipfas <- system.file("extdata", "pa.fas", package="treeio")
hy <- read.hyphy(nwk, ancseq, tipfas)
hy

## ----fig.width=4, fig.height=6, width=60, warning=FALSE, fig.align="center"----
r8s <- read.r8s(system.file("extdata/r8s", "H3_r8s_output.log", package="treeio"))
r8s

## ----fig.width=12, fig.height=10, width=60, warning=FALSE, fig.align="center"----
raxml_file <- system.file("extdata/RAxML", "RAxML_bipartitionsBranchLabels.H3", package="treeio")
raxml <- read.raxml(raxml_file)
raxml

## ------------------------------------------------------------------------
nhxfile <- system.file("extdata/NHX", "ADH.nhx", package="treeio")
nhx <- read.nhx(nhxfile)
nhx
## ggtree(nhx) + geom_tiplab() + geom_point(aes(color=S), size=5, alpha=.5) +
##     theme(legend.position="right") +
##     geom_text(aes(label=branch.length, x=branch), vjust=-.5) +
##     xlim(NA, 0.3)

## ------------------------------------------------------------------------
phyfile <- system.file("extdata", "sample.phy", package="treeio")
phylip <- read.phylip(phyfile)
phylip

## ------------------------------------------------------------------------
jpf <- system.file("extdata/sample.jplace",  package="treeio")
jp <- read.jplace(jpf)
print(jp)

## ------------------------------------------------------------------------
## get only best hit
get.placements(jp, by="best")
## get all placement
get.placements(jp, by="all")

