/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.modelling;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.data.interpolation.AverageInterpolator;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.dk.SsfFunction;
import jdplus.toolkit.base.core.ssf.dk.SsfFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import lombok.Generated;

public final class Interpolation {
    public static TsData averageInterpolation(TsData input) {
        double[] interpolated = AverageInterpolator.interpolator().interpolate(input.getValues(), null);
        return TsData.ofInternal((TsPeriod)input.getStart(), (double[])interpolated);
    }

    public static TsData airlineInterpolation(TsData input) {
        TsPeriod start = input.getStart();
        SarimaOrders spec = SarimaOrders.airline((int)start.annualFrequency());
        DoubleSeq values = input.getValues();
        SarimaMapping mapping = SarimaMapping.of((SarimaOrders)spec);
        SsfData data = new SsfData(values);
        SsfFunction fn = SsfFunction.builder((ISsfData)data, (IParametricMapping)mapping, s -> SsfArima.ssf((IArimaModel)s)).useFastAlgorithm(false).useScalingFactor(true).useLog(false).useMaximumLikelihood(true).build();
        LevenbergMarquardtMinimizer fmin = LevenbergMarquardtMinimizer.builder().build();
        fmin.minimize((ISsqFunctionPoint)fn.ssqEvaluate(mapping.getDefaultParameters()));
        SsfFunctionPoint rslt = (SsfFunctionPoint)fmin.getResult();
        ISsf ssf = rslt.getSsf();
        DataBlockStorage fs = DkToolkit.fastSmooth((ISsf)ssf, (ISsfData)data);
        double[] g = input.getValues().toArray();
        for (int i = 0; i < g.length; ++i) {
            if (!Double.isNaN(g[i])) continue;
            g[i] = ssf.loading().ZX(i, fs.block(i));
        }
        return TsData.ofInternal((TsPeriod)input.getStart(), (double[])g);
    }

    @Generated
    private Interpolation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

