/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import java.util.Formatter;
import java.util.Locale;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.ParameterType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class Parameter {
    private final double value;
    private final ParameterType type;
    private static final Parameter UNDEFINED = new Parameter(0.0, ParameterType.Undefined);
    private static final Parameter ZERO = new Parameter(0.0, ParameterType.Fixed);

    public boolean isFixed() {
        return this.type == ParameterType.Fixed;
    }

    public boolean isEstimated() {
        return this.type == ParameterType.Estimated;
    }

    public boolean isDefined() {
        return this.type != ParameterType.Undefined;
    }

    public boolean isFree() {
        return this.type != ParameterType.Fixed;
    }

    public static boolean hasFreeParameters(Parameter[] spec) {
        for (int i = 0; i < spec.length; ++i) {
            if (!spec[i].isFree()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParameters(Parameter[] spec, ParameterType type) {
        for (int i = 0; i < spec.length; ++i) {
            if (spec[i].type != type) continue;
            return true;
        }
        return false;
    }

    public static int freeParametersCount(Parameter[] spec) {
        int n = 0;
        for (int i = 0; i < spec.length; ++i) {
            if (!spec[i].isFree()) continue;
            ++n;
        }
        return n;
    }

    public static int fixedParametersCount(Parameter[] spec) {
        int n = 0;
        for (int i = 0; i < spec.length; ++i) {
            if (!spec[i].isFixed()) continue;
            ++n;
        }
        return n;
    }

    public static Parameter[] resetParameters(Parameter[] spec) {
        if (spec == null || spec.length == 0) {
            return spec;
        }
        return Parameter.make(spec.length);
    }

    public static Parameter[] resetParameters(Parameter[] spec, Parameter[] ref) {
        if (spec == null || spec.length == 0) {
            return spec;
        }
        Parameter[] nspec = (Parameter[])spec.clone();
        for (int i = 0; i < spec.length; ++i) {
            nspec[i] = ref == null || i >= ref.length || !ref[i].isFixed() ? UNDEFINED : ref[i];
        }
        return nspec;
    }

    public static Parameter[] freeParameters(Parameter[] spec) {
        if (spec == null || spec.length == 0) {
            return spec;
        }
        Parameter[] nspec = (Parameter[])spec.clone();
        for (int i = 0; i < nspec.length; ++i) {
            nspec[i] = new Parameter(nspec[i].value, ParameterType.Initial);
        }
        return nspec;
    }

    public static Parameter[] freeParameters(Parameter[] spec, Parameter[] ref) {
        if (spec == null || spec.length == 0) {
            return spec;
        }
        Parameter[] nspec = (Parameter[])spec.clone();
        for (int i = 0; i < nspec.length; ++i) {
            nspec[i] = ref == null || i >= ref.length || !ref[i].isFixed() ? new Parameter(spec[i].value, ParameterType.Initial) : ref[i];
        }
        return nspec;
    }

    public static Parameter[] fixParameters(Parameter[] spec) {
        if (spec == null || spec.length == 0) {
            return spec;
        }
        Parameter[] nspec = (Parameter[])spec.clone();
        for (int i = 0; i < nspec.length; ++i) {
            if (!nspec[i].isDefined() || nspec[i].isFixed()) continue;
            nspec[i] = new Parameter(nspec[i].value, ParameterType.Fixed);
        }
        return nspec;
    }

    public static Parameter of(double val, ParameterType t) {
        if (t == ParameterType.Undefined) {
            return UNDEFINED;
        }
        return new Parameter(val, t);
    }

    public static Parameter undefined() {
        return UNDEFINED;
    }

    public static Parameter fixed(double value) {
        return new Parameter(value, ParameterType.Fixed);
    }

    public static Parameter initial(double value) {
        return new Parameter(value, ParameterType.Initial);
    }

    public static Parameter estimated(double value) {
        return new Parameter(value, ParameterType.Estimated);
    }

    public static Parameter[] of(double[] values, ParameterType type) {
        if (type == ParameterType.Undefined) {
            return Parameter.make(values.length);
        }
        Parameter[] p = new Parameter[values.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new Parameter(values[i], type);
        }
        return p;
    }

    public static Parameter[] of(DoubleSeq values, ParameterType type) {
        if (type == ParameterType.Undefined) {
            return Parameter.make(values.length());
        }
        Parameter[] p = new Parameter[values.length()];
        DoubleSeqCursor cur = values.cursor();
        for (int i = 0; i < p.length; ++i) {
            p[i] = new Parameter(cur.getAndNext(), type);
        }
        return p;
    }

    public static Parameter[] make(int n) {
        Parameter[] all = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            all[i] = UNDEFINED;
        }
        return all;
    }

    public static Parameter[] zero(int n) {
        Parameter[] all = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            all[i] = ZERO;
        }
        return all;
    }

    public static Parameter zero() {
        return ZERO;
    }

    public static boolean isFree(Parameter[] spec) {
        if (spec == null) {
            return true;
        }
        for (int i = 0; i < spec.length; ++i) {
            if (spec[i].isFree()) continue;
            return false;
        }
        return true;
    }

    public static double[] values(Parameter[] spec) {
        if (spec.length == 0) {
            return Doubles.EMPTYARRAY;
        }
        double[] val = new double[spec.length];
        for (int i = 0; i < val.length; ++i) {
            val[i] = spec[i].value;
        }
        return val;
    }

    public static double[] values(Parameter[] spec, double defvalue) {
        if (spec.length == 0) {
            return Doubles.EMPTYARRAY;
        }
        double[] val = new double[spec.length];
        for (int i = 0; i < val.length; ++i) {
            val[i] = spec[i].getType() == ParameterType.Undefined ? defvalue : spec[i].value;
        }
        return val;
    }

    public static boolean isDefault(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == UNDEFINED) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefined(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != UNDEFINED) continue;
            return false;
        }
        return true;
    }

    public static boolean hasFixedParameters(Parameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].isFixed()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefinedParameters(Parameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].isDefined()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFixed(Parameter p) {
        if (p == null) {
            return false;
        }
        return p.isFixed();
    }

    public static boolean isDefined(Parameter p) {
        return p != null && p != UNDEFINED;
    }

    public static boolean isZero(Parameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].value == 0.0) continue;
            return false;
        }
        return true;
    }

    public Parameter withType(ParameterType type) {
        if (type == ParameterType.Undefined) {
            return UNDEFINED;
        }
        return new Parameter(this.value, type);
    }

    public String toString() {
        if (this.type == ParameterType.Undefined) {
            return "...";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(new Formatter(Locale.ROOT).format("%6g", this.value));
        switch (this.type) {
            case Fixed: {
                builder.append('f');
                break;
            }
            case Estimated: {
                builder.append('e');
            }
        }
        return builder.toString();
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public ParameterType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        ParameterType this$type = this.getType();
        ParameterType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        ParameterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Generated
    private Parameter(double value, ParameterType type) {
        this.value = value;
        this.type = type;
    }
}

