/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.modelling.highfreq.DataCleaning;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;

public final class CleanedData {
    private DataCleaning cleaning;
    private DoubleSeq data;
    private int[] positions;
    private TsDomain domain;

    public static CleanedData of(TsData data) {
        return new CleanedData(data, DataCleaning.of(data));
    }

    public static CleanedData of(TsData data, DataCleaning cleaning) {
        return new CleanedData(data, cleaning == null ? DataCleaning.of(data) : cleaning);
    }

    private CleanedData(TsData data, DataCleaning cleaning) {
        this.cleaning = cleaning;
        this.domain = data.getDomain();
        this.clean(cleaning, data);
    }

    public DoubleSeq getData() {
        return this.data;
    }

    private int tpos(int idx) {
        return this.positions == null ? idx : this.positions[idx];
    }

    public TsPeriod getPeriod(int idx) {
        return this.domain.get(this.tpos(idx));
    }

    public double getValue(int idx) {
        return this.data.get(idx);
    }

    public int size() {
        return this.data.length();
    }

    private void clean(DataCleaning cleaning, TsData s) {
        switch (cleaning) {
            case SUNDAYS: {
                this.cleanSundays(s);
                break;
            }
            case WEEKENDS: {
                this.cleanWeekEnds(s);
                break;
            }
            default: {
                this.set(s);
            }
        }
    }

    private void set(TsData s) {
        this.data = s.getValues();
    }

    private void cleanSundays(TsData s) {
        double[] tmp = new double[s.length()];
        int[] tpos = new int[tmp.length];
        TsPeriod start = s.getStart();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        DoubleSeqCursor cursor = s.getValues().cursor();
        int cur = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (pos != 7) {
                tpos[cur] = i;
                tmp[cur++] = cursor.getAndNext();
                ++pos;
                continue;
            }
            cursor.skip(1);
            pos = 1;
        }
        this.data = DoubleSeq.of(tmp, 0, cur);
        this.positions = Arrays.copyOf(tpos, cur);
    }

    private void cleanWeekEnds(TsData s) {
        double[] tmp = new double[s.length()];
        int[] tpos = new int[tmp.length];
        TsPeriod start = s.getStart();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        int i = 0;
        DoubleSeqCursor cursor = s.getValues().cursor();
        if (pos == 7) {
            cursor.skip(1);
            pos = 1;
            i = 1;
        }
        int cur = 0;
        while (i < tmp.length) {
            if (pos != 6) {
                tpos[cur] = i++;
                tmp[cur++] = cursor.getAndNext();
                ++pos;
                continue;
            }
            cursor.skip(2);
            pos = 1;
            i += 2;
        }
        this.data = DoubleSeq.of(tmp, 0, cur);
        this.positions = Arrays.copyOf(tpos, cur);
    }

    @Generated
    public DataCleaning getCleaning() {
        return this.cleaning;
    }

    @Generated
    public TsDomain getDomain() {
        return this.domain;
    }
}

