/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnostics;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsConfiguration;
import jdplus.toolkit.base.api.processing.Diagnostics;
import lombok.NonNull;

public class CoherenceDiagnosticsFactory<R>
implements SaDiagnosticsFactory<CoherenceDiagnosticsConfiguration, R> {
    public static final String DEF = "definition";
    public static final String BIAS = "annual totals";
    public static final String NAME = "Basic checks";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("definition", "annual totals"));
    private final CoherenceDiagnosticsConfiguration config;
    private final Function<R, CoherenceDiagnostics.Input> extractor;

    public CoherenceDiagnosticsFactory(@NonNull CoherenceDiagnosticsConfiguration config, @NonNull Function<R, CoherenceDiagnostics.Input> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public String getName() {
        return NAME;
    }

    public Diagnostics of(R rslts) {
        return CoherenceDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.General;
    }

    public int getOrder() {
        return 0;
    }

    public CoherenceDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public CoherenceDiagnosticsFactory<R> with(@NonNull CoherenceDiagnosticsConfiguration newConfig) {
        if (newConfig == null) {
            throw new NullPointerException("newConfig is marked non-null but is null");
        }
        return new CoherenceDiagnosticsFactory<R>(this.config, this.extractor);
    }
}

