/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.CrossCovarianceFunction;
import jdplus.toolkit.base.core.arima.ILinearProcess;

public final class BartlettApproximation {
    private static final int TRUNCATION_LIMIT = 1000;

    private BartlettApproximation() {
    }

    public static double standardDeviationOfVariance(ILinearProcess model, int samplesize) throws ArimaException {
        AutoCovarianceFunction acf = model.getAutoCovarianceFunction();
        int m = BartlettApproximation.calcTruncationPoint(acf);
        acf.prepare(m + 1);
        double var = acf.get(0);
        double v = 2.0 * var * var;
        for (int i = 1; i <= m; ++i) {
            double c = acf.get(i);
            v += 4.0 * c * c;
        }
        return Math.sqrt(v /= (double)samplesize);
    }

    private static int calcTruncationPoint(AutoCovarianceFunction acgf) {
        int b;
        int n = b = acgf.hasBound() ? acgf.getBound() : 1000;
        if (b > 1000) {
            b = 1000;
        }
        return b;
    }

    private static double[] ac(ILinearProcess model) throws ArimaException {
        AutoCovarianceFunction acgf = model.getAutoCovarianceFunction();
        int m = BartlettApproximation.calcTruncationPoint(acgf);
        acgf.prepare(m + 1);
        double[] c = new double[m + 1];
        double var = acgf.get(0);
        c[0] = 1.0;
        for (int i = 1; i <= m; ++i) {
            c[i] = acgf.get(i) / var;
        }
        return c;
    }

    public static class CrossCorrelation {
        private final ILinearProcess xmodel;
        private final ILinearProcess ymodel;
        private final double[] xc;
        private final double[] yc;
        private final double[] xycp;
        private final double[] xycn;

        public CrossCorrelation(ILinearProcess X, ILinearProcess Y) {
            int i;
            this.xmodel = X;
            this.ymodel = Y;
            this.xc = BartlettApproximation.ac(this.xmodel);
            this.yc = BartlettApproximation.ac(this.ymodel);
            CrossCovarianceFunction ccgf = new CrossCovarianceFunction(X, Y);
            int mn = ccgf.hasLBound() ? -ccgf.getLBound() : 1000;
            int mp = ccgf.hasUBound() ? ccgf.getUBound() : 1000;
            this.xycn = new double[mn + 1];
            this.xycp = new double[mp + 1];
            ccgf.prepare(-mn - 1, mp + 1);
            double denom = Math.sqrt(X.getAutoCovarianceFunction().get(0) * Y.getAutoCovarianceFunction().get(0));
            for (i = 0; i >= -mn; --i) {
                this.xycn[-i] = ccgf.get(i) / denom;
            }
            for (i = 0; i <= mp; ++i) {
                this.xycp[i] = ccgf.get(i) / denom;
            }
        }

        private double xycp(int i) {
            return i >= this.xycp.length ? 0.0 : this.xycp[i];
        }

        private double xycn(int i) {
            return i >= this.xycn.length ? 0.0 : this.xycn[i];
        }

        private double xc(int i) {
            return i >= this.xc.length ? 0.0 : this.xc[i];
        }

        private double yc(int i) {
            return i >= this.yc.length ? 0.0 : this.yc[i];
        }

        public double get(int lag) throws ArimaException {
            if (lag >= 0) {
                return this.xycp(lag);
            }
            return this.xycn(-lag);
        }

        public double standardDeviation(int lag, int samplesize) throws ArimaException {
            double v = 0.0;
            int mn = this.xycn.length - 1;
            int mp = this.xycp.length - 1;
            for (int i = -mn; i <= mp; ++i) {
                int I = Math.abs(i);
                int ipk = i + lag;
                int imk = i - lag;
                int IPK = Math.abs(ipk);
                double rxi = this.xc(I);
                double ryi = this.yc(I);
                double ryipk = this.yc(IPK);
                double rxyipk = 0.0;
                double rxyimk = 0.0;
                double rxyk = 0.0;
                double rxymi = 0.0;
                double rxyi = 0.0;
                if (ipk <= mp) {
                    if (ipk >= 0) {
                        rxyipk = this.xycp[ipk];
                    } else if (-ipk <= mn) {
                        rxyipk = this.xycn[-ipk];
                    }
                }
                if (imk <= mp) {
                    if (imk >= 0) {
                        rxyimk = this.xycp[imk];
                    } else if (-imk <= mn) {
                        rxyimk = this.xycn[-imk];
                    }
                }
                if (lag <= mp) {
                    if (lag >= 0) {
                        rxyk = this.xycp[lag];
                    } else if (-lag <= mn) {
                        rxyk = this.xycn[-lag];
                    }
                }
                if (-i <= mp) {
                    if (-i >= 0) {
                        rxymi = this.xycp[-i];
                    } else if (i <= mn) {
                        rxymi = this.xycn[i];
                    }
                }
                if (i <= mp) {
                    if (i >= 0) {
                        rxyi = this.xycp[i];
                    } else if (-i <= mn) {
                        rxyi = this.xycn[-i];
                    }
                }
                v += rxi * ryi + rxyimk * rxyipk - 2.0 * rxyk * (rxi * rxyipk + rxymi * ryipk) + rxyk * rxyk * (rxyi * rxyi + 0.5 * rxi * rxi + 0.5 * ryi * ryi);
            }
            return Math.sqrt(v / (double)(samplesize - lag));
        }

        public ILinearProcess getX() {
            return this.xmodel;
        }

        public ILinearProcess getY() {
            return this.ymodel;
        }
    }

    public static class AutoCorrelation {
        private final ILinearProcess model;
        private final double[] ac;

        public AutoCorrelation(ILinearProcess m) {
            this.model = m;
            this.ac = BartlettApproximation.ac(m);
        }

        public double get(int lag) throws ArimaException {
            return lag >= this.ac.length ? 0.0 : this.ac[lag];
        }

        public double standardDeviation(int lag, int samplesize) throws ArimaException {
            int k = lag < 0 ? -lag : lag;
            double rk = this.get(k);
            double v = 1.0 - rk * rk;
            int m = this.ac.length - 1;
            for (int j = 1; j <= m; ++j) {
                double rj = this.get(j);
                double rjpk = this.get(j + k);
                double rjmk = j - k < 0 ? this.get(k - j) : this.get(j - k);
                v += 2.0 * (rj * rj * (1.0 + 2.0 * rk * rk) + rjpk * rjmk - 2.0 * rj * rk * (rjpk + rjmk));
            }
            return Math.sqrt(v / (double)samplesize);
        }
    }
}

